/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.master.tableOps.namespace.create;

import java.util.Map;
import org.apache.accumulo.core.clientImpl.ClientContext;
import org.apache.accumulo.core.clientImpl.Namespace;
import org.apache.accumulo.core.clientImpl.Tables;
import org.apache.accumulo.core.clientImpl.thrift.TableOperation;
import org.apache.accumulo.fate.Repo;
import org.apache.accumulo.fate.zookeeper.IZooReaderWriter;
import org.apache.accumulo.fate.zookeeper.ZooUtil;
import org.apache.accumulo.master.Master;
import org.apache.accumulo.master.tableOps.MasterRepo;
import org.apache.accumulo.master.tableOps.Utils;
import org.apache.accumulo.master.tableOps.namespace.create.FinishCreateNamespace;
import org.apache.accumulo.master.tableOps.namespace.create.NamespaceInfo;
import org.apache.accumulo.server.ServerContext;
import org.apache.accumulo.server.tables.TableManager;
import org.apache.accumulo.server.util.NamespacePropUtil;

class PopulateZookeeperWithNamespace
extends MasterRepo {
    private static final long serialVersionUID = 1L;
    private NamespaceInfo namespaceInfo;

    PopulateZookeeperWithNamespace(NamespaceInfo ti) {
        this.namespaceInfo = ti;
    }

    @Override
    public long isReady(long id, Master environment) throws Exception {
        return Utils.reserveNamespace(environment, this.namespaceInfo.namespaceId, id, true, false, TableOperation.CREATE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Repo<Master> call(long tid, Master master) throws Exception {
        Utils.getTableNameLock().lock();
        try {
            Utils.checkNamespaceDoesNotExist(master.getContext(), this.namespaceInfo.namespaceName, this.namespaceInfo.namespaceId, TableOperation.CREATE);
            TableManager.prepareNewNamespaceState((IZooReaderWriter)master.getContext().getZooReaderWriter(), (String)master.getInstanceID(), (Namespace.ID)this.namespaceInfo.namespaceId, (String)this.namespaceInfo.namespaceName, (ZooUtil.NodeExistsPolicy)ZooUtil.NodeExistsPolicy.OVERWRITE);
            for (Map.Entry<String, String> entry : this.namespaceInfo.props.entrySet()) {
                NamespacePropUtil.setNamespaceProperty((ServerContext)master.getContext(), (Namespace.ID)this.namespaceInfo.namespaceId, (String)entry.getKey(), (String)entry.getValue());
            }
            Tables.clearCache((ClientContext)master.getContext());
            FinishCreateNamespace finishCreateNamespace = new FinishCreateNamespace(this.namespaceInfo);
            return finishCreateNamespace;
        }
        finally {
            Utils.getTableNameLock().unlock();
        }
    }

    @Override
    public void undo(long tid, Master master) throws Exception {
        master.getTableManager().removeNamespace(this.namespaceInfo.namespaceId);
        Tables.clearCache((ClientContext)master.getContext());
        Utils.unreserveNamespace(master, this.namespaceInfo.namespaceId, tid, true);
    }
}

