/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.master.tableOps.tableExport;

import org.apache.accumulo.core.clientImpl.Namespace;
import org.apache.accumulo.core.clientImpl.Table;
import org.apache.accumulo.fate.Repo;
import org.apache.accumulo.master.Master;
import org.apache.accumulo.master.tableOps.MasterRepo;
import org.apache.accumulo.master.tableOps.Utils;
import org.apache.accumulo.master.tableOps.tableExport.ExportInfo;
import org.apache.accumulo.master.tableOps.tableExport.WriteExportFiles;
import org.apache.hadoop.fs.Path;

public class ExportTable
extends MasterRepo {
    private static final long serialVersionUID = 1L;
    private final ExportInfo tableInfo = new ExportInfo();
    public static final int VERSION = 1;
    public static final String DATA_VERSION_PROP = "srcDataVersion";
    public static final String EXPORT_VERSION_PROP = "exportVersion";

    public ExportTable(Namespace.ID namespaceId, String tableName, Table.ID tableId, String exportDir) {
        this.tableInfo.tableName = tableName;
        this.tableInfo.exportDir = exportDir;
        this.tableInfo.tableID = tableId;
        this.tableInfo.namespaceID = namespaceId;
    }

    @Override
    public long isReady(long tid, Master environment) throws Exception {
        return Utils.reserveHdfsDirectory(environment, new Path(this.tableInfo.exportDir).toString(), tid);
    }

    @Override
    public Repo<Master> call(long tid, Master env) {
        return new WriteExportFiles(this.tableInfo);
    }

    @Override
    public void undo(long tid, Master env) throws Exception {
        Utils.unreserveHdfsDirectory(env, new Path(this.tableInfo.exportDir).toString(), tid);
    }
}

