/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.master.tableOps.tableImport;

import java.io.IOException;
import java.util.Arrays;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.fate.Repo;
import org.apache.accumulo.master.Master;
import org.apache.accumulo.master.tableOps.MasterRepo;
import org.apache.accumulo.master.tableOps.tableImport.ImportedTableInfo;
import org.apache.accumulo.master.tableOps.tableImport.MapImportFileNames;
import org.apache.accumulo.server.ServerConstants;
import org.apache.accumulo.server.tablets.UniqueNameAllocator;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CreateImportDir
extends MasterRepo {
    private static final Logger log = LoggerFactory.getLogger(CreateImportDir.class);
    private static final long serialVersionUID = 1L;
    private ImportedTableInfo tableInfo;

    CreateImportDir(ImportedTableInfo ti) {
        this.tableInfo = ti;
    }

    @Override
    public Repo<Master> call(long tid, Master master) throws Exception {
        UniqueNameAllocator namer = master.getContext().getUniqueNameAllocator();
        Path exportDir = new Path(this.tableInfo.exportDir);
        Object[] tableDirs = ServerConstants.getTablesDirs((AccumuloConfiguration)master.getConfiguration());
        log.info("Looking for matching filesystem for " + exportDir + " from options " + Arrays.toString(tableDirs));
        Path base = master.getFileSystem().matchingFileSystem(exportDir, (String[])tableDirs);
        if (base == null) {
            throw new IOException(this.tableInfo.exportDir + " is not in a volume configured for Accumulo");
        }
        log.info("Chose base table directory of " + base);
        Path directory = new Path(base, this.tableInfo.tableId.canonicalID());
        Path newBulkDir = new Path(directory, "b-" + namer.getNextName());
        this.tableInfo.importDir = newBulkDir.toString();
        log.info("Using import dir: " + this.tableInfo.importDir);
        return new MapImportFileNames(this.tableInfo);
    }
}

