/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.master.util;

import com.google.common.base.Joiner;
import java.util.Arrays;
import java.util.List;
import org.apache.accumulo.core.clientImpl.Table;
import org.apache.accumulo.core.clientImpl.Tables;
import org.apache.accumulo.core.metadata.MetadataTable;
import org.apache.accumulo.core.metadata.RootTable;
import org.apache.accumulo.core.replication.ReplicationTable;
import org.apache.accumulo.core.util.Validator;

public class TableValidators {
    public static final String VALID_ID_REGEX = "^([a-z0-9]+)$";
    public static final Validator<String> VALID_NAME = new Validator<String>(){

        public boolean test(String tableName) {
            return tableName != null && tableName.matches("^(\\w+\\.)?(\\w+)$");
        }

        public String invalidMessage(String tableName) {
            if (tableName == null) {
                return "Table name cannot be null";
            }
            return "Table names must only contain word characters (letters, digits, and underscores): " + tableName;
        }
    };
    public static final Validator<Table.ID> VALID_ID = new Validator<Table.ID>(){

        public boolean test(Table.ID tableId) {
            return tableId != null && (RootTable.ID.equals((Object)tableId) || MetadataTable.ID.equals((Object)tableId) || ReplicationTable.ID.equals((Object)tableId) || tableId.canonicalID().matches(TableValidators.VALID_ID_REGEX));
        }

        public String invalidMessage(Table.ID tableId) {
            if (tableId == null) {
                return "Table id cannot be null";
            }
            return "Table IDs are base-36 numbers, represented with lowercase alphanumeric digits: " + tableId;
        }
    };
    public static final Validator<String> NOT_METADATA = new Validator<String>(){
        private List<String> metadataTables = Arrays.asList("accumulo.root", "accumulo.metadata");

        public boolean test(String tableName) {
            return !this.metadataTables.contains(tableName);
        }

        public String invalidMessage(String tableName) {
            return "Table cannot be one of {" + Joiner.on((String)",").join(this.metadataTables) + "}";
        }
    };
    public static final Validator<String> NOT_SYSTEM = new Validator<String>(){

        public boolean test(String tableName) {
            return !"accumulo".equals(Tables.qualify((String)tableName).getFirst());
        }

        public String invalidMessage(String tableName) {
            return "Table cannot be in the accumulo namespace";
        }
    };
    public static final Validator<Table.ID> NOT_ROOT_ID = new Validator<Table.ID>(){

        public boolean test(Table.ID tableId) {
            return !RootTable.ID.equals((Object)tableId);
        }

        public String invalidMessage(Table.ID tableId) {
            return "Table cannot be the accumulo.root(Id: " + RootTable.ID + ") table";
        }
    };
}

