/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.master.upgrade;

import com.google.common.collect.ImmutableMap;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.accumulo.master.upgrade.Upgrader;
import org.apache.accumulo.master.upgrade.Upgrader8to9;
import org.apache.accumulo.server.ServerContext;
import org.apache.accumulo.server.ServerUtil;
import org.apache.accumulo.server.fs.VolumeManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpgradeCoordinator {
    private static Logger log = LoggerFactory.getLogger(UpgradeCoordinator.class);
    private ServerContext context;
    private boolean haveUpgradedZooKeeper = false;
    private boolean startedMetadataUpgrade = false;
    private int currentVersion;
    private Map<Integer, Upgrader> upgraders = ImmutableMap.of((Object)8, (Object)new Upgrader8to9());

    public UpgradeCoordinator(ServerContext ctx) {
        int currentVersion = ServerUtil.getAccumuloPersistentVersion((VolumeManager)ctx.getVolumeManager());
        ServerUtil.ensureDataVersionCompatible((int)currentVersion);
        this.currentVersion = currentVersion;
        this.context = ctx;
    }

    @SuppressFBWarnings(value={"DM_EXIT"}, justification="Want to immediately stop all master threads on upgrade error")
    private void handleFailure(Exception e) {
        log.error("FATAL: Error performing upgrade", (Throwable)e);
        System.exit(1);
    }

    public synchronized void upgradeZookeeper() {
        if (this.haveUpgradedZooKeeper) {
            throw new IllegalStateException("Only expect this method to be called once");
        }
        try {
            if (this.currentVersion < 9) {
                ServerUtil.abortIfFateTransactions((ServerContext)this.context);
                for (int v = this.currentVersion; v < 9; ++v) {
                    log.info("Upgrading Zookeeper from data version {}", (Object)v);
                    this.upgraders.get(v).upgradeZookeeper(this.context);
                }
            }
            this.haveUpgradedZooKeeper = true;
        }
        catch (Exception e) {
            this.handleFailure(e);
        }
    }

    public synchronized Future<Void> upgradeMetadata() {
        if (this.startedMetadataUpgrade) {
            throw new IllegalStateException("Only expect this method to be called once");
        }
        if (!this.haveUpgradedZooKeeper) {
            throw new IllegalStateException("We should only attempt to upgrade Accumulo's metadata table if we've already upgraded ZooKeeper. Please save all logs and file a bug.");
        }
        this.startedMetadataUpgrade = true;
        if (this.currentVersion < 9) {
            return Executors.newCachedThreadPool().submit(() -> {
                try {
                    for (int v = this.currentVersion; v < 9; ++v) {
                        log.info("Upgrading Metadata from data version {}", (Object)v);
                        this.upgraders.get(v).upgradeMetadata(this.context);
                    }
                    log.info("Updating persistent data version.");
                    ServerUtil.updateAccumuloVersion((VolumeManager)this.context.getVolumeManager(), (int)this.currentVersion);
                    log.info("Upgrade complete");
                }
                catch (Exception e) {
                    this.handleFailure(e);
                }
                return null;
            });
        }
        return CompletableFuture.completedFuture(null);
    }
}

