/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.master.util;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.accumulo.core.cli.Help;
import org.apache.accumulo.core.conf.SiteConfiguration;
import org.apache.accumulo.fate.AdminUtil;
import org.apache.accumulo.fate.ReadOnlyStore;
import org.apache.accumulo.fate.ReadOnlyTStore;
import org.apache.accumulo.fate.TStore;
import org.apache.accumulo.fate.ZooStore;
import org.apache.accumulo.fate.zookeeper.IZooReader;
import org.apache.accumulo.fate.zookeeper.IZooReaderWriter;
import org.apache.accumulo.fate.zookeeper.ZooReaderWriter;
import org.apache.accumulo.server.ServerContext;

public class FateAdmin {
    public static void main(String[] args) throws Exception {
        Help opts = new Help();
        JCommander jc = new JCommander((Object)opts);
        jc.setProgramName(FateAdmin.class.getName());
        LinkedHashMap<String, TxOpts> txOpts = new LinkedHashMap<String, TxOpts>(2);
        txOpts.put("fail", new FailOpts());
        txOpts.put("delete", new DeleteOpts());
        for (Map.Entry entry : txOpts.entrySet()) {
            jc.addCommand((String)entry.getKey(), entry.getValue());
        }
        jc.addCommand("print", (Object)new PrintOpts());
        jc.parse(args);
        if (opts.help || jc.getParsedCommand() == null) {
            jc.usage();
            System.exit(1);
        }
        System.err.printf("This tool has been deprecated%nFATE administration now available within 'accumulo shell'%n$ fate fail <txid>... | delete <txid>... | print [<txid>...]%n%n", new Object[0]);
        AdminUtil admin = new AdminUtil();
        try (ServerContext context = new ServerContext(new SiteConfiguration());){
            String zkRoot = context.getZooKeeperRoot();
            String path = zkRoot + "/fate";
            String masterPath = zkRoot + "/masters/lock";
            ZooReaderWriter zk = context.getZooReaderWriter();
            ZooStore zs = new ZooStore(path, (IZooReaderWriter)zk);
            if (jc.getParsedCommand().equals("fail")) {
                for (String txid : ((TxOpts)txOpts.get((Object)jc.getParsedCommand())).txids) {
                    if (admin.prepFail((TStore)zs, (IZooReaderWriter)zk, masterPath, txid)) continue;
                    System.exit(1);
                }
            } else if (jc.getParsedCommand().equals("delete")) {
                for (String txid : ((TxOpts)txOpts.get((Object)jc.getParsedCommand())).txids) {
                    if (!admin.prepDelete((TStore)zs, (IZooReaderWriter)zk, masterPath, txid)) {
                        System.exit(1);
                    }
                    admin.deleteLocks((IZooReaderWriter)zk, zkRoot + "/table_locks", txid);
                }
            } else if (jc.getParsedCommand().equals("print")) {
                admin.print((ReadOnlyTStore)new ReadOnlyStore((TStore)zs), (IZooReader)zk, zkRoot + "/table_locks");
            }
        }
    }

    @Parameters(commandDescription="List the existing FATE transactions")
    static class PrintOpts {
        PrintOpts() {
        }
    }

    @Parameters(commandDescription="Delete an existing FATE by transaction id")
    static class DeleteOpts
    extends TxOpts {
        DeleteOpts() {
        }
    }

    @Parameters(commandDescription="Stop an existing FATE by transaction id")
    static class FailOpts
    extends TxOpts {
        FailOpts() {
        }
    }

    static class TxOpts {
        @Parameter(description="<txid>...", required=true)
        List<String> txids = new ArrayList<String>();

        TxOpts() {
        }
    }
}

