/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.master.metrics.fate;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.accumulo.master.metrics.MasterMetrics;
import org.apache.accumulo.master.metrics.fate.FateMetricValues;
import org.apache.accumulo.server.ServerContext;
import org.apache.hadoop.metrics2.lib.MetricsRegistry;
import org.apache.hadoop.metrics2.lib.MutableGaugeLong;

public class FateMetrics
extends MasterMetrics {
    private static final long DEFAULT_MIN_REFRESH_DELAY = TimeUnit.SECONDS.toMillis(10L);
    private volatile long minimumRefreshDelay;
    private final ServerContext context;
    private final MutableGaugeLong currentFateOps;
    private final MutableGaugeLong zkChildFateOpsTotal;
    private final MutableGaugeLong zkConnectionErrorsTotal;
    private final AtomicReference<FateMetricValues> metricValues;
    private volatile long lastUpdate = 0L;

    public FateMetrics(ServerContext context, long minimumRefreshDelay) {
        super("Fate", "Fate Metrics", "fate");
        this.context = context;
        this.minimumRefreshDelay = Math.max(DEFAULT_MIN_REFRESH_DELAY, minimumRefreshDelay);
        this.metricValues = new AtomicReference<FateMetricValues>(FateMetricValues.updateFromZookeeper(context, null));
        MetricsRegistry registry = super.getRegistry();
        this.currentFateOps = registry.newGauge("currentFateOps", "Current number of FATE Ops", 0L);
        this.zkChildFateOpsTotal = registry.newGauge("totalFateOps", "Total FATE Ops", 0L);
        this.zkConnectionErrorsTotal = registry.newGauge("totalZkConnErrors", "Total ZK Connection Errors", 0L);
    }

    protected void prepareMetrics() {
        FateMetricValues fateMetrics = this.metricValues.get();
        long now = System.currentTimeMillis();
        if (this.lastUpdate + this.minimumRefreshDelay < now) {
            fateMetrics = FateMetricValues.updateFromZookeeper(this.context, fateMetrics);
            this.metricValues.set(fateMetrics);
            this.lastUpdate = now;
            this.currentFateOps.set(fateMetrics.getCurrentFateOps());
            this.zkChildFateOpsTotal.set(fateMetrics.getZkFateChildOpsTotal());
            this.zkConnectionErrorsTotal.set(fateMetrics.getZkConnectionErrors());
        }
    }
}

