/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.master.replication;

import com.google.common.base.Preconditions;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.util.Iterator;
import java.util.Random;
import java.util.Set;
import org.apache.accumulo.core.clientImpl.thrift.ThriftSecurityException;
import org.apache.accumulo.core.replication.thrift.ReplicationCoordinator;
import org.apache.accumulo.core.replication.thrift.ReplicationCoordinatorErrorCode;
import org.apache.accumulo.core.replication.thrift.ReplicationCoordinatorException;
import org.apache.accumulo.core.securityImpl.thrift.TCredentials;
import org.apache.accumulo.fate.zookeeper.ZooReader;
import org.apache.accumulo.master.Master;
import org.apache.accumulo.server.ServerContext;
import org.apache.accumulo.server.master.state.TServerInstance;
import org.apache.accumulo.server.security.AuditedSecurityOperation;
import org.apache.accumulo.server.security.SecurityOperation;
import org.apache.thrift.TException;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MasterReplicationCoordinator
implements ReplicationCoordinator.Iface {
    private static final Logger log = LoggerFactory.getLogger(MasterReplicationCoordinator.class);
    private final Master master;
    private final Random rand;
    private final ZooReader reader;
    private final SecurityOperation security;

    public MasterReplicationCoordinator(Master master) {
        this(master, new ZooReader(master.getContext().getZooKeepers(), master.getContext().getZooKeepersSessionTimeOut()));
    }

    protected MasterReplicationCoordinator(Master master, ZooReader reader) {
        this.master = master;
        this.rand = new SecureRandom();
        this.rand.setSeed(358923462L);
        this.reader = reader;
        this.security = AuditedSecurityOperation.getInstance((ServerContext)master.getContext());
    }

    public String getServicerAddress(String remoteTableId, TCredentials creds) throws ReplicationCoordinatorException, TException {
        String replServiceAddr;
        try {
            this.security.authenticateUser(this.master.getContext().rpcCreds(), creds);
        }
        catch (ThriftSecurityException e) {
            log.error("{} failed to authenticate for replication to {}", (Object)creds.getPrincipal(), (Object)remoteTableId);
            throw new ReplicationCoordinatorException(ReplicationCoordinatorErrorCode.CANNOT_AUTHENTICATE, "Could not authenticate " + creds.getPrincipal());
        }
        Set<TServerInstance> tservers = this.master.onlineTabletServers();
        if (tservers.isEmpty()) {
            throw new ReplicationCoordinatorException(ReplicationCoordinatorErrorCode.NO_AVAILABLE_SERVERS, "No tservers are available for replication");
        }
        TServerInstance tserver = this.getRandomTServer(tservers, this.rand.nextInt(tservers.size()));
        try {
            replServiceAddr = new String(this.reader.getData(this.master.getZooKeeperRoot() + "/replication/tservers" + "/" + tserver.hostPort(), null), StandardCharsets.UTF_8);
        }
        catch (InterruptedException | KeeperException e) {
            log.error("Could not fetch repliation service port for tserver", e);
            throw new ReplicationCoordinatorException(ReplicationCoordinatorErrorCode.SERVICE_CONFIGURATION_UNAVAILABLE, "Could not determine port for replication service running at " + tserver.hostPort());
        }
        return replServiceAddr;
    }

    protected TServerInstance getRandomTServer(Set<TServerInstance> tservers, int offset) {
        Preconditions.checkArgument((tservers.size() > offset ? 1 : 0) != 0, (Object)"Must provide an offset less than the size of the set");
        Iterator<TServerInstance> iter = tservers.iterator();
        while (offset > 0) {
            iter.next();
            --offset;
        }
        return iter.next();
    }
}

