/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.master.state;

import java.util.HashMap;
import java.util.Map;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.master.thrift.MasterState;
import org.apache.accumulo.master.state.TableCounts;
import org.apache.accumulo.server.master.state.TabletState;

public class TableStats {
    private Map<TableId, TableCounts> last = new HashMap<TableId, TableCounts>();
    private Map<TableId, TableCounts> next;
    private long startScan = 0L;
    private long endScan = 0L;
    private MasterState state;

    public synchronized void begin() {
        this.next = new HashMap<TableId, TableCounts>();
        this.startScan = System.currentTimeMillis();
    }

    public synchronized void update(TableId tableId, TabletState state) {
        TableCounts counts = this.next.get(tableId);
        if (counts == null) {
            counts = new TableCounts();
            this.next.put(tableId, counts);
        }
        int n = state.ordinal();
        counts.counts[n] = counts.counts[n] + 1;
    }

    public synchronized void end(MasterState state) {
        this.last = this.next;
        this.next = null;
        this.endScan = System.currentTimeMillis();
        this.state = state;
    }

    public synchronized Map<TableId, TableCounts> getLast() {
        return this.last;
    }

    public synchronized MasterState getLastMasterState() {
        return this.state;
    }

    public synchronized TableCounts getLast(TableId tableId) {
        TableCounts result = this.last.get(tableId);
        if (result == null) {
            return new TableCounts();
        }
        return result;
    }

    public synchronized long getScanTime() {
        if (this.endScan <= this.startScan) {
            return System.currentTimeMillis() - this.startScan;
        }
        return this.endScan - this.startScan;
    }

    public synchronized long lastScanFinished() {
        return this.endScan;
    }
}

