/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.minicluster.impl;

import com.google.common.base.Predicate;
import com.google.common.collect.Maps;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.accumulo.cluster.AccumuloCluster;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.ClientConfiguration;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.ZooKeeperInstance;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.client.security.tokens.PasswordToken;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.master.thrift.MasterGoalState;
import org.apache.accumulo.core.util.Daemon;
import org.apache.accumulo.core.util.Pair;
import org.apache.accumulo.core.util.StringUtil;
import org.apache.accumulo.core.util.UtilWaitThread;
import org.apache.accumulo.gc.SimpleGarbageCollector;
import org.apache.accumulo.master.Master;
import org.apache.accumulo.master.state.SetGoalState;
import org.apache.accumulo.minicluster.ServerType;
import org.apache.accumulo.minicluster.impl.MiniAccumuloConfigImpl;
import org.apache.accumulo.minicluster.impl.ProcessNotFoundException;
import org.apache.accumulo.minicluster.impl.ProcessReference;
import org.apache.accumulo.server.init.Initialize;
import org.apache.accumulo.server.util.PortUtils;
import org.apache.accumulo.server.util.time.SimpleTimer;
import org.apache.accumulo.start.Main;
import org.apache.accumulo.start.classloader.vfs.MiniDFSUtil;
import org.apache.accumulo.tserver.TabletServer;
import org.apache.commons.configuration.MapConfiguration;
import org.apache.commons.vfs2.impl.VFSClassLoader;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.zookeeper.server.ZooKeeperServerMain;

public class MiniAccumuloClusterImpl
implements AccumuloCluster {
    private static final long ZOOKEEPER_STARTUP_WAIT = 20000L;
    private boolean initialized = false;
    private Process zooKeeperProcess = null;
    private Process masterProcess = null;
    private Process gcProcess = null;
    private List<Process> tabletServerProcesses = Collections.synchronizedList(new ArrayList());
    private Set<Pair<ServerType, Integer>> debugPorts = new HashSet<Pair<ServerType, Integer>>();
    private File zooCfgFile;
    private String dfsUri;
    private List<LogWriter> logWriters = new ArrayList<LogWriter>();
    private MiniAccumuloConfigImpl config;
    private MiniDFSCluster miniDFS = null;
    private List<Process> cleanup = new ArrayList<Process>();

    public List<LogWriter> getLogWriters() {
        return this.logWriters;
    }

    public Process exec(Class<?> clazz, String ... args) throws IOException {
        return this.exec(clazz, (List<String>)null, args);
    }

    public Process exec(Class<?> clazz, List<String> jvmArgs, String ... args) throws IOException {
        ArrayList<String> jvmArgs2 = new ArrayList<String>(1 + (jvmArgs == null ? 0 : jvmArgs.size()));
        jvmArgs2.add("-Xmx" + this.config.getDefaultMemory());
        if (jvmArgs != null) {
            jvmArgs2.addAll(jvmArgs);
        }
        Process proc = this._exec(clazz, jvmArgs2, args);
        this.cleanup.add(proc);
        return proc;
    }

    private boolean containsSiteFile(File f) {
        return f.isDirectory() && f.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.getName().endsWith("site.xml");
            }
        }).length > 0;
    }

    private void append(StringBuilder classpathBuilder, URL url) throws URISyntaxException {
        File file = new File(url.toURI());
        if (!this.containsSiteFile(file)) {
            classpathBuilder.append(File.pathSeparator).append(file.getAbsolutePath());
        }
    }

    private String getClasspath() throws IOException {
        try {
            ArrayList<ClassLoader> classloaders = new ArrayList<ClassLoader>();
            for (ClassLoader cl = this.getClass().getClassLoader(); cl != null; cl = cl.getParent()) {
                classloaders.add(cl);
            }
            Collections.reverse(classloaders);
            StringBuilder classpathBuilder = new StringBuilder();
            classpathBuilder.append(this.config.getConfDir().getAbsolutePath());
            if (this.config.getClasspathItems() == null) {
                for (int i = 1; i < classloaders.size(); ++i) {
                    ClassLoader classLoader = (ClassLoader)classloaders.get(i);
                    if (classLoader instanceof URLClassLoader) {
                        URLClassLoader ucl = (URLClassLoader)classLoader;
                        for (URL uRL : ucl.getURLs()) {
                            this.append(classpathBuilder, uRL);
                        }
                        continue;
                    }
                    if (classLoader instanceof VFSClassLoader) {
                        VFSClassLoader vcl = (VFSClassLoader)classLoader;
                        for (URL uRL : vcl.getFileObjects()) {
                            this.append(classpathBuilder, uRL.getURL());
                        }
                        continue;
                    }
                    throw new IllegalArgumentException("Unknown classloader type : " + classLoader.getClass().getName());
                }
            } else {
                for (String s : this.config.getClasspathItems()) {
                    classpathBuilder.append(File.pathSeparator).append(s);
                }
            }
            return classpathBuilder.toString();
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
    }

    private Process _exec(Class<?> clazz, List<String> extraJvmOpts, String ... args) throws IOException {
        String javaHome = System.getProperty("java.home");
        String javaBin = javaHome + File.separator + "bin" + File.separator + "java";
        String classpath = this.getClasspath();
        String className = clazz.getName();
        ArrayList<String> argList = new ArrayList<String>();
        argList.addAll(Arrays.asList(javaBin, "-Dproc=" + clazz.getSimpleName(), "-cp", classpath));
        argList.addAll(extraJvmOpts);
        for (Map.Entry<String, String> sysProp : this.config.getSystemProperties().entrySet()) {
            argList.add(String.format("-D%s=%s", sysProp.getKey(), sysProp.getValue()));
        }
        argList.addAll(Arrays.asList("-XX:+UseConcMarkSweepGC", "-XX:CMSInitiatingOccupancyFraction=75", "-Dapple.awt.UIElement=true", Main.class.getName(), className));
        argList.addAll(Arrays.asList(args));
        ProcessBuilder builder = new ProcessBuilder(argList);
        builder.environment().put("ACCUMULO_HOME", this.config.getDir().getAbsolutePath());
        builder.environment().put("ACCUMULO_LOG_DIR", this.config.getLogDir().getAbsolutePath());
        builder.environment().put("ACCUMULO_CLIENT_CONF_PATH", this.config.getClientConfFile().getAbsolutePath());
        String ldLibraryPath = StringUtil.join(Arrays.asList(this.config.getNativeLibPaths()), (String)File.pathSeparator);
        builder.environment().put("LD_LIBRARY_PATH", ldLibraryPath);
        builder.environment().put("DYLD_LIBRARY_PATH", ldLibraryPath);
        String env = System.getenv("HADOOP_PREFIX");
        if (env != null) {
            builder.environment().put("HADOOP_PREFIX", env);
        }
        if ((env = System.getenv("ZOOKEEPER_HOME")) != null) {
            builder.environment().put("ZOOKEEPER_HOME", env);
        }
        builder.environment().put("ACCUMULO_CONF_DIR", this.config.getConfDir().getAbsolutePath());
        builder.environment().put("HADOOP_HOME", this.config.getDir().getAbsolutePath());
        Process process = builder.start();
        LogWriter lw = new LogWriter(process.getErrorStream(), new File(this.config.getLogDir(), clazz.getSimpleName() + "_" + process.hashCode() + ".err"));
        this.logWriters.add(lw);
        lw.start();
        lw = new LogWriter(process.getInputStream(), new File(this.config.getLogDir(), clazz.getSimpleName() + "_" + process.hashCode() + ".out"));
        this.logWriters.add(lw);
        lw.start();
        return process;
    }

    private Process _exec(Class<?> clazz, ServerType serverType, String ... args) throws IOException {
        ArrayList<String> jvmOpts = new ArrayList<String>();
        jvmOpts.add("-Xmx" + this.config.getMemory(serverType));
        if (this.config.isJDWPEnabled()) {
            Integer port = PortUtils.getRandomFreePort();
            jvmOpts.addAll(this.buildRemoteDebugParams(port));
            this.debugPorts.add((Pair<ServerType, Integer>)new Pair((Object)serverType, (Object)port));
        }
        return this._exec(clazz, jvmOpts, args);
    }

    public MiniAccumuloClusterImpl(File dir, String rootPassword) throws IOException {
        this(new MiniAccumuloConfigImpl(dir, rootPassword));
    }

    public MiniAccumuloClusterImpl(MiniAccumuloConfigImpl config) throws IOException {
        this.config = config.initialize();
        config.getConfDir().mkdirs();
        config.getAccumuloDir().mkdirs();
        config.getZooKeeperDir().mkdirs();
        config.getLogDir().mkdirs();
        config.getWalogDir().mkdirs();
        config.getLibDir().mkdirs();
        config.getLibExtDir().mkdirs();
        if (config.useMiniDFS()) {
            File nn = new File(config.getAccumuloDir(), "nn");
            nn.mkdirs();
            File dn = new File(config.getAccumuloDir(), "dn");
            dn.mkdirs();
            File dfs = new File(config.getAccumuloDir(), "dfs");
            dfs.mkdirs();
            Configuration conf = new Configuration();
            conf.set("dfs.namenode.name.dir", nn.getAbsolutePath());
            conf.set("dfs.datanode.data.dir", dn.getAbsolutePath());
            conf.set("dfs.replication", "1");
            conf.set("dfs.support.append", "true");
            conf.set("dfs.datanode.synconclose", "true");
            conf.set("dfs.datanode.data.dir.perm", MiniDFSUtil.computeDatanodeDirectoryPermission());
            String oldTestBuildData = System.setProperty("test.build.data", dfs.getAbsolutePath());
            this.miniDFS = new MiniDFSCluster(conf, 1, true, null);
            if (oldTestBuildData == null) {
                System.clearProperty("test.build.data");
            } else {
                System.setProperty("test.build.data", oldTestBuildData);
            }
            this.miniDFS.waitClusterUp();
            InetSocketAddress dfsAddress = this.miniDFS.getNameNode().getNameNodeAddress();
            this.dfsUri = "hdfs://" + dfsAddress.getHostName() + ":" + dfsAddress.getPort();
            File coreFile = new File(config.getConfDir(), "core-site.xml");
            this.writeConfig(coreFile, Collections.singletonMap("fs.default.name", this.dfsUri).entrySet());
            File hdfsFile = new File(config.getConfDir(), "hdfs-site.xml");
            this.writeConfig(hdfsFile, (Iterable<Map.Entry<String, String>>)conf);
            Map<String, String> siteConfig = config.getSiteConfig();
            siteConfig.put(Property.INSTANCE_DFS_URI.getKey(), this.dfsUri);
            siteConfig.put(Property.INSTANCE_DFS_DIR.getKey(), "/accumulo");
            config.setSiteConfig((Map)siteConfig);
        } else {
            this.dfsUri = "file://";
        }
        File clientConfFile = config.getClientConfFile();
        this.writeConfigProperties(clientConfFile, Maps.filterEntries(config.getSiteConfig(), (Predicate)new Predicate<Map.Entry<String, String>>(){

            public boolean apply(Map.Entry<String, String> v) {
                return ClientConfiguration.ClientProperty.getPropertyByKey((String)v.getKey()) != null;
            }
        }));
        File siteFile = new File(config.getConfDir(), "accumulo-site.xml");
        this.writeConfig(siteFile, config.getSiteConfig().entrySet());
        this.zooCfgFile = new File(config.getConfDir(), "zoo.cfg");
        FileWriter fileWriter = new FileWriter(this.zooCfgFile);
        Properties zooCfg = new Properties();
        zooCfg.setProperty("tickTime", "2000");
        zooCfg.setProperty("initLimit", "10");
        zooCfg.setProperty("syncLimit", "5");
        zooCfg.setProperty("clientPort", config.getZooKeeperPort() + "");
        zooCfg.setProperty("maxClientCnxns", "1000");
        zooCfg.setProperty("dataDir", config.getZooKeeperDir().getAbsolutePath());
        zooCfg.store(fileWriter, null);
        fileWriter.close();
    }

    private void writeConfig(File file, Iterable<Map.Entry<String, String>> settings) throws IOException {
        FileWriter fileWriter = new FileWriter(file);
        fileWriter.append("<configuration>\n");
        for (Map.Entry<String, String> entry : settings) {
            String value = entry.getValue().replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;");
            fileWriter.append("<property><name>" + entry.getKey() + "</name><value>" + value + "</value></property>\n");
        }
        fileWriter.append("</configuration>\n");
        fileWriter.close();
    }

    private void writeConfigProperties(File file, Map<String, String> settings) throws IOException {
        FileWriter fileWriter = new FileWriter(file);
        for (Map.Entry<String, String> entry : settings.entrySet()) {
            fileWriter.append(entry.getKey() + "=" + entry.getValue() + "\n");
        }
        fileWriter.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() throws IOException, InterruptedException {
        int i;
        if (!this.initialized) {
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    try {
                        MiniAccumuloClusterImpl.this.stop();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            });
        }
        if (this.zooKeeperProcess == null) {
            this.zooKeeperProcess = this._exec(ZooKeeperServerMain.class, ServerType.ZOOKEEPER, this.zooCfgFile.getAbsolutePath());
        }
        if (!this.initialized) {
            long startTime = System.currentTimeMillis();
            while (true) {
                Socket s = null;
                try {
                    s = new Socket("localhost", this.config.getZooKeeperPort());
                    s.getOutputStream().write("ruok\n".getBytes());
                    s.getOutputStream().flush();
                    byte[] buffer = new byte[100];
                    int n = s.getInputStream().read(buffer);
                    if (n < 4 || !new String(buffer, 0, 4).equals("imok")) continue;
                }
                catch (Exception e) {
                    if (System.currentTimeMillis() - startTime >= 20000L) {
                        throw new RuntimeException("Zookeeper did not start within 20 seconds. Check the logs in " + this.config.getLogDir() + " for errors.  Last exception: " + e);
                    }
                    UtilWaitThread.sleep((long)250L);
                    continue;
                }
                finally {
                    if (s == null) continue;
                    s.close();
                    continue;
                }
                break;
            }
            Process initProcess = this.exec(Initialize.class, "--instance-name", this.config.getInstanceName(), "--password", this.config.getRootPassword());
            int ret = initProcess.waitFor();
            if (ret != 0) {
                throw new RuntimeException("Initialize process returned " + ret + ". Check the logs in " + this.config.getLogDir() + " for errors.");
            }
            this.initialized = true;
        }
        List<Process> startTime = this.tabletServerProcesses;
        synchronized (startTime) {
            for (i = this.tabletServerProcesses.size(); i < this.config.getNumTservers(); ++i) {
                this.tabletServerProcesses.add(this._exec(TabletServer.class, ServerType.TABLET_SERVER, new String[0]));
            }
        }
        int ret = 0;
        for (i = 0; i < 5 && (ret = this.exec(Main.class, SetGoalState.class.getName(), MasterGoalState.NORMAL.toString()).waitFor()) != 0; ++i) {
            UtilWaitThread.sleep((long)1000L);
        }
        if (ret != 0) {
            throw new RuntimeException("Could not set master goal state, process returned " + ret + ". Check the logs in " + this.config.getLogDir() + " for errors.");
        }
        if (this.masterProcess == null) {
            this.masterProcess = this._exec(Master.class, ServerType.MASTER, new String[0]);
        }
        if (this.gcProcess == null) {
            this.gcProcess = this._exec(SimpleGarbageCollector.class, ServerType.GARBAGE_COLLECTOR, new String[0]);
        }
    }

    private List<String> buildRemoteDebugParams(int port) {
        return Arrays.asList("-Xdebug", String.format("-Xrunjdwp:transport=dt_socket,server=y,suspend=n,address=%d", port));
    }

    public Set<Pair<ServerType, Integer>> getDebugPorts() {
        return this.debugPorts;
    }

    List<ProcessReference> references(Process ... procs) {
        ArrayList<ProcessReference> result = new ArrayList<ProcessReference>();
        for (Process proc : procs) {
            result.add(new ProcessReference(proc));
        }
        return result;
    }

    public Map<ServerType, Collection<ProcessReference>> getProcesses() {
        HashMap<ServerType, Collection<ProcessReference>> result = new HashMap<ServerType, Collection<ProcessReference>>();
        result.put(ServerType.MASTER, this.references(this.masterProcess));
        result.put(ServerType.TABLET_SERVER, this.references(this.tabletServerProcesses.toArray(new Process[0])));
        result.put(ServerType.ZOOKEEPER, this.references(this.zooKeeperProcess));
        if (null != this.gcProcess) {
            result.put(ServerType.GARBAGE_COLLECTOR, this.references(this.gcProcess));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void killProcess(ServerType type, ProcessReference proc) throws ProcessNotFoundException, InterruptedException {
        boolean found = false;
        switch (type) {
            case MASTER: {
                if (!proc.equals(this.masterProcess)) break;
                this.masterProcess.destroy();
                this.masterProcess.waitFor();
                this.masterProcess = null;
                found = true;
                break;
            }
            case TABLET_SERVER: {
                List<Process> list = this.tabletServerProcesses;
                synchronized (list) {
                    for (Process tserver : this.tabletServerProcesses) {
                        if (!proc.equals(tserver)) continue;
                        this.tabletServerProcesses.remove(tserver);
                        tserver.destroy();
                        tserver.waitFor();
                        found = true;
                        break;
                    }
                    break;
                }
            }
            case ZOOKEEPER: {
                if (!proc.equals(this.zooKeeperProcess)) break;
                this.zooKeeperProcess.destroy();
                this.zooKeeperProcess.waitFor();
                this.zooKeeperProcess = null;
                found = true;
                break;
            }
            case GARBAGE_COLLECTOR: {
                if (!proc.equals(this.gcProcess)) break;
                this.gcProcess.destroy();
                this.gcProcess.waitFor();
                this.gcProcess = null;
                found = true;
            }
        }
        if (!found) {
            throw new ProcessNotFoundException();
        }
    }

    @Override
    public String getInstanceName() {
        return this.config.getInstanceName();
    }

    @Override
    public String getZooKeepers() {
        return this.config.getZooKeepers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() throws IOException, InterruptedException {
        for (LogWriter lw : this.logWriters) {
            lw.flush();
        }
        if (this.gcProcess != null) {
            this.gcProcess.destroy();
            this.gcProcess.waitFor();
        }
        if (this.masterProcess != null) {
            this.masterProcess.destroy();
            this.masterProcess.waitFor();
        }
        if (this.tabletServerProcesses != null) {
            Iterator<Process> i$ = this.tabletServerProcesses;
            synchronized (i$) {
                for (Process tserver : this.tabletServerProcesses) {
                    tserver.destroy();
                    tserver.waitFor();
                }
            }
        }
        if (this.zooKeeperProcess != null) {
            this.zooKeeperProcess.destroy();
            this.zooKeeperProcess.waitFor();
        }
        this.zooKeeperProcess = null;
        this.masterProcess = null;
        this.gcProcess = null;
        this.tabletServerProcesses.clear();
        if (this.config.useMiniDFS() && this.miniDFS != null) {
            this.miniDFS.shutdown();
        }
        for (Process p : this.cleanup) {
            p.destroy();
            p.waitFor();
        }
        this.miniDFS = null;
    }

    @Override
    public MiniAccumuloConfigImpl getConfig() {
        return this.config;
    }

    @Override
    public Connector getConnector(String user, String passwd) throws AccumuloException, AccumuloSecurityException {
        ZooKeeperInstance instance = new ZooKeeperInstance((org.apache.commons.configuration.Configuration)this.getClientConfig());
        return instance.getConnector(user, (AuthenticationToken)new PasswordToken((CharSequence)passwd));
    }

    @Override
    public ClientConfiguration getClientConfig() {
        return new ClientConfiguration(Arrays.asList(new MapConfiguration(this.config.getSiteConfig()))).withInstance(this.getInstanceName()).withZkHosts(this.getZooKeepers());
    }

    public FileSystem getFileSystem() {
        try {
            return FileSystem.get((URI)new URI(this.dfsUri), (Configuration)new Configuration());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static class LogWriter
    extends Daemon {
        private BufferedReader in;
        private BufferedWriter out;

        public LogWriter(InputStream stream, File logFile) throws IOException {
            this.in = new BufferedReader(new InputStreamReader(stream));
            this.out = new BufferedWriter(new FileWriter(logFile));
            SimpleTimer.getInstance().schedule(new Runnable(){

                @Override
                public void run() {
                    try {
                        LogWriter.this.flush();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }, 1000L, 1000L);
        }

        public synchronized void flush() throws IOException {
            if (this.out != null) {
                this.out.flush();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                String line;
                while ((line = this.in.readLine()) != null) {
                    this.out.append(line);
                    this.out.append("\n");
                }
                LogWriter logWriter = this;
                synchronized (logWriter) {
                    this.out.close();
                    this.out = null;
                    this.in.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

