/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.minicluster.impl;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.accumulo.cluster.AccumuloConfig;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.minicluster.MemoryUnit;
import org.apache.accumulo.minicluster.ServerType;
import org.apache.accumulo.minicluster.impl.MiniAccumuloClusterImpl;
import org.apache.accumulo.server.util.PortUtils;

public class MiniAccumuloConfigImpl
implements AccumuloConfig {
    private static final String DEFAULT_INSTANCE_SECRET = "DONTTELL";
    private File dir = null;
    private String rootPassword = null;
    private Map<String, String> siteConfig = new HashMap<String, String>();
    private Map<String, String> configuredSiteConig = new HashMap<String, String>();
    private int numTservers = 2;
    private Map<ServerType, Long> memoryConfig = new HashMap<ServerType, Long>();
    private boolean jdwpEnabled = false;
    private Map<String, String> systemProperties = new HashMap<String, String>();
    private String instanceName = "miniInstance";
    private File libDir;
    private File libExtDir;
    private File confDir;
    private File zooKeeperDir;
    private File accumuloDir;
    private File logDir;
    private File walogDir;
    private int zooKeeperPort = 0;
    private int configuredZookeeperPort = 0;
    private long defaultMemorySize = 0x8000000L;
    private boolean initialized = false;
    private boolean useMiniDFS = false;
    private String[] classpathItems = null;
    private String[] nativePathItems = null;

    public MiniAccumuloConfigImpl(File dir, String rootPassword) {
        this.dir = dir;
        this.rootPassword = rootPassword;
    }

    MiniAccumuloConfigImpl initialize() {
        if (this.getDir().exists() && !this.getDir().isDirectory()) {
            throw new IllegalArgumentException("Must pass in directory, " + this.getDir() + " is a file");
        }
        if (this.getDir().exists() && this.getDir().list().length != 0) {
            throw new IllegalArgumentException("Directory " + this.getDir() + " is not empty");
        }
        if (!this.initialized) {
            this.libDir = new File(this.dir, "lib");
            this.libExtDir = new File(this.libDir, "ext");
            this.confDir = new File(this.dir, "conf");
            this.accumuloDir = new File(this.dir, "accumulo");
            this.zooKeeperDir = new File(this.dir, "zookeeper");
            this.logDir = new File(this.dir, "logs");
            this.walogDir = new File(this.dir, "walogs");
            this.setInstanceLocation();
            this.mergeProp(Property.INSTANCE_SECRET.getKey(), DEFAULT_INSTANCE_SECRET);
            this.mergeProp(Property.TSERV_PORTSEARCH.getKey(), "true");
            this.mergeProp(Property.LOGGER_DIR.getKey(), this.walogDir.getAbsolutePath());
            this.mergeProp(Property.TSERV_DATACACHE_SIZE.getKey(), "10M");
            this.mergeProp(Property.TSERV_INDEXCACHE_SIZE.getKey(), "10M");
            this.mergeProp(Property.TSERV_MAXMEM.getKey(), "50M");
            this.mergeProp(Property.TSERV_WALOG_MAX_SIZE.getKey(), "100M");
            this.mergeProp(Property.TSERV_NATIVEMAP_ENABLED.getKey(), "false");
            this.mergeProp(Property.TRACE_TOKEN_PROPERTY_PREFIX.getKey() + "password", this.getRootPassword());
            this.mergeProp(Property.TSERV_MAJC_DELAY.getKey(), "3");
            this.mergeProp(Property.GENERAL_CLASSPATHS.getKey(), this.libDir.getAbsolutePath() + "/[^.].*[.]jar");
            this.mergeProp(Property.GENERAL_DYNAMIC_CLASSPATHS.getKey(), this.libExtDir.getAbsolutePath() + "/[^.].*[.]jar");
            this.mergeProp(Property.GC_CYCLE_DELAY.getKey(), "4s");
            this.mergeProp(Property.GC_CYCLE_START.getKey(), "0s");
            this.mergePropWithRandomPort(Property.MASTER_CLIENTPORT.getKey());
            this.mergePropWithRandomPort(Property.TRACE_PORT.getKey());
            this.mergePropWithRandomPort(Property.TSERV_CLIENTPORT.getKey());
            this.mergePropWithRandomPort(Property.MONITOR_PORT.getKey());
            this.mergePropWithRandomPort(Property.GC_PORT.getKey());
            if (this.zooKeeperPort == 0) {
                this.zooKeeperPort = PortUtils.getRandomFreePort();
            }
            this.siteConfig.put(Property.INSTANCE_ZK_HOST.getKey(), "localhost:" + this.zooKeeperPort);
            this.initialized = true;
        }
        return this;
    }

    private void setInstanceLocation() {
        this.mergeProp(Property.INSTANCE_DFS_URI.getKey(), "file:///");
        this.mergeProp(Property.INSTANCE_DFS_DIR.getKey(), this.accumuloDir.getAbsolutePath());
    }

    private void mergeProp(String key, String value) {
        if (!this.siteConfig.containsKey(key)) {
            this.siteConfig.put(key, value);
        }
    }

    private void mergePropWithRandomPort(String key) {
        if (!this.siteConfig.containsKey(key)) {
            this.siteConfig.put(key, "0");
        }
    }

    @Override
    public MiniAccumuloConfigImpl setNumTservers(int numTservers) {
        if (numTservers < 1) {
            throw new IllegalArgumentException("Must have at least one tablet server");
        }
        this.numTservers = numTservers;
        return this;
    }

    @Override
    public MiniAccumuloConfigImpl setInstanceName(String instanceName) {
        this.instanceName = instanceName;
        return this;
    }

    @Override
    public MiniAccumuloConfigImpl setSiteConfig(Map<String, String> siteConfig) {
        this.siteConfig = new HashMap<String, String>(siteConfig);
        this.configuredSiteConig = new HashMap<String, String>(siteConfig);
        return this;
    }

    @Override
    public MiniAccumuloConfigImpl setZooKeeperPort(int zooKeeperPort) {
        this.configuredZookeeperPort = zooKeeperPort;
        this.zooKeeperPort = zooKeeperPort;
        return this;
    }

    @Override
    public MiniAccumuloConfigImpl setMemory(ServerType serverType, long memory, MemoryUnit memoryUnit) {
        this.memoryConfig.put(serverType, memoryUnit.toBytes(memory));
        return this;
    }

    @Override
    public MiniAccumuloConfigImpl setDefaultMemory(long memory, MemoryUnit memoryUnit) {
        this.defaultMemorySize = memoryUnit.toBytes(memory);
        return this;
    }

    @Override
    public Map<String, String> getSiteConfig() {
        return new HashMap<String, String>(this.siteConfig);
    }

    public Map<String, String> getConfiguredSiteConfig() {
        return new HashMap<String, String>(this.configuredSiteConig);
    }

    @Override
    public String getInstanceName() {
        return this.instanceName;
    }

    @Override
    public int getZooKeeperPort() {
        return this.zooKeeperPort;
    }

    public int getConfiguredZookeeperPort() {
        return this.configuredZookeeperPort;
    }

    File getLibDir() {
        return this.libDir;
    }

    File getLibExtDir() {
        return this.libExtDir;
    }

    public File getConfDir() {
        return this.confDir;
    }

    File getZooKeeperDir() {
        return this.zooKeeperDir;
    }

    public File getAccumuloDir() {
        return this.accumuloDir;
    }

    public File getLogDir() {
        return this.logDir;
    }

    File getWalogDir() {
        return this.walogDir;
    }

    @Override
    public long getMemory(ServerType serverType) {
        return this.memoryConfig.containsKey((Object)serverType) ? this.memoryConfig.get((Object)serverType) : this.defaultMemorySize;
    }

    @Override
    public long getDefaultMemory() {
        return this.defaultMemorySize;
    }

    public String getZooKeepers() {
        return this.siteConfig.get(Property.INSTANCE_ZK_HOST.getKey());
    }

    public File getDir() {
        return this.dir;
    }

    @Override
    public String getRootPassword() {
        return this.rootPassword;
    }

    @Override
    public int getNumTservers() {
        return this.numTservers;
    }

    public boolean isJDWPEnabled() {
        return this.jdwpEnabled;
    }

    public MiniAccumuloConfigImpl setJDWPEnabled(boolean jdwpEnabled) {
        this.jdwpEnabled = jdwpEnabled;
        return this;
    }

    public boolean useMiniDFS() {
        return this.useMiniDFS;
    }

    public void useMiniDFS(boolean useMiniDFS) {
        this.useMiniDFS = useMiniDFS;
    }

    public File getClientConfFile() {
        return new File(this.getConfDir(), "client.conf");
    }

    public void setSystemProperties(Map<String, String> systemProperties) {
        this.systemProperties = new HashMap<String, String>(systemProperties);
    }

    public Map<String, String> getSystemProperties() {
        return new HashMap<String, String>(this.systemProperties);
    }

    public String[] getClasspathItems() {
        return this.classpathItems;
    }

    public void setClasspathItems(String ... classpathItems) {
        this.classpathItems = classpathItems;
    }

    @Override
    public String[] getNativeLibPaths() {
        return this.nativePathItems == null ? new String[]{} : this.nativePathItems;
    }

    @Override
    public MiniAccumuloConfigImpl setNativeLibPaths(String ... nativePathItems) {
        this.nativePathItems = nativePathItems;
        return this;
    }

    public void setProperty(Property p, String value) {
        this.siteConfig.put(p.getKey(), value);
    }

    @Override
    public MiniAccumuloClusterImpl build() throws IOException {
        return new MiniAccumuloClusterImpl(this);
    }
}

