/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.cluster;

import org.apache.accumulo.minicluster.ServerType;

public enum ClusterServerType {
    MASTER("Master"),
    ZOOKEEPER("ZooKeeper"),
    TABLET_SERVER("TServer"),
    GARBAGE_COLLECTOR("GC"),
    TRACER("Tracer"),
    MONITOR("Monitor");

    private final String prettyPrint;

    public String prettyPrint() {
        return this.prettyPrint;
    }

    private ClusterServerType(String prettyPrint) {
        this.prettyPrint = prettyPrint;
    }

    public static ClusterServerType get(ServerType type) {
        switch (type) {
            case MASTER: {
                return MASTER;
            }
            case ZOOKEEPER: {
                return ZOOKEEPER;
            }
            case TABLET_SERVER: {
                return TABLET_SERVER;
            }
            case GARBAGE_COLLECTOR: {
                return GARBAGE_COLLECTOR;
            }
        }
        throw new IllegalArgumentException("Unknown server type");
    }

    public ServerType toServerType() {
        switch (this) {
            case MASTER: {
                return ServerType.MASTER;
            }
            case ZOOKEEPER: {
                return ServerType.ZOOKEEPER;
            }
            case TABLET_SERVER: {
                return ServerType.TABLET_SERVER;
            }
            case GARBAGE_COLLECTOR: {
                return ServerType.GARBAGE_COLLECTOR;
            }
        }
        return null;
    }
}

