/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.cluster;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.apache.accumulo.cluster.RemoteShellOptions;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.util.Shell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteShell
extends Shell.ShellCommandExecutor {
    private static final Logger log = LoggerFactory.getLogger(RemoteShell.class);
    protected RemoteShellOptions options;
    protected String hostname;

    public RemoteShell(String hostname, String[] execString, File dir, Map<String, String> env, long timeout, RemoteShellOptions options) {
        super(execString, dir, env, timeout);
        this.hostname = hostname;
        this.setRemoteShellOptions(options);
    }

    public RemoteShell(String hostname, String[] execString, File dir, Map<String, String> env, RemoteShellOptions options) {
        super(execString, dir, env);
        this.hostname = hostname;
        this.setRemoteShellOptions(options);
    }

    public RemoteShell(String hostname, String[] execString, File dir, RemoteShellOptions options) {
        super(execString, dir);
        this.hostname = hostname;
        this.setRemoteShellOptions(options);
    }

    public RemoteShell(String hostname, String[] execString, RemoteShellOptions options) {
        super(execString);
        this.hostname = hostname;
        this.setRemoteShellOptions(options);
    }

    public void setRemoteShellOptions(RemoteShellOptions options) {
        Preconditions.checkNotNull((Object)options);
        this.options = options;
    }

    public RemoteShellOptions getRemoteShellOptions() {
        return this.options;
    }

    public String[] getExecString() {
        String hostWithUser = this.hostname;
        if (!this.options.getUserName().isEmpty()) {
            hostWithUser = this.options.getUserName() + "@" + hostWithUser;
        }
        String remoteCmd = StringUtils.join((Object[])super.getExecString(), (char)' ');
        String cmd = String.format("%1$s %2$s %3$s \"%4$s\"", this.options.getSshCommand(), this.options.getSshOptions(), hostWithUser, remoteCmd);
        log.debug("Executing full command [" + cmd + "]");
        return new String[]{"/usr/bin/env", "bash", "-c", cmd};
    }

    public void execute() throws IOException {
        super.execute();
    }
}

