/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.cluster.standalone;

import java.io.IOException;
import java.util.Arrays;
import org.apache.accumulo.cluster.AccumuloCluster;
import org.apache.accumulo.cluster.ClusterServerType;
import org.apache.accumulo.cluster.standalone.StandaloneClusterControl;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.ClientConfiguration;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.client.ZooKeeperInstance;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.util.CachedConfiguration;
import org.apache.accumulo.master.state.SetGoalState;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandaloneAccumuloCluster
implements AccumuloCluster {
    private static final Logger log = LoggerFactory.getLogger(StandaloneAccumuloCluster.class);
    private Instance instance;
    private String accumuloHome;
    private String accumuloConfDir;
    private String hadoopConfDir;

    public StandaloneAccumuloCluster(String instanceName, String zookeepers) {
        this((Instance)new ZooKeeperInstance(instanceName, zookeepers));
    }

    public StandaloneAccumuloCluster(Instance instance) {
        this.instance = instance;
    }

    public String getAccumuloHome() {
        return this.accumuloHome;
    }

    public void setAccumuloHome(String accumuloHome) {
        this.accumuloHome = accumuloHome;
    }

    public String getAccumuloConfDir() {
        return this.accumuloConfDir;
    }

    public void setAccumuloConfDir(String accumuloConfDir) {
        this.accumuloConfDir = accumuloConfDir;
    }

    public String getHadoopConfDir() {
        return this.hadoopConfDir;
    }

    public void setHadoopConfDir(String hadoopConfDir) {
        this.hadoopConfDir = hadoopConfDir;
    }

    @Override
    public String getInstanceName() {
        return this.instance.getInstanceName();
    }

    @Override
    public String getZooKeepers() {
        return this.instance.getZooKeepers();
    }

    @Override
    public Connector getConnector(String user, AuthenticationToken token) throws AccumuloException, AccumuloSecurityException {
        return this.instance.getConnector(user, token);
    }

    @Override
    public ClientConfiguration getClientConfig() {
        return ClientConfiguration.loadDefault().withInstance(this.getInstanceName()).withZkHosts(this.getZooKeepers());
    }

    @Override
    public StandaloneClusterControl getClusterControl() {
        return new StandaloneClusterControl(null == this.accumuloHome ? System.getenv("ACCUMULO_HOME") : this.accumuloHome, null == this.accumuloConfDir ? System.getenv("ACCUMULO_CONF_DIR") : this.accumuloConfDir);
    }

    @Override
    public void start() throws IOException {
        StandaloneClusterControl control = this.getClusterControl();
        control.exec(SetGoalState.class, new String[]{"NORMAL"});
        for (ClusterServerType type : Arrays.asList(ClusterServerType.MASTER, ClusterServerType.TABLET_SERVER, ClusterServerType.TRACER, ClusterServerType.GARBAGE_COLLECTOR, ClusterServerType.MONITOR)) {
            control.startAllServers(type);
        }
    }

    @Override
    public void stop() throws IOException {
        StandaloneClusterControl control = this.getClusterControl();
        for (ClusterServerType type : Arrays.asList(ClusterServerType.MASTER, ClusterServerType.TABLET_SERVER, ClusterServerType.TRACER, ClusterServerType.GARBAGE_COLLECTOR, ClusterServerType.MONITOR)) {
            control.stopAllServers(type);
        }
    }

    @Override
    public FileSystem getFileSystem() throws IOException {
        String confDir = this.hadoopConfDir;
        if (null == confDir) {
            confDir = System.getenv("HADOOP_CONF_DIR");
        }
        if (null == confDir) {
            throw new IllegalArgumentException("Cannot determine HADOOP_CONF_DIR for standalone cluster");
        }
        Configuration conf = CachedConfiguration.getInstance();
        conf.addResource(new Path(confDir, "core-site.xml"));
        conf.addResource(new Path(confDir, "hdfs-site.xml"));
        return FileSystem.get((Configuration)conf);
    }
}

