/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.cluster.standalone;

import com.google.common.collect.Maps;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.URL;
import java.security.CodeSource;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.accumulo.cluster.ClusterControl;
import org.apache.accumulo.cluster.ClusterServerType;
import org.apache.accumulo.cluster.RemoteShell;
import org.apache.accumulo.cluster.RemoteShellOptions;
import org.apache.accumulo.server.util.Admin;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.util.Shell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandaloneClusterControl
implements ClusterControl {
    private static final Logger log = LoggerFactory.getLogger(StandaloneClusterControl.class);
    private static final String START_SERVER_SCRIPT = "start-server.sh";
    private static final String ACCUMULO_SCRIPT = "accumulo";
    private static final String TOOL_SCRIPT = "tool.sh";
    private static final String MASTER_HOSTS_FILE = "masters";
    private static final String GC_HOSTS_FILE = "gc";
    private static final String TSERVER_HOSTS_FILE = "slaves";
    private static final String TRACER_HOSTS_FILE = "tracers";
    private static final String MONITOR_HOSTS_FILE = "monitor";
    protected String accumuloHome;
    protected String accumuloConfDir;
    protected RemoteShellOptions options = new RemoteShellOptions();
    protected String startServerPath;
    protected String accumuloPath;
    protected String toolPath;

    public StandaloneClusterControl() {
        this(System.getenv("ACCUMULO_HOME"), System.getenv("ACCUMULO_CONF_DIR"));
    }

    public StandaloneClusterControl(String accumuloHome, String accumuloConfDir) {
        this.accumuloHome = accumuloHome;
        this.accumuloConfDir = accumuloConfDir;
        File bin = new File(accumuloHome, "bin");
        this.startServerPath = new File(bin, START_SERVER_SCRIPT).getAbsolutePath();
        this.accumuloPath = new File(bin, ACCUMULO_SCRIPT).getAbsolutePath();
        this.toolPath = new File(bin, TOOL_SCRIPT).getAbsolutePath();
    }

    protected Map.Entry<Integer, String> exec(String hostname, String[] command) throws IOException {
        RemoteShell shell = new RemoteShell(hostname, command, this.options);
        try {
            shell.execute();
        }
        catch (Shell.ExitCodeException e) {
            String output = shell.getOutput();
            Shell.ExitCodeException ece = new Shell.ExitCodeException(e.getExitCode(), "stderr: " + e.getMessage() + ", stdout: " + output);
            log.error("Failed to run command", (Throwable)ece);
            return Maps.immutableEntry((Object)e.getExitCode(), (Object)output);
        }
        return Maps.immutableEntry((Object)shell.getExitCode(), (Object)shell.getOutput());
    }

    @Override
    public int exec(Class<?> clz, String[] args) throws IOException {
        return this.execWithStdout(clz, args).getKey();
    }

    @Override
    public Map.Entry<Integer, String> execWithStdout(Class<?> clz, String[] args) throws IOException {
        File confDir = this.getConfDir();
        String master = this.getHosts(new File(confDir, MASTER_HOSTS_FILE)).get(0);
        Object[] cmd = new String[2 + args.length];
        cmd[0] = this.accumuloPath;
        cmd[1] = clz.getName();
        System.arraycopy(args, 0, cmd, 2, args.length);
        log.info("Running: '{}' on {}", (Object)StringUtils.join((Object[])cmd, (String)" "), (Object)master);
        return this.exec(master, (String[])cmd);
    }

    public Map.Entry<Integer, String> execMapreduceWithStdout(Class<?> clz, String[] args) throws IOException {
        File confDir = this.getConfDir();
        String master = this.getHosts(new File(confDir, MASTER_HOSTS_FILE)).get(0);
        Object[] cmd = new String[3 + args.length];
        cmd[0] = this.toolPath;
        CodeSource source = clz.getProtectionDomain().getCodeSource();
        if (null == source) {
            throw new RuntimeException("Could not get CodeSource for class");
        }
        URL jarUrl = source.getLocation();
        String jar = jarUrl.getPath();
        if (!jar.endsWith(".jar")) {
            throw new RuntimeException("Need to have a jar to run mapreduce: " + jar);
        }
        cmd[1] = jar;
        cmd[2] = clz.getName();
        int i = 0;
        int j = 3;
        while (i < args.length) {
            cmd[j] = "'" + args[i] + "'";
            ++i;
            ++j;
        }
        log.info("Running: '{}' on {}", (Object)StringUtils.join((Object[])cmd, (String)" "), (Object)master);
        return this.exec(master, (String[])cmd);
    }

    @Override
    public void adminStopAll() throws IOException {
        File confDir = this.getConfDir();
        String master = this.getHosts(new File(confDir, MASTER_HOSTS_FILE)).get(0);
        String[] cmd = new String[]{this.accumuloPath, Admin.class.getName(), "stopAll"};
        Map.Entry<Integer, String> pair = this.exec(master, cmd);
        if (0 != pair.getKey()) {
            throw new IOException("stopAll did not finish successfully, retcode=" + pair.getKey() + ", stdout=" + pair.getValue());
        }
    }

    @Override
    public void startAllServers(ClusterServerType server) throws IOException {
        File confDir = this.getConfDir();
        switch (server) {
            case TABLET_SERVER: {
                for (String tserver : this.getHosts(new File(confDir, TSERVER_HOSTS_FILE))) {
                    this.start(server, tserver);
                }
                break;
            }
            case MASTER: {
                for (String master : this.getHosts(new File(confDir, MASTER_HOSTS_FILE))) {
                    this.start(server, master);
                }
                break;
            }
            case GARBAGE_COLLECTOR: {
                List<String> hosts = this.getHosts(new File(confDir, GC_HOSTS_FILE));
                if (hosts.isEmpty()) {
                    hosts = this.getHosts(new File(confDir, MASTER_HOSTS_FILE));
                    if (hosts.isEmpty()) {
                        throw new IOException("Found hosts to run garbage collector on");
                    }
                    hosts = Collections.singletonList(hosts.get(0));
                }
                for (String gc : hosts) {
                    this.start(server, gc);
                }
                break;
            }
            case TRACER: {
                for (String tracer : this.getHosts(new File(confDir, TRACER_HOSTS_FILE))) {
                    this.start(server, tracer);
                }
                break;
            }
            case MONITOR: {
                for (String monitor : this.getHosts(new File(confDir, MONITOR_HOSTS_FILE))) {
                    this.start(server, monitor);
                }
                break;
            }
            default: {
                throw new UnsupportedOperationException("Could not start servers for " + (Object)((Object)server));
            }
        }
    }

    @Override
    public void start(ClusterServerType server, String hostname) throws IOException {
        String[] cmd = new String[]{this.startServerPath, hostname, this.getProcessString(server)};
        Map.Entry<Integer, String> pair = this.exec(hostname, cmd);
        if (0 != pair.getKey()) {
            throw new IOException("Start " + (Object)((Object)server) + " on " + hostname + " failed for execute successfully");
        }
    }

    @Override
    public void stopAllServers(ClusterServerType server) throws IOException {
        File confDir = this.getConfDir();
        switch (server) {
            case TABLET_SERVER: {
                for (String tserver : this.getHosts(new File(confDir, TSERVER_HOSTS_FILE))) {
                    this.stop(server, tserver);
                }
                break;
            }
            case MASTER: {
                for (String master : this.getHosts(new File(confDir, MASTER_HOSTS_FILE))) {
                    this.stop(server, master);
                }
                break;
            }
            case GARBAGE_COLLECTOR: {
                for (String gc : this.getHosts(new File(confDir, GC_HOSTS_FILE))) {
                    this.stop(server, gc);
                }
                break;
            }
            case TRACER: {
                for (String tracer : this.getHosts(new File(confDir, TRACER_HOSTS_FILE))) {
                    this.stop(server, tracer);
                }
                break;
            }
            case MONITOR: {
                for (String monitor : this.getHosts(new File(confDir, MONITOR_HOSTS_FILE))) {
                    this.stop(server, monitor);
                }
                break;
            }
            default: {
                throw new UnsupportedOperationException("Could not start servers for " + (Object)((Object)server));
            }
        }
    }

    @Override
    public void stop(ClusterServerType server, String hostname) throws IOException {
        this.kill(server, hostname);
    }

    @Override
    public void signal(ClusterServerType server, String hostname, String signal) throws IOException {
        String pid = this.getPid(server, this.accumuloHome, hostname);
        if (pid.trim().isEmpty()) {
            log.debug("Found no processes for {} on {}", (Object)server, (Object)hostname);
            return;
        }
        boolean isSignalNumber = false;
        try {
            Integer.parseInt(signal);
            isSignalNumber = true;
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        String[] stopCmd = isSignalNumber ? new String[]{"kill", "-" + signal, pid} : new String[]{"kill", "-s", signal, pid};
        Map.Entry<Integer, String> pair = this.exec(hostname, stopCmd);
        if (0 != pair.getKey()) {
            throw new IOException("Signal " + signal + " to " + (Object)((Object)server) + " on " + hostname + " failed for execute successfully. stdout=" + pair.getValue());
        }
    }

    @Override
    public void suspend(ClusterServerType server, String hostname) throws IOException {
        this.signal(server, hostname, "SIGSTOP");
    }

    @Override
    public void resume(ClusterServerType server, String hostname) throws IOException {
        this.signal(server, hostname, "SIGCONT");
    }

    @Override
    public void kill(ClusterServerType server, String hostname) throws IOException {
        this.signal(server, hostname, "SIGKILL");
    }

    protected String getPid(ClusterServerType server, String accumuloHome, String hostname) throws IOException {
        String[] getPidCommand = this.getPidCommand(server, accumuloHome);
        Map.Entry<Integer, String> ret = this.exec(hostname, getPidCommand);
        if (0 != ret.getKey()) {
            throw new IOException("Could not locate PID for " + this.getProcessString(server) + " on " + hostname);
        }
        return ret.getValue();
    }

    protected String[] getPidCommand(ClusterServerType server, String accumuloHome) {
        return new String[]{"ps", "aux", "|", "fgrep", accumuloHome, "|", "fgrep", this.getProcessString(server), "|", "fgrep", "-v", "grep", "|", "fgrep", "-v", "ssh", "|", "awk", "'{print \\$2}'", "|", "head", "-1", "|", "tr", "-d", "'\\n'"};
    }

    protected String getProcessString(ClusterServerType server) {
        switch (server) {
            case TABLET_SERVER: {
                return "tserver";
            }
            case GARBAGE_COLLECTOR: {
                return GC_HOSTS_FILE;
            }
            case MASTER: {
                return "master";
            }
            case TRACER: {
                return "tracer";
            }
            case MONITOR: {
                return MONITOR_HOSTS_FILE;
            }
        }
        throw new UnsupportedOperationException("Unhandled ServerType " + (Object)((Object)server));
    }

    protected File getConfDir() {
        File confDir;
        String confPath;
        String string = confPath = null == this.accumuloConfDir ? System.getenv("ACCUMULO_CONF_DIR") : this.accumuloConfDir;
        if (null == confPath) {
            String homePath;
            String string2 = homePath = null == this.accumuloHome ? System.getenv("ACCUMULO_HOME") : this.accumuloHome;
            if (null == homePath) {
                throw new IllegalStateException("Cannot extrapolate an ACCUMULO_CONF_DIR");
            }
            confDir = new File(homePath, "conf");
        } else {
            confDir = new File(confPath);
        }
        if (!confDir.exists() || !confDir.isDirectory()) {
            throw new IllegalStateException("ACCUMULO_CONF_DIR does not exist or is not a directory: " + confDir);
        }
        return confDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<String> getHosts(File f) throws IOException {
        BufferedReader reader = new BufferedReader(new FileReader(f));
        try {
            ArrayList<String> hosts = new ArrayList<String>();
            String line = null;
            while ((line = reader.readLine()) != null) {
                if ((line = line.trim()).isEmpty() || line.startsWith("#")) continue;
                hosts.add(line);
            }
            ArrayList<String> arrayList = hosts;
            return arrayList;
        }
        finally {
            reader.close();
        }
    }
}

