/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.minicluster.impl;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.accumulo.cluster.ClusterServerType;
import org.apache.accumulo.core.conf.CredentialProviderFactoryShim;
import org.apache.accumulo.core.conf.DefaultConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.minicluster.MemoryUnit;
import org.apache.accumulo.server.util.PortUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.log4j.Logger;

public class MiniAccumuloConfigImpl {
    private static final Logger log = Logger.getLogger(MiniAccumuloConfigImpl.class);
    private static final String DEFAULT_INSTANCE_SECRET = "DONTTELL";
    private File dir = null;
    private String rootPassword = null;
    private Map<String, String> siteConfig = new HashMap<String, String>();
    private Map<String, String> configuredSiteConig = new HashMap<String, String>();
    private int numTservers = 2;
    private Map<ClusterServerType, Long> memoryConfig = new HashMap<ClusterServerType, Long>();
    private boolean jdwpEnabled = false;
    private Map<String, String> systemProperties = new HashMap<String, String>();
    private String instanceName = "miniInstance";
    private File libDir;
    private File libExtDir;
    private File confDir;
    private File hadoopConfDir = null;
    private File zooKeeperDir;
    private File accumuloDir;
    private File logDir;
    private File walogDir;
    private int zooKeeperPort = 0;
    private int configuredZooKeeperPort = 0;
    private long zooKeeperStartupTime = 20000L;
    private long defaultMemorySize = 0x8000000L;
    private boolean initialized = false;
    private Boolean existingInstance = null;
    private boolean useMiniDFS = false;
    private boolean useCredentialProvider = false;
    private String[] classpathItems = null;
    private String[] nativePathItems = null;
    private Configuration hadoopConf;
    private Configuration accumuloConf;

    public MiniAccumuloConfigImpl(File dir, String rootPassword) {
        this.dir = dir;
        this.rootPassword = rootPassword;
    }

    MiniAccumuloConfigImpl initialize() {
        if (this.getDir().exists() && !this.getDir().isDirectory()) {
            throw new IllegalArgumentException("Must pass in directory, " + this.getDir() + " is a file");
        }
        if (this.getDir().exists() && this.getDir().list().length != 0) {
            throw new IllegalArgumentException("Directory " + this.getDir() + " is not empty");
        }
        if (!this.initialized) {
            this.libDir = new File(this.dir, "lib");
            this.libExtDir = new File(this.libDir, "ext");
            this.confDir = new File(this.dir, "conf");
            this.accumuloDir = new File(this.dir, "accumulo");
            this.zooKeeperDir = new File(this.dir, "zookeeper");
            this.logDir = new File(this.dir, "logs");
            this.walogDir = new File(this.dir, "walogs");
            if (this.existingInstance == null || !this.existingInstance.booleanValue()) {
                this.existingInstance = false;
                this.setInstanceLocation();
                this.mergeProp(Property.INSTANCE_SECRET.getKey(), DEFAULT_INSTANCE_SECRET);
                this.mergeProp(Property.LOGGER_DIR.getKey(), this.walogDir.getAbsolutePath());
                this.mergeProp(Property.TRACE_TOKEN_PROPERTY_PREFIX.getKey() + "password", this.getRootPassword());
            }
            this.mergeProp(Property.TSERV_PORTSEARCH.getKey(), "true");
            this.mergeProp(Property.TSERV_DATACACHE_SIZE.getKey(), "10M");
            this.mergeProp(Property.TSERV_INDEXCACHE_SIZE.getKey(), "10M");
            this.mergeProp(Property.TSERV_MAXMEM.getKey(), "50M");
            this.mergeProp(Property.TSERV_WALOG_MAX_SIZE.getKey(), "100M");
            this.mergeProp(Property.TSERV_NATIVEMAP_ENABLED.getKey(), "false");
            this.mergeProp(Property.TSERV_MAJC_DELAY.getKey(), "3");
            this.mergeProp(Property.GENERAL_CLASSPATHS.getKey(), this.libDir.getAbsolutePath() + "/[^.].*[.]jar");
            this.mergeProp(Property.GENERAL_DYNAMIC_CLASSPATHS.getKey(), this.libExtDir.getAbsolutePath() + "/[^.].*[.]jar");
            this.mergeProp(Property.GC_CYCLE_DELAY.getKey(), "4s");
            this.mergeProp(Property.GC_CYCLE_START.getKey(), "0s");
            this.mergePropWithRandomPort(Property.MASTER_CLIENTPORT.getKey());
            this.mergePropWithRandomPort(Property.TRACE_PORT.getKey());
            this.mergePropWithRandomPort(Property.TSERV_CLIENTPORT.getKey());
            this.mergePropWithRandomPort(Property.MONITOR_PORT.getKey());
            this.mergePropWithRandomPort(Property.GC_PORT.getKey());
            this.mergePropWithRandomPort(Property.MONITOR_LOG4J_PORT.getKey());
            if (this.isUseCredentialProvider()) {
                this.updateConfigForCredentialProvider();
            }
            if (this.existingInstance == null || !this.existingInstance.booleanValue()) {
                this.existingInstance = false;
                if (this.zooKeeperPort == 0) {
                    this.zooKeeperPort = PortUtils.getRandomFreePort();
                }
                this.siteConfig.put(Property.INSTANCE_ZK_HOST.getKey(), "localhost:" + this.zooKeeperPort);
            }
            this.initialized = true;
        }
        return this;
    }

    private void updateConfigForCredentialProvider() {
        String cpPaths = this.siteConfig.get(Property.GENERAL_SECURITY_CREDENTIAL_PROVIDER_PATHS.getKey());
        if (null != cpPaths && !Property.GENERAL_SECURITY_CREDENTIAL_PROVIDER_PATHS.getDefaultValue().equals(cpPaths)) {
            return;
        }
        if (!CredentialProviderFactoryShim.isHadoopCredentialProviderAvailable()) {
            throw new RuntimeException("Cannot use CredentialProvider when implementation is not available. Be sure to use >=Hadoop-2.6.0");
        }
        File keystoreFile = new File(this.getConfDir(), "credential-provider.jks");
        String keystoreUri = "jceks://file" + keystoreFile.getAbsolutePath();
        Configuration conf = CredentialProviderFactoryShim.getConfiguration((String)keystoreUri);
        this.siteConfig.put(Property.GENERAL_SECURITY_CREDENTIAL_PROVIDER_PATHS.getKey(), keystoreUri);
        Iterator<Map.Entry<String, String>> entries = this.siteConfig.entrySet().iterator();
        while (entries.hasNext()) {
            Map.Entry<String, String> entry = entries.next();
            if (!Property.isSensitive((String)entry.getKey())) continue;
            try {
                CredentialProviderFactoryShim.createEntry((Configuration)conf, (String)entry.getKey(), (char[])entry.getValue().toCharArray());
            }
            catch (IOException e) {
                log.warn((Object)("Attempted to add " + entry.getKey() + " to CredentialProvider but failed"), (Throwable)e);
                continue;
            }
            entries.remove();
        }
    }

    private void setInstanceLocation() {
        this.mergeProp(Property.INSTANCE_DFS_URI.getKey(), "file:///");
        this.mergeProp(Property.INSTANCE_DFS_DIR.getKey(), this.accumuloDir.getAbsolutePath());
    }

    private void mergeProp(String key, String value) {
        if (!this.siteConfig.containsKey(key)) {
            this.siteConfig.put(key, value);
        }
    }

    private void mergePropWithRandomPort(String key) {
        if (!this.siteConfig.containsKey(key)) {
            this.siteConfig.put(key, "0");
        }
    }

    public MiniAccumuloConfigImpl setNumTservers(int numTservers) {
        if (numTservers < 1) {
            throw new IllegalArgumentException("Must have at least one tablet server");
        }
        this.numTservers = numTservers;
        return this;
    }

    public MiniAccumuloConfigImpl setInstanceName(String instanceName) {
        this.instanceName = instanceName;
        return this;
    }

    public MiniAccumuloConfigImpl setSiteConfig(Map<String, String> siteConfig) {
        if (this.existingInstance != null && this.existingInstance.booleanValue()) {
            throw new UnsupportedOperationException("Cannot set set config info when using an existing instance.");
        }
        this.existingInstance = Boolean.FALSE;
        return this._setSiteConfig(siteConfig);
    }

    private MiniAccumuloConfigImpl _setSiteConfig(Map<String, String> siteConfig) {
        this.siteConfig = new HashMap<String, String>(siteConfig);
        this.configuredSiteConig = new HashMap<String, String>(siteConfig);
        return this;
    }

    public MiniAccumuloConfigImpl setZooKeeperPort(int zooKeeperPort) {
        if (this.existingInstance != null && this.existingInstance.booleanValue()) {
            throw new UnsupportedOperationException("Cannot set zookeeper info when using an existing instance.");
        }
        this.existingInstance = Boolean.FALSE;
        this.configuredZooKeeperPort = zooKeeperPort;
        this.zooKeeperPort = zooKeeperPort;
        return this;
    }

    public MiniAccumuloConfigImpl setZooKeeperStartupTime(long zooKeeperStartupTime) {
        if (this.existingInstance != null && this.existingInstance.booleanValue()) {
            throw new UnsupportedOperationException("Cannot set zookeeper info when using an existing instance.");
        }
        this.existingInstance = Boolean.FALSE;
        this.zooKeeperStartupTime = zooKeeperStartupTime;
        return this;
    }

    public MiniAccumuloConfigImpl setMemory(ClusterServerType serverType, long memory, MemoryUnit memoryUnit) {
        this.memoryConfig.put(serverType, memoryUnit.toBytes(memory));
        return this;
    }

    public MiniAccumuloConfigImpl setDefaultMemory(long memory, MemoryUnit memoryUnit) {
        this.defaultMemorySize = memoryUnit.toBytes(memory);
        return this;
    }

    public Map<String, String> getSiteConfig() {
        return new HashMap<String, String>(this.siteConfig);
    }

    public Map<String, String> getConfiguredSiteConfig() {
        return new HashMap<String, String>(this.configuredSiteConig);
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    public int getZooKeeperPort() {
        return this.zooKeeperPort;
    }

    public int getConfiguredZooKeeperPort() {
        return this.configuredZooKeeperPort;
    }

    public long getZooKeeperStartupTime() {
        return this.zooKeeperStartupTime;
    }

    File getLibDir() {
        return this.libDir;
    }

    File getLibExtDir() {
        return this.libExtDir;
    }

    public File getConfDir() {
        return this.confDir;
    }

    File getZooKeeperDir() {
        return this.zooKeeperDir;
    }

    public File getAccumuloDir() {
        return this.accumuloDir;
    }

    public File getLogDir() {
        return this.logDir;
    }

    File getWalogDir() {
        return this.walogDir;
    }

    public long getMemory(ClusterServerType serverType) {
        return this.memoryConfig.containsKey((Object)serverType) ? this.memoryConfig.get((Object)serverType) : this.defaultMemorySize;
    }

    public long getDefaultMemory() {
        return this.defaultMemorySize;
    }

    public String getZooKeepers() {
        return this.siteConfig.get(Property.INSTANCE_ZK_HOST.getKey());
    }

    public File getDir() {
        return this.dir;
    }

    public String getRootPassword() {
        return this.rootPassword;
    }

    public int getNumTservers() {
        return this.numTservers;
    }

    public boolean isJDWPEnabled() {
        return this.jdwpEnabled;
    }

    public MiniAccumuloConfigImpl setJDWPEnabled(boolean jdwpEnabled) {
        this.jdwpEnabled = jdwpEnabled;
        return this;
    }

    public boolean useMiniDFS() {
        return this.useMiniDFS;
    }

    public void useMiniDFS(boolean useMiniDFS) {
        this.useMiniDFS = useMiniDFS;
    }

    public File getClientConfFile() {
        return new File(this.getConfDir(), "client.conf");
    }

    public void setSystemProperties(Map<String, String> systemProperties) {
        this.systemProperties = new HashMap<String, String>(systemProperties);
    }

    public Map<String, String> getSystemProperties() {
        return new HashMap<String, String>(this.systemProperties);
    }

    public String[] getClasspathItems() {
        return this.classpathItems;
    }

    public void setClasspathItems(String ... classpathItems) {
        this.classpathItems = classpathItems;
    }

    public String[] getNativeLibPaths() {
        return this.nativePathItems == null ? new String[]{} : this.nativePathItems;
    }

    public MiniAccumuloConfigImpl setNativeLibPaths(String ... nativePathItems) {
        this.nativePathItems = nativePathItems;
        return this;
    }

    public void setProperty(Property p, String value) {
        this.siteConfig.put(p.getKey(), value);
    }

    public boolean isUseCredentialProvider() {
        return this.useCredentialProvider;
    }

    public void setUseCredentialProvider(boolean useCredentialProvider) {
        this.useCredentialProvider = useCredentialProvider;
    }

    public MiniAccumuloConfigImpl useExistingInstance(File accumuloSite, File hadoopConfDir) throws IOException {
        if (this.existingInstance != null && !this.existingInstance.booleanValue()) {
            throw new UnsupportedOperationException("Cannot set to useExistingInstance after specifying config/zookeeper");
        }
        this.existingInstance = Boolean.TRUE;
        System.setProperty("org.apache.accumulo.config.file", "accumulo-site.xml");
        this.hadoopConfDir = hadoopConfDir;
        this.hadoopConf = new Configuration(false);
        this.accumuloConf = new Configuration(false);
        File coreSite = new File(hadoopConfDir, "core-site.xml");
        File hdfsSite = new File(hadoopConfDir, "hdfs-site.xml");
        this.accumuloConf.addResource(accumuloSite.toURI().toURL());
        this.hadoopConf.addResource(coreSite.toURI().toURL());
        this.hadoopConf.addResource(hdfsSite.toURI().toURL());
        HashMap<String, String> siteConfigMap = new HashMap<String, String>();
        for (Map.Entry e : this.accumuloConf) {
            siteConfigMap.put((String)e.getKey(), (String)e.getValue());
        }
        this._setSiteConfig(siteConfigMap);
        for (Map.Entry entry : DefaultConfiguration.getDefaultConfiguration()) {
            this.accumuloConf.setIfUnset((String)entry.getKey(), (String)entry.getValue());
        }
        return this;
    }

    public boolean useExistingInstance() {
        return this.existingInstance != null && this.existingInstance != false;
    }

    public File getHadoopConfDir() {
        return this.hadoopConfDir;
    }

    public Configuration getAccumuloConfiguration() {
        return this.accumuloConf;
    }

    public Configuration getHadoopConfiguration() {
        return this.hadoopConf;
    }
}

