/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.minicluster;

import java.io.File;
import java.io.FileNotFoundException;
import java.net.MalformedURLException;
import org.apache.accumulo.core.client.ClientConfiguration;
import org.apache.accumulo.core.client.ZooKeeperInstance;
import org.apache.accumulo.core.conf.Property;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;

public class MiniAccumuloInstance
extends ZooKeeperInstance {
    public MiniAccumuloInstance(String instanceName, File directory) throws FileNotFoundException {
        super((Configuration)new ClientConfiguration(new Configuration[]{MiniAccumuloInstance.getConfigProperties(directory)}).withInstance(instanceName).withZkHosts(MiniAccumuloInstance.getZooKeepersFromDir(directory)));
    }

    public static PropertiesConfiguration getConfigProperties(File directory) {
        try {
            PropertiesConfiguration conf = new PropertiesConfiguration();
            conf.setListDelimiter('\u0000');
            conf.load(new File(new File(directory, "conf"), "client.conf"));
            return conf;
        }
        catch (ConfigurationException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private static String getZooKeepersFromDir(File directory) throws FileNotFoundException {
        if (!directory.isDirectory()) {
            throw new IllegalArgumentException("Not a directory " + directory.getPath());
        }
        File configFile = new File(new File(directory, "conf"), "accumulo-site.xml");
        org.apache.hadoop.conf.Configuration conf = new org.apache.hadoop.conf.Configuration(false);
        try {
            conf.addResource(configFile.toURI().toURL());
        }
        catch (MalformedURLException e) {
            throw new FileNotFoundException("Missing file: " + configFile.getPath());
        }
        return conf.get(Property.INSTANCE_ZK_HOST.getKey());
    }
}

