/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.minicluster.impl;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.accumulo.cluster.AccumuloCluster;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.ClientConfiguration;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.client.ZooKeeperInstance;
import org.apache.accumulo.core.client.impl.ClientContext;
import org.apache.accumulo.core.client.impl.Credentials;
import org.apache.accumulo.core.client.impl.MasterClient;
import org.apache.accumulo.core.client.impl.thrift.ThriftSecurityException;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.client.security.tokens.PasswordToken;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.ConfigurationCopy;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.master.thrift.MasterClientService;
import org.apache.accumulo.core.master.thrift.MasterGoalState;
import org.apache.accumulo.core.master.thrift.MasterMonitorInfo;
import org.apache.accumulo.core.trace.Tracer;
import org.apache.accumulo.core.util.CachedConfiguration;
import org.apache.accumulo.core.util.Daemon;
import org.apache.accumulo.core.util.Pair;
import org.apache.accumulo.core.util.UtilWaitThread;
import org.apache.accumulo.core.zookeeper.ZooUtil;
import org.apache.accumulo.fate.zookeeper.IZooReader;
import org.apache.accumulo.fate.zookeeper.IZooReaderWriter;
import org.apache.accumulo.master.state.SetGoalState;
import org.apache.accumulo.minicluster.ServerType;
import org.apache.accumulo.minicluster.impl.MiniAccumuloClusterControl;
import org.apache.accumulo.minicluster.impl.MiniAccumuloConfigImpl;
import org.apache.accumulo.minicluster.impl.ProcessNotFoundException;
import org.apache.accumulo.minicluster.impl.ProcessReference;
import org.apache.accumulo.minicluster.impl.ZooKeeperBindException;
import org.apache.accumulo.server.Accumulo;
import org.apache.accumulo.server.fs.VolumeManager;
import org.apache.accumulo.server.fs.VolumeManagerImpl;
import org.apache.accumulo.server.init.Initialize;
import org.apache.accumulo.server.util.AccumuloStatus;
import org.apache.accumulo.server.util.PortUtils;
import org.apache.accumulo.server.util.time.SimpleTimer;
import org.apache.accumulo.server.zookeeper.ZooReaderWriterFactory;
import org.apache.accumulo.start.Main;
import org.apache.accumulo.start.classloader.vfs.MiniDFSUtil;
import org.apache.commons.configuration.AbstractConfiguration;
import org.apache.commons.configuration.MapConfiguration;
import org.apache.commons.io.FileUtils;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.impl.VFSClassLoader;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.thrift.TException;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MiniAccumuloClusterImpl
implements AccumuloCluster {
    private static final Logger log = LoggerFactory.getLogger(MiniAccumuloClusterImpl.class);
    private boolean initialized = false;
    private Set<Pair<ServerType, Integer>> debugPorts = new HashSet<Pair<ServerType, Integer>>();
    private File zooCfgFile;
    private String dfsUri;
    private List<LogWriter> logWriters = new ArrayList<LogWriter>();
    private MiniAccumuloConfigImpl config;
    private MiniDFSCluster miniDFS = null;
    private List<Process> cleanup = new ArrayList<Process>();
    private ExecutorService executor;
    private MiniAccumuloClusterControl clusterControl;

    public List<LogWriter> getLogWriters() {
        return this.logWriters;
    }

    File getZooCfgFile() {
        return this.zooCfgFile;
    }

    public Process exec(Class<?> clazz, String ... args) throws IOException {
        return this.exec(clazz, (List<String>)null, args);
    }

    public Process exec(Class<?> clazz, List<String> jvmArgs, String ... args) throws IOException {
        ArrayList<String> jvmArgs2 = new ArrayList<String>(1 + (jvmArgs == null ? 0 : jvmArgs.size()));
        jvmArgs2.add("-Xmx" + this.config.getDefaultMemory());
        if (jvmArgs != null) {
            jvmArgs2.addAll(jvmArgs);
        }
        return this._exec(clazz, jvmArgs2, args);
    }

    private boolean containsSiteFile(File f) {
        if (!f.isDirectory()) {
            return false;
        }
        File[] files = f.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.getName().endsWith("site.xml");
            }
        });
        return files != null && files.length > 0;
    }

    private void append(StringBuilder classpathBuilder, URL url) throws URISyntaxException {
        File file = new File(url.toURI());
        if (!this.containsSiteFile(file)) {
            classpathBuilder.append(File.pathSeparator).append(file.getAbsolutePath());
        }
    }

    private String getClasspath() throws IOException {
        try {
            ArrayList<ClassLoader> classloaders = new ArrayList<ClassLoader>();
            for (ClassLoader cl = this.getClass().getClassLoader(); cl != null; cl = cl.getParent()) {
                classloaders.add(cl);
            }
            Collections.reverse(classloaders);
            StringBuilder classpathBuilder = new StringBuilder();
            classpathBuilder.append(this.config.getConfDir().getAbsolutePath());
            if (this.config.getHadoopConfDir() != null) {
                classpathBuilder.append(File.pathSeparator).append(this.config.getHadoopConfDir().getAbsolutePath());
            }
            if (this.config.getClasspathItems() == null) {
                for (int i = 1; i < classloaders.size(); ++i) {
                    ClassLoader classLoader = (ClassLoader)classloaders.get(i);
                    if (classLoader instanceof URLClassLoader) {
                        for (URL u : ((URLClassLoader)classLoader).getURLs()) {
                            this.append(classpathBuilder, u);
                        }
                        continue;
                    }
                    if (classLoader instanceof VFSClassLoader) {
                        VFSClassLoader vcl = (VFSClassLoader)classLoader;
                        for (FileObject f : vcl.getFileObjects()) {
                            this.append(classpathBuilder, f.getURL());
                        }
                        continue;
                    }
                    throw new IllegalArgumentException("Unknown classloader type : " + classLoader.getClass().getName());
                }
            } else {
                for (String s : this.config.getClasspathItems()) {
                    classpathBuilder.append(File.pathSeparator).append(s);
                }
            }
            return classpathBuilder.toString();
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
    }

    private Process _exec(Class<?> clazz, List<String> extraJvmOpts, String ... args) throws IOException {
        String javaHome = System.getProperty("java.home");
        String javaBin = javaHome + File.separator + "bin" + File.separator + "java";
        String classpath = this.getClasspath();
        String className = clazz.getName();
        ArrayList<String> argList = new ArrayList<String>();
        argList.addAll(Arrays.asList(javaBin, "-Dproc=" + clazz.getSimpleName(), "-cp", classpath));
        argList.addAll(extraJvmOpts);
        for (Map.Entry<String, String> sysProp : this.config.getSystemProperties().entrySet()) {
            argList.add(String.format("-D%s=%s", sysProp.getKey(), sysProp.getValue()));
        }
        argList.addAll(Arrays.asList("-XX:+UseConcMarkSweepGC", "-XX:CMSInitiatingOccupancyFraction=75", "-Dapple.awt.UIElement=true", "-Djava.net.preferIPv4Stack=true", "-XX:+PerfDisableSharedMem", "-XX:+AlwaysPreTouch", Main.class.getName(), className));
        argList.addAll(Arrays.asList(args));
        ProcessBuilder builder = new ProcessBuilder(argList);
        builder.environment().put("ACCUMULO_HOME", this.config.getDir().getAbsolutePath());
        builder.environment().put("ACCUMULO_LOG_DIR", this.config.getLogDir().getAbsolutePath());
        builder.environment().put("ACCUMULO_CLIENT_CONF_PATH", this.config.getClientConfFile().getAbsolutePath());
        String ldLibraryPath = Joiner.on((String)File.pathSeparator).join((Object[])this.config.getNativeLibPaths());
        builder.environment().put("LD_LIBRARY_PATH", ldLibraryPath);
        builder.environment().put("DYLD_LIBRARY_PATH", ldLibraryPath);
        String env = System.getenv("HADOOP_PREFIX");
        if (env != null) {
            builder.environment().put("HADOOP_PREFIX", env);
        }
        if ((env = System.getenv("ZOOKEEPER_HOME")) != null) {
            builder.environment().put("ZOOKEEPER_HOME", env);
        }
        builder.environment().put("ACCUMULO_CONF_DIR", this.config.getConfDir().getAbsolutePath());
        builder.environment().put("HADOOP_HOME", this.config.getDir().getAbsolutePath());
        if (this.config.getHadoopConfDir() != null) {
            builder.environment().put("HADOOP_CONF_DIR", this.config.getHadoopConfDir().getAbsolutePath());
        }
        Process process = builder.start();
        LogWriter lw = new LogWriter(process.getErrorStream(), new File(this.config.getLogDir(), clazz.getSimpleName() + "_" + process.hashCode() + ".err"));
        this.logWriters.add(lw);
        lw.start();
        lw = new LogWriter(process.getInputStream(), new File(this.config.getLogDir(), clazz.getSimpleName() + "_" + process.hashCode() + ".out"));
        this.logWriters.add(lw);
        lw.start();
        this.cleanup.add(process);
        return process;
    }

    Process _exec(Class<?> clazz, ServerType serverType, String ... args) throws IOException {
        ArrayList<String> jvmOpts = new ArrayList<String>();
        jvmOpts.add("-Xmx" + this.config.getMemory(serverType));
        if (this.config.isJDWPEnabled()) {
            Integer port = PortUtils.getRandomFreePort();
            jvmOpts.addAll(this.buildRemoteDebugParams(port));
            this.debugPorts.add((Pair<ServerType, Integer>)new Pair((Object)serverType, (Object)port));
        }
        return this._exec(clazz, jvmOpts, args);
    }

    public MiniAccumuloClusterImpl(File dir, String rootPassword) throws IOException {
        this(new MiniAccumuloConfigImpl(dir, rootPassword));
    }

    public MiniAccumuloClusterImpl(MiniAccumuloConfigImpl config) throws IOException {
        InputStream auditStream;
        this.config = config.initialize();
        MiniAccumuloClusterImpl.mkdirs(config.getConfDir());
        MiniAccumuloClusterImpl.mkdirs(config.getLogDir());
        MiniAccumuloClusterImpl.mkdirs(config.getLibDir());
        MiniAccumuloClusterImpl.mkdirs(config.getLibExtDir());
        if (!config.useExistingInstance()) {
            MiniAccumuloClusterImpl.mkdirs(config.getZooKeeperDir());
            MiniAccumuloClusterImpl.mkdirs(config.getWalogDir());
            MiniAccumuloClusterImpl.mkdirs(config.getAccumuloDir());
        }
        if (config.useMiniDFS()) {
            File nn = new File(config.getAccumuloDir(), "nn");
            MiniAccumuloClusterImpl.mkdirs(nn);
            File dn = new File(config.getAccumuloDir(), "dn");
            MiniAccumuloClusterImpl.mkdirs(dn);
            File dfs = new File(config.getAccumuloDir(), "dfs");
            MiniAccumuloClusterImpl.mkdirs(dfs);
            Configuration conf = new Configuration();
            conf.set("dfs.namenode.name.dir", nn.getAbsolutePath());
            conf.set("dfs.datanode.data.dir", dn.getAbsolutePath());
            conf.set("dfs.replication", "1");
            conf.set("dfs.support.append", "true");
            conf.set("dfs.datanode.synconclose", "true");
            conf.set("dfs.datanode.data.dir.perm", MiniDFSUtil.computeDatanodeDirectoryPermission());
            String oldTestBuildData = System.setProperty("test.build.data", dfs.getAbsolutePath());
            this.miniDFS = new MiniDFSCluster.Builder(conf).build();
            if (oldTestBuildData == null) {
                System.clearProperty("test.build.data");
            } else {
                System.setProperty("test.build.data", oldTestBuildData);
            }
            this.miniDFS.waitClusterUp();
            InetSocketAddress dfsAddress = this.miniDFS.getNameNode().getNameNodeAddress();
            this.dfsUri = "hdfs://" + dfsAddress.getHostName() + ":" + dfsAddress.getPort();
            File coreFile = new File(config.getConfDir(), "core-site.xml");
            this.writeConfig(coreFile, Collections.singletonMap("fs.default.name", this.dfsUri).entrySet());
            File hdfsFile = new File(config.getConfDir(), "hdfs-site.xml");
            this.writeConfig(hdfsFile, (Iterable<Map.Entry<String, String>>)conf);
            Map<String, String> siteConfig = config.getSiteConfig();
            siteConfig.put(Property.INSTANCE_DFS_URI.getKey(), this.dfsUri);
            siteConfig.put(Property.INSTANCE_DFS_DIR.getKey(), "/accumulo");
            config.setSiteConfig(siteConfig);
        } else {
            this.dfsUri = config.useExistingInstance() ? CachedConfiguration.getInstance().get("fs.defaultFS") : "file:///";
        }
        File clientConfFile = config.getClientConfFile();
        this.writeConfigProperties(clientConfFile, Maps.filterEntries(config.getSiteConfig(), (Predicate)new Predicate<Map.Entry<String, String>>(){

            public boolean apply(Map.Entry<String, String> v) {
                return ClientConfiguration.ClientProperty.getPropertyByKey((String)v.getKey()) != null;
            }
        }));
        File siteFile = new File(config.getConfDir(), "accumulo-site.xml");
        this.writeConfig(siteFile, config.getSiteConfig().entrySet());
        if (!config.useExistingInstance()) {
            this.zooCfgFile = new File(config.getConfDir(), "zoo.cfg");
            FileWriter fileWriter = new FileWriter(this.zooCfgFile);
            Properties zooCfg = new Properties();
            zooCfg.setProperty("tickTime", "2000");
            zooCfg.setProperty("initLimit", "10");
            zooCfg.setProperty("syncLimit", "5");
            zooCfg.setProperty("clientPortAddress", "127.0.0.1");
            zooCfg.setProperty("clientPort", config.getZooKeeperPort() + "");
            zooCfg.setProperty("maxClientCnxns", "1000");
            zooCfg.setProperty("dataDir", config.getZooKeeperDir().getAbsolutePath());
            zooCfg.store(fileWriter, null);
            fileWriter.close();
        }
        if ((auditStream = this.getClass().getResourceAsStream("/auditLog.xml")) != null) {
            FileUtils.copyInputStreamToFile((InputStream)auditStream, (File)new File(config.getConfDir(), "auditLog.xml"));
        }
        this.clusterControl = new MiniAccumuloClusterControl(this);
    }

    private static void mkdirs(File dir) {
        if (!dir.mkdirs()) {
            log.warn("Unable to create {}", (Object)dir);
        }
    }

    private void writeConfig(File file, Iterable<Map.Entry<String, String>> settings) throws IOException {
        FileWriter fileWriter = new FileWriter(file);
        fileWriter.append("<configuration>\n");
        for (Map.Entry<String, String> entry : settings) {
            String value = entry.getValue().replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;");
            fileWriter.append("<property><name>" + entry.getKey() + "</name><value>" + value + "</value></property>\n");
        }
        fileWriter.append("</configuration>\n");
        fileWriter.close();
    }

    private void writeConfigProperties(File file, Map<String, String> settings) throws IOException {
        FileWriter fileWriter = new FileWriter(file);
        for (Map.Entry<String, String> entry : settings.entrySet()) {
            fileWriter.append(entry.getKey() + "=" + entry.getValue() + "\n");
        }
        fileWriter.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void start() throws IOException, InterruptedException {
        if (this.config.useMiniDFS() && this.miniDFS == null) {
            throw new IllegalStateException("Cannot restart mini when using miniDFS");
        }
        MiniAccumuloClusterControl control = this.getClusterControl();
        if (this.config.useExistingInstance()) {
            VolumeManager fs;
            Configuration acuConf = this.config.getAccumuloConfiguration();
            Configuration hadoopConf = this.config.getHadoopConfiguration();
            ConfigurationCopy cc = new ConfigurationCopy((Iterable)acuConf);
            try {
                fs = VolumeManagerImpl.get((AccumuloConfiguration)cc, (Configuration)hadoopConf);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            Path instanceIdPath = Accumulo.getAccumuloInstanceIdPath((VolumeManager)fs);
            String instanceIdFromFile = ZooUtil.getInstanceIDFromHdfs((Path)instanceIdPath, (AccumuloConfiguration)cc, (Configuration)hadoopConf);
            IZooReaderWriter zrw = new ZooReaderWriterFactory().getZooReaderWriter(cc.get(Property.INSTANCE_ZK_HOST), (int)cc.getTimeInMillis(Property.INSTANCE_ZK_TIMEOUT), cc.get(Property.INSTANCE_SECRET));
            String rootPath = ZooUtil.getRoot((String)instanceIdFromFile);
            String instanceName = null;
            try {
                for (String name : zrw.getChildren("/accumulo/instances")) {
                    String instanceNamePath = "/accumulo/instances/" + name;
                    byte[] bytes = zrw.getData(instanceNamePath, new Stat());
                    String iid = new String(bytes, StandardCharsets.UTF_8);
                    if (!iid.equals(instanceIdFromFile)) continue;
                    instanceName = name;
                }
            }
            catch (KeeperException e) {
                throw new RuntimeException("Unable to read instance name from zookeeper.", e);
            }
            if (instanceName == null) {
                throw new RuntimeException("Unable to read instance name from zookeeper.");
            }
            this.config.setInstanceName(instanceName);
            if (!AccumuloStatus.isAccumuloOffline((IZooReader)zrw, (String)rootPath)) {
                throw new RuntimeException("The Accumulo instance being used is already running. Aborting.");
            }
        } else {
            if (!this.initialized) {
                Runtime.getRuntime().addShutdownHook(new Thread(){

                    @Override
                    public void run() {
                        try {
                            MiniAccumuloClusterImpl.this.stop();
                        }
                        catch (IOException e) {
                            log.error("IOException while attempting to stop the MiniAccumuloCluster.", (Throwable)e);
                        }
                        catch (InterruptedException e) {
                            log.error("The stopping of MiniAccumuloCluster was interrupted.", (Throwable)e);
                        }
                    }
                });
            }
            control.start(ServerType.ZOOKEEPER);
            if (!this.initialized) {
                Process initProcess;
                int ret;
                long startTime = System.currentTimeMillis();
                while (true) {
                    Socket s = null;
                    try {
                        s = new Socket("localhost", this.config.getZooKeeperPort());
                        s.setReuseAddress(true);
                        s.getOutputStream().write("ruok\n".getBytes());
                        s.getOutputStream().flush();
                        byte[] buffer = new byte[100];
                        int n = s.getInputStream().read(buffer);
                        if (n < 4 || !new String(buffer, 0, 4).equals("imok")) continue;
                    }
                    catch (Exception e) {
                        if (System.currentTimeMillis() - startTime >= this.config.getZooKeeperStartupTime()) {
                            throw new ZooKeeperBindException("Zookeeper did not start within " + this.config.getZooKeeperStartupTime() / 1000L + " seconds. Check the logs in " + this.config.getLogDir() + " for errors.  Last exception: " + e);
                        }
                        Thread.sleep(250L);
                        continue;
                    }
                    finally {
                        if (s == null) continue;
                        s.close();
                        continue;
                    }
                    break;
                }
                LinkedList<String> args = new LinkedList<String>();
                args.add("--instance-name");
                args.add(this.config.getInstanceName());
                args.add("--user");
                args.add(this.config.getRootUserName());
                String saslEnabled = this.config.getSiteConfig().get(Property.INSTANCE_RPC_SASL_ENABLED.getKey());
                if (null == saslEnabled || !Boolean.parseBoolean(saslEnabled)) {
                    args.add("--password");
                    args.add(this.config.getRootPassword());
                }
                if ((ret = (initProcess = this.exec(Initialize.class, args.toArray(new String[0]))).waitFor()) != 0) {
                    throw new RuntimeException("Initialize process returned " + ret + ". Check the logs in " + this.config.getLogDir() + " for errors.");
                }
                this.initialized = true;
            }
        }
        log.info("Starting MAC against instance {} and zookeeper(s) {}.", (Object)this.config.getInstanceName(), (Object)this.config.getZooKeepers());
        control.start(ServerType.TABLET_SERVER);
        int ret = 0;
        for (int i = 0; i < 5 && (ret = this.exec(Main.class, SetGoalState.class.getName(), MasterGoalState.NORMAL.toString()).waitFor()) != 0; ++i) {
            UtilWaitThread.sleep((long)1000L);
        }
        if (ret != 0) {
            throw new RuntimeException("Could not set master goal state, process returned " + ret + ". Check the logs in " + this.config.getLogDir() + " for errors.");
        }
        control.start(ServerType.MASTER);
        control.start(ServerType.GARBAGE_COLLECTOR);
        if (null == this.executor) {
            this.executor = Executors.newSingleThreadExecutor();
        }
    }

    private List<String> buildRemoteDebugParams(int port) {
        return Arrays.asList("-Xdebug", String.format("-Xrunjdwp:transport=dt_socket,server=y,suspend=n,address=%d", port));
    }

    public Set<Pair<ServerType, Integer>> getDebugPorts() {
        return this.debugPorts;
    }

    List<ProcessReference> references(Process ... procs) {
        ArrayList<ProcessReference> result = new ArrayList<ProcessReference>();
        for (Process proc : procs) {
            result.add(new ProcessReference(proc));
        }
        return result;
    }

    public Map<ServerType, Collection<ProcessReference>> getProcesses() {
        HashMap<ServerType, Collection<ProcessReference>> result = new HashMap<ServerType, Collection<ProcessReference>>();
        MiniAccumuloClusterControl control = this.getClusterControl();
        result.put(ServerType.MASTER, this.references(control.masterProcess));
        result.put(ServerType.TABLET_SERVER, this.references(control.tabletServerProcesses.toArray(new Process[0])));
        result.put(ServerType.ZOOKEEPER, this.references(control.zooKeeperProcess));
        if (null != control.gcProcess) {
            result.put(ServerType.GARBAGE_COLLECTOR, this.references(control.gcProcess));
        }
        return result;
    }

    public void killProcess(ServerType type, ProcessReference proc) throws ProcessNotFoundException, InterruptedException {
        this.getClusterControl().killProcess(type, proc);
    }

    @Override
    public String getInstanceName() {
        return this.config.getInstanceName();
    }

    @Override
    public String getZooKeepers() {
        return this.config.getZooKeepers();
    }

    @Override
    public synchronized void stop() throws IOException, InterruptedException {
        if (null == this.executor) {
            return;
        }
        for (LogWriter lw : this.logWriters) {
            lw.flush();
        }
        MiniAccumuloClusterControl control = this.getClusterControl();
        control.stop(ServerType.GARBAGE_COLLECTOR, null);
        control.stop(ServerType.MASTER, null);
        control.stop(ServerType.TABLET_SERVER, null);
        control.stop(ServerType.ZOOKEEPER, null);
        if (null != this.executor) {
            List<Runnable> tasksRemaining = this.executor.shutdownNow();
            if (!tasksRemaining.isEmpty()) {
                log.warn("Unexpectedly had " + tasksRemaining.size() + " task(s) remaining in threadpool for execution when being stopped");
            }
            this.executor = null;
        }
        if (this.config.useMiniDFS() && this.miniDFS != null) {
            this.miniDFS.shutdown();
        }
        for (Process p : this.cleanup) {
            p.destroy();
            p.waitFor();
        }
        this.miniDFS = null;
    }

    public MiniAccumuloConfigImpl getConfig() {
        return this.config;
    }

    @Override
    public Connector getConnector(String user, AuthenticationToken token) throws AccumuloException, AccumuloSecurityException {
        ZooKeeperInstance instance = new ZooKeeperInstance((org.apache.commons.configuration.Configuration)this.getClientConfig());
        return instance.getConnector(user, token);
    }

    @Override
    public ClientConfiguration getClientConfig() {
        return new ClientConfiguration(MiniAccumuloClusterImpl.getConfigs(this.config)).withInstance(this.getInstanceName()).withZkHosts(this.getZooKeepers());
    }

    private static List<AbstractConfiguration> getConfigs(MiniAccumuloConfigImpl config) {
        MapConfiguration cfg = new MapConfiguration(config.getSiteConfig());
        cfg.setListDelimiter('\u0000');
        return Collections.singletonList(cfg);
    }

    @Override
    public FileSystem getFileSystem() {
        try {
            return FileSystem.get((URI)new URI(this.dfsUri), (Configuration)new Configuration());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @VisibleForTesting
    protected void setShutdownExecutor(ExecutorService svc) {
        this.executor = svc;
    }

    @VisibleForTesting
    protected ExecutorService getShutdownExecutor() {
        return this.executor;
    }

    int stopProcessWithTimeout(final Process proc, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        FutureTask<Integer> future = new FutureTask<Integer>(new Callable<Integer>(){

            @Override
            public Integer call() throws InterruptedException {
                proc.destroy();
                return proc.waitFor();
            }
        });
        this.executor.execute(future);
        return future.get(timeout, unit);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public MasterMonitorInfo getMasterMonitorInfo() throws AccumuloException, AccumuloSecurityException {
        MasterClientService.Client client = null;
        MasterMonitorInfo stats = null;
        try {
            ZooKeeperInstance instance = new ZooKeeperInstance((org.apache.commons.configuration.Configuration)this.getClientConfig());
            ClientContext context = new ClientContext((Instance)instance, new Credentials("root", (AuthenticationToken)new PasswordToken((CharSequence)"unchecked")), this.getClientConfig());
            client = MasterClient.getConnectionWithRetry((ClientContext)context);
            stats = client.getMasterStats(Tracer.traceInfo(), context.rpcCreds());
            if (client == null) return stats;
        }
        catch (ThriftSecurityException exception) {
            try {
                throw new AccumuloSecurityException(exception);
                catch (TException exception2) {
                    throw new AccumuloException((Throwable)exception2);
                }
            }
            catch (Throwable throwable) {
                if (client == null) throw throwable;
                MasterClient.close(client);
                throw throwable;
            }
        }
        MasterClient.close((MasterClientService.Iface)client);
        return stats;
    }

    public synchronized MiniDFSCluster getMiniDfs() {
        return this.miniDFS;
    }

    @Override
    public MiniAccumuloClusterControl getClusterControl() {
        return this.clusterControl;
    }

    @Override
    public Path getTemporaryPath() {
        if (this.config.useMiniDFS()) {
            return new Path("/tmp/");
        }
        File tmp = new File(this.config.getDir(), "tmp");
        MiniAccumuloClusterImpl.mkdirs(tmp);
        return new Path(tmp.toString());
    }

    @Override
    public AccumuloConfiguration getSiteConfiguration() {
        return new ConfigurationCopy(Iterables.concat((Iterable)AccumuloConfiguration.getDefaultConfiguration(), this.config.getSiteConfig().entrySet()));
    }

    public static class LogWriter
    extends Daemon {
        private BufferedReader in;
        private BufferedWriter out;

        public LogWriter(InputStream stream, File logFile) throws IOException {
            this.in = new BufferedReader(new InputStreamReader(stream));
            this.out = new BufferedWriter(new FileWriter(logFile));
            SimpleTimer.getInstance(null).schedule(new Runnable(){

                @Override
                public void run() {
                    try {
                        LogWriter.this.flush();
                    }
                    catch (IOException e) {
                        log.error("Exception while attempting to flush.", (Throwable)e);
                    }
                }
            }, 1000L, 1000L);
        }

        public synchronized void flush() throws IOException {
            if (this.out != null) {
                this.out.flush();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                String line;
                while ((line = this.in.readLine()) != null) {
                    this.out.append(line);
                    this.out.append("\n");
                }
                LogWriter logWriter = this;
                synchronized (logWriter) {
                    this.out.close();
                    this.out = null;
                    this.in.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

