/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.cluster.standalone;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.accumulo.cluster.AccumuloCluster;
import org.apache.accumulo.cluster.ClusterUser;
import org.apache.accumulo.cluster.standalone.StandaloneClusterControl;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.ClientConfiguration;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.client.ZooKeeperInstance;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.ConfigurationCopy;
import org.apache.accumulo.core.master.thrift.MasterGoalState;
import org.apache.accumulo.core.util.CachedConfiguration;
import org.apache.accumulo.minicluster.ServerType;
import org.apache.commons.configuration.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandaloneAccumuloCluster
implements AccumuloCluster {
    private static final Logger log = LoggerFactory.getLogger(StandaloneAccumuloCluster.class);
    static final List<ServerType> ALL_SERVER_TYPES = Collections.unmodifiableList(Arrays.asList(ServerType.MASTER, ServerType.TABLET_SERVER, ServerType.TRACER, ServerType.GARBAGE_COLLECTOR, ServerType.MONITOR));
    private Instance instance;
    private ClientConfiguration clientConf;
    private String accumuloHome;
    private String clientAccumuloConfDir;
    private String serverAccumuloConfDir;
    private String hadoopConfDir;
    private Path tmp;
    private List<ClusterUser> users;
    private String serverUser;

    public StandaloneAccumuloCluster(ClientConfiguration clientConf, Path tmp, List<ClusterUser> users, String serverUser) {
        this((Instance)new ZooKeeperInstance((Configuration)clientConf), clientConf, tmp, users, serverUser);
    }

    public StandaloneAccumuloCluster(Instance instance, ClientConfiguration clientConf, Path tmp, List<ClusterUser> users, String serverUser) {
        this.instance = instance;
        this.clientConf = clientConf;
        this.tmp = tmp;
        this.users = users;
        this.serverUser = serverUser;
    }

    public String getAccumuloHome() {
        return this.accumuloHome;
    }

    public void setAccumuloHome(String accumuloHome) {
        this.accumuloHome = accumuloHome;
    }

    public String getClientAccumuloConfDir() {
        return this.clientAccumuloConfDir;
    }

    public void setClientAccumuloConfDir(String accumuloConfDir) {
        this.clientAccumuloConfDir = accumuloConfDir;
    }

    public String getServerAccumuloConfDir() {
        return this.serverAccumuloConfDir;
    }

    public void setServerAccumuloConfDir(String accumuloConfDir) {
        this.serverAccumuloConfDir = accumuloConfDir;
    }

    public String getHadoopConfDir() {
        if (null == this.hadoopConfDir) {
            this.hadoopConfDir = System.getenv("HADOOP_CONF_DIR");
        }
        if (null == this.hadoopConfDir) {
            throw new IllegalArgumentException("Cannot determine HADOOP_CONF_DIR for standalone cluster");
        }
        return this.hadoopConfDir;
    }

    public void setHadoopConfDir(String hadoopConfDir) {
        this.hadoopConfDir = hadoopConfDir;
    }

    @Override
    public String getInstanceName() {
        return this.instance.getInstanceName();
    }

    @Override
    public String getZooKeepers() {
        return this.instance.getZooKeepers();
    }

    @Override
    public Connector getConnector(String user, AuthenticationToken token) throws AccumuloException, AccumuloSecurityException {
        return this.instance.getConnector(user, token);
    }

    @Override
    public ClientConfiguration getClientConfig() {
        return this.clientConf;
    }

    @Override
    public StandaloneClusterControl getClusterControl() {
        return new StandaloneClusterControl(this.serverUser, null == this.accumuloHome ? System.getenv("ACCUMULO_HOME") : this.accumuloHome, null == this.clientAccumuloConfDir ? System.getenv("ACCUMULO_CONF_DIR") : this.clientAccumuloConfDir, null == this.serverAccumuloConfDir ? System.getenv("ACCUMULO_CONF_DIR") : this.serverAccumuloConfDir);
    }

    @Override
    public void start() throws IOException {
        StandaloneClusterControl control = this.getClusterControl();
        control.setGoalState(MasterGoalState.NORMAL.toString());
        for (ServerType type : ALL_SERVER_TYPES) {
            control.startAllServers(type);
        }
    }

    @Override
    public void stop() throws IOException {
        StandaloneClusterControl control = this.getClusterControl();
        for (ServerType type : ALL_SERVER_TYPES) {
            control.stopAllServers(type);
        }
    }

    public org.apache.hadoop.conf.Configuration getHadoopConfiguration() {
        String confDir = this.getHadoopConfDir();
        org.apache.hadoop.conf.Configuration conf = CachedConfiguration.getInstance();
        conf.addResource(new Path(confDir, "core-site.xml"));
        conf.addResource(new Path(confDir, "hdfs-site.xml"));
        return conf;
    }

    @Override
    public FileSystem getFileSystem() throws IOException {
        org.apache.hadoop.conf.Configuration conf = this.getHadoopConfiguration();
        return FileSystem.get((org.apache.hadoop.conf.Configuration)conf);
    }

    @Override
    public Path getTemporaryPath() {
        return this.tmp;
    }

    public ClusterUser getUser(int offset) {
        Preconditions.checkArgument((offset >= 0 && offset < this.users.size() ? 1 : 0) != 0, (Object)("Invalid offset, should be non-negative and less than " + this.users.size()));
        return this.users.get(offset);
    }

    @Override
    public AccumuloConfiguration getSiteConfiguration() {
        org.apache.hadoop.conf.Configuration conf = new org.apache.hadoop.conf.Configuration(false);
        Path accumuloSite = new Path(this.serverAccumuloConfDir, "accumulo-site.xml");
        conf.addResource(accumuloSite);
        return new ConfigurationCopy(Iterables.concat((Iterable)AccumuloConfiguration.getDefaultConfiguration(), (Iterable)conf));
    }
}

