/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.monitor.util;

import java.util.ArrayList;
import java.util.Collections;
import javax.servlet.http.HttpServletRequest;
import org.apache.accumulo.monitor.servlets.BasicServlet;
import org.apache.accumulo.monitor.util.TableColumn;
import org.apache.accumulo.monitor.util.TableRow;
import org.apache.accumulo.monitor.util.celltypes.CellType;
import org.apache.accumulo.monitor.util.celltypes.StringType;

public class Table {
    private String table;
    private String caption;
    private String captionclass;
    private String subcaption;
    private ArrayList<TableColumn<?>> columns;
    private ArrayList<TableRow> rows;
    private boolean hasBegunAddingRows = false;

    public Table(String tableName, String caption) {
        this(tableName, caption, null);
    }

    public Table(String tableName, String caption, String captionClass) {
        this.table = tableName;
        this.caption = caption;
        this.captionclass = captionClass;
        this.subcaption = null;
        this.columns = new ArrayList();
        this.rows = new ArrayList();
    }

    public synchronized void setSubCaption(String subcaption) {
        this.subcaption = subcaption;
    }

    public synchronized <T> void addColumn(TableColumn<T> column) {
        if (this.hasBegunAddingRows) {
            throw new IllegalStateException("Cannot add more columns newServer rows have been added");
        }
        this.columns.add(column);
    }

    private synchronized <T> void addColumn(String title, CellType<T> type, String legend, boolean sortable) {
        if (type == null) {
            type = new StringType();
        }
        type.setSortable(sortable);
        this.addColumn(new TableColumn<T>(title, type, legend));
    }

    public synchronized <T> void addUnsortableColumn(String title, CellType<T> type, String legend) {
        this.addColumn(title, type, legend, false);
    }

    public synchronized <T> void addSortableColumn(String title, CellType<T> type, String legend) {
        this.addColumn(title, type, legend, true);
    }

    public synchronized void addUnsortableColumn(String title) {
        this.addUnsortableColumn(title, null, null);
    }

    public synchronized void addSortableColumn(String title) {
        this.addSortableColumn(title, null, null);
    }

    public synchronized TableRow prepareRow() {
        this.hasBegunAddingRows = true;
        return new TableRow(this.columns.size());
    }

    public synchronized void addRow(TableRow row) {
        this.hasBegunAddingRows = true;
        if (this.columns.size() != row.size()) {
            throw new IllegalStateException("Row must be the same size as the columns");
        }
        this.rows.add(row);
    }

    public synchronized void addRow(Object ... cells) {
        TableRow row = this.prepareRow();
        if (cells.length != this.columns.size()) {
            throw new IllegalArgumentException("Argument length not equal to the number of columns");
        }
        for (Object cell : cells) {
            row.add(cell);
        }
        this.addRow(row);
    }

    public synchronized void generate(HttpServletRequest req, StringBuilder sb) {
        String sortColStr;
        String page = req.getRequestURI();
        if (this.columns.isEmpty()) {
            throw new IllegalStateException("No columns in table");
        }
        for (TableRow row : this.rows) {
            if (row.size() == this.columns.size()) continue;
            throw new RuntimeException("Each row must have the same number of columns");
        }
        boolean sortAscending = !"false".equals(BasicServlet.getCookieValue(req, "tableSort." + BasicServlet.encode(page) + "." + BasicServlet.encode(this.table) + ".sortAsc"));
        int sortCol = -1;
        int numLegends = 0;
        for (int i = 0; i < this.columns.size(); ++i) {
            TableColumn<?> col = this.columns.get(i);
            if (sortCol < 0 && col.getCellType().isSortable()) {
                sortCol = i;
            }
            if (col.getLegend() == null || col.getLegend().isEmpty()) continue;
            ++numLegends;
        }
        if (sortCol >= 0 && (sortColStr = BasicServlet.getCookieValue(req, "tableSort." + BasicServlet.encode(page) + "." + BasicServlet.encode(this.table) + ".sortCol")) != null) {
            try {
                int col = Integer.parseInt(sortColStr);
                if (col >= 0 && sortCol < this.columns.size() && this.columns.get(col).getCellType().isSortable()) {
                    sortCol = col;
                }
            }
            catch (NumberFormatException col) {
                // empty catch block
            }
        }
        boolean showLegend = false;
        if (numLegends > 0) {
            String showStr = BasicServlet.getCookieValue(req, "tableLegend." + BasicServlet.encode(page) + "." + BasicServlet.encode(this.table) + ".show");
            showLegend = showStr != null && Boolean.parseBoolean(showStr);
        }
        sb.append("<div>\n");
        sb.append("<a name='").append(this.table).append("'>&nbsp;</a>\n");
        sb.append("<table id='").append(this.table).append("' class='sortable'>\n");
        sb.append("<caption");
        if (this.captionclass != null && !this.captionclass.isEmpty()) {
            sb.append(" class='").append(this.captionclass).append("'");
        }
        sb.append(">\n");
        if (this.caption != null && !this.caption.isEmpty()) {
            sb.append("<span class='table-caption'>").append(this.caption).append("</span><br />\n");
        }
        if (this.subcaption != null && !this.subcaption.isEmpty()) {
            sb.append("<span class='table-subcaption'>").append(this.subcaption).append("</span><br />\n");
        }
        String redir = BasicServlet.currentPage(req);
        if (numLegends > 0) {
            String legendUrl = String.format("/op?action=toggleLegend&redir=%s&page=%s&table=%s&show=%s", redir, page, this.table, !showLegend);
            sb.append("<a href='").append(legendUrl).append("'>").append(showLegend ? "Hide" : "Show").append("&nbsp;Legend</a>\n");
            if (showLegend) {
                sb.append("<div class='left show'><dl>\n");
            }
        }
        for (int i = 0; i < this.columns.size(); ++i) {
            TableColumn<?> col = this.columns.get(i);
            String string = col.getTitle();
            if (this.rows.size() > 1 && col.getCellType().isSortable()) {
                Object[] objectArray = new Object[5];
                objectArray[0] = redir;
                objectArray[1] = page;
                objectArray[2] = this.table;
                Object object = objectArray[3] = sortCol == i ? "asc" : "col";
                objectArray[4] = sortCol == i ? (Comparable<Boolean>)Boolean.valueOf(!sortAscending) : (Comparable<Boolean>)Integer.valueOf(i);
                String url = String.format("/op?action=sortTable&redir=%s&page=%s&table=%s&%s=%s", objectArray);
                String img = "";
                if (sortCol == i) {
                    img = String.format("&nbsp;<img width='10px' height='10px' src='/web/%s.gif' alt='%s' />", sortAscending ? "up" : "down", !sortAscending ? "^" : "v");
                }
                col.setTitle(String.format("<a href='%s'>%s%s</a>", url, string, img));
            }
            String legend = col.getLegend();
            if (!showLegend || legend == null || legend.isEmpty()) continue;
            sb.append("<dt class='smalltext'><b>").append(string.replace("<br />", "&nbsp;")).append("</b><dd>").append(legend).append("</dd></dt>\n");
        }
        if (showLegend && numLegends > 0) {
            sb.append("</dl></div>\n");
        }
        sb.append("</caption>\n");
        sb.append("<tr>");
        boolean first = true;
        for (TableColumn tableColumn : this.columns) {
            String cellValue = tableColumn.getTitle() == null ? "" : String.valueOf(tableColumn.getTitle()).trim();
            sb.append("<th").append(first ? " class='firstcell'" : "").append(">").append(cellValue.isEmpty() ? "-" : cellValue).append("</th>");
            first = false;
        }
        sb.append("</tr>\n");
        if (this.rows.size() > 1 && sortCol > -1) {
            Collections.sort(this.rows, TableRow.getComparator(sortCol, this.columns.get(sortCol).getCellType()));
            if (!sortAscending) {
                Collections.reverse(this.rows);
            }
        }
        boolean highlight = true;
        for (TableRow row : this.rows) {
            for (int i = 0; i < row.size(); ++i) {
                try {
                    row.set(i, this.columns.get(i).getCellType().format(row.get(i)));
                    continue;
                }
                catch (Exception ex) {
                    throw new RuntimeException("Unable to process column " + i, ex);
                }
            }
            Table.row(sb, highlight, this.columns, row);
            highlight = !highlight;
        }
        if (this.rows.isEmpty()) {
            sb.append("<tr><td class='center' colspan='").append(this.columns.size()).append("'><i>Empty</i></td></tr>\n");
        }
        sb.append("</table>\n</div>\n\n");
    }

    private static void row(StringBuilder sb, boolean highlight, ArrayList<TableColumn<?>> columns, TableRow row) {
        sb.append(highlight ? "<tr class='highlight'>" : "<tr>");
        boolean first = true;
        for (int i = 0; i < row.size(); ++i) {
            String cellValue = String.valueOf(row.get(i)).trim();
            if (cellValue.isEmpty() || cellValue.equals(String.valueOf(null))) {
                cellValue = "-";
            }
            sb.append("<td class='").append(first ? "firstcell" : "");
            if (columns.get(i).getCellType().alignment() != null) {
                sb.append(first ? " " : "").append(columns.get(i).getCellType().alignment());
            }
            sb.append("'>").append(cellValue).append("</td>");
            first = false;
        }
        sb.append("</tr>\n");
    }
}

