/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.monitor;

import com.google.common.net.HostAndPort;
import com.google.common.util.concurrent.Uninterruptibles;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Objects;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.conf.SiteConfiguration;
import org.apache.accumulo.core.rpc.TTimeoutTransport;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZooKeeperStatus
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(ZooKeeperStatus.class);
    private volatile boolean stop = false;
    private static SortedSet<ZooKeeperState> status = new TreeSet<ZooKeeperState>();

    public static Collection<ZooKeeperState> getZooKeeperStatus() {
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (!this.stop) {
            String[] zookeepers;
            TreeSet<ZooKeeperState> update = new TreeSet<ZooKeeperState>();
            for (String keeper : zookeepers = SiteConfiguration.getInstance().get(Property.INSTANCE_ZK_HOST).split(",")) {
                int clients = 0;
                String mode = "unknown";
                String[] parts = keeper.split(":");
                TTransport transport = null;
                try {
                    HostAndPort addr = parts.length > 1 ? HostAndPort.fromParts((String)parts[0], (int)Integer.parseInt(parts[1])) : HostAndPort.fromParts((String)parts[0], (int)2181);
                    transport = TTimeoutTransport.create((HostAndPort)addr, (long)10000L);
                    transport.write("stat\n".getBytes(StandardCharsets.UTF_8), 0, 5);
                    StringBuilder response = new StringBuilder();
                    try {
                        transport.flush();
                        byte[] buffer = new byte[102400];
                        int n = 0;
                        while ((n = transport.read(buffer, 0, buffer.length)) > 0) {
                            response.append(new String(buffer, 0, n, StandardCharsets.UTF_8));
                        }
                    }
                    catch (TTransportException buffer) {
                        // empty catch block
                    }
                    for (String line : response.toString().split("\n")) {
                        if (line.startsWith(" ")) {
                            ++clients;
                        }
                        if (!line.startsWith("Mode")) continue;
                        mode = line.split(":")[1];
                    }
                    update.add(new ZooKeeperState(keeper, mode, clients));
                }
                catch (Exception ex) {
                    log.info("Exception talking to zookeeper " + keeper, (Throwable)ex);
                    update.add(new ZooKeeperState(keeper, "Down", -1));
                }
                finally {
                    if (transport != null) {
                        try {
                            transport.close();
                        }
                        catch (Exception ex) {
                            log.error("Exception", (Throwable)ex);
                        }
                    }
                }
            }
            status = update;
            Uninterruptibles.sleepUninterruptibly((long)5L, (TimeUnit)TimeUnit.SECONDS);
        }
    }

    public static class ZooKeeperState
    implements Comparable<ZooKeeperState> {
        public final String keeper;
        public final String mode;
        public final int clients;

        public ZooKeeperState(String keeper, String mode, int clients) {
            this.keeper = keeper;
            this.mode = mode;
            this.clients = clients;
        }

        public int hashCode() {
            return Objects.hashCode(this.keeper);
        }

        public boolean equals(Object obj) {
            return obj == this || obj != null && obj instanceof ZooKeeperState && 0 == this.compareTo((ZooKeeperState)obj);
        }

        @Override
        public int compareTo(ZooKeeperState other) {
            if (this == other) {
                return 0;
            }
            if (other == null) {
                return 1;
            }
            if (this.keeper == other.keeper) {
                return 0;
            }
            if (null == this.keeper) {
                return -1;
            }
            if (null == other.keeper) {
                return 1;
            }
            return this.keeper.compareTo(other.keeper);
        }
    }
}

