/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.monitor.servlets;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.accumulo.core.master.thrift.MasterMonitorInfo;
import org.apache.accumulo.core.util.Duration;
import org.apache.accumulo.core.util.Pair;
import org.apache.accumulo.monitor.Monitor;
import org.apache.accumulo.monitor.ZooKeeperStatus;
import org.apache.accumulo.monitor.servlets.BasicServlet;
import org.apache.accumulo.monitor.util.celltypes.NumberType;

public class DefaultServlet
extends BasicServlet {
    private static final long serialVersionUID = 1L;
    public static final int GRAPH_WIDTH = 450;
    public static final int GRAPH_HEIGHT = 150;

    @Override
    protected String getTitle(HttpServletRequest req) {
        return "Accumulo Overview";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getResource(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        try {
            String path = req.getRequestURI();
            if (path.endsWith(".jpg")) {
                resp.setContentType("image/jpeg");
            }
            if (path.endsWith(".html")) {
                resp.setContentType("text/html");
            }
            path = path.substring(1);
            ServletOutputStream out = resp.getOutputStream();
            try (InputStream data = BasicServlet.class.getClassLoader().getResourceAsStream(path);){
                if (data != null) {
                    int n;
                    byte[] buffer = new byte[1024];
                    while ((n = data.read(buffer)) > 0) {
                        out.write(buffer, 0, n);
                    }
                } else {
                    out.write(("could not get resource " + path + "").getBytes(StandardCharsets.UTF_8));
                }
            }
        }
        catch (Throwable t) {
            log.error((Object)t, t);
            throw new IOException(t);
        }
    }

    @Override
    public void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (req.getRequestURI().startsWith("/web")) {
            this.getResource(req, resp);
        } else if (req.getRequestURI().startsWith("/monitor")) {
            resp.sendRedirect("/master");
        } else if (req.getRequestURI().startsWith("/errors")) {
            resp.sendRedirect("/problems");
        } else {
            super.doGet(req, resp);
        }
    }

    private static void plotData(StringBuilder sb, String title, List data, boolean points) {
        DefaultServlet.plotData(sb, title, points, new ArrayList<String>(), data);
    }

    private static void plotData(StringBuilder sb, String title, boolean points, List<String> labels, List ... series) {
        sb.append("<div class=\"plotHeading\">");
        sb.append(title);
        sb.append("</div>");
        sb.append("</br>");
        String id = "c" + title.hashCode();
        sb.append("<div id=\"" + id + "\" style=\"width:" + 450 + "px;height:" + 150 + "px;\"></div>\n");
        sb.append("<script type=\"text/javascript\">\n");
        sb.append("$(function () {\n");
        for (int i = 0; i < series.length; ++i) {
            List data = series[i];
            sb.append("    var d" + i + " = [");
            String sep = "";
            for (Pair point : data) {
                if (point.getSecond() == null) continue;
                String y = point.getSecond() instanceof Double ? String.format("%1.2f", point.getSecond()) : ((Number)point.getSecond()).toString();
                sb.append(sep);
                sep = ",";
                sb.append("[" + DefaultServlet.utc2local((Long)point.getFirst()) + "," + y + "]");
            }
            sb.append("    ];\n");
        }
        String opts = "lines: { show: true }";
        if (points) {
            opts = "points: { show: true, radius: 1 }";
        }
        sb.append("    $.plot($(\"#" + id + "\"),");
        String sep = "";
        String[] colors = new String[]{"red", "blue", "green", "black"};
        sb.append("[");
        for (int i = 0; i < series.length; ++i) {
            sb.append(sep);
            sep = ",";
            sb.append("{ ");
            if (labels.size() > 0) {
                sb.append("label: \"" + labels.get(i) + "\", ");
            }
            sb.append("data: d" + i + ", " + opts + ", color:\"" + colors[i] + "\" }");
        }
        sb.append("], ");
        sb.append("{yaxis:{}, xaxis:{mode:\"time\",minTickSize: [1, \"minute\"],timeformat: \"%H:%M<br />" + DefaultServlet.getShortTZName() + "\", ticks:3}});");
        sb.append("   });\n");
        sb.append("</script>\n");
    }

    private static String getShortTZName() {
        TimeZone tz = TimeZone.getDefault();
        return tz.getDisplayName(tz.inDaylightTime(new Date()), 0);
    }

    private static Long utc2local(Long utcMillis) {
        Calendar currentCalendar = Calendar.getInstance();
        currentCalendar.setTimeInMillis(utcMillis + (long)currentCalendar.getTimeZone().getOffset(utcMillis));
        return currentCalendar.getTime().getTime();
    }

    @Override
    protected void pageBody(HttpServletRequest req, HttpServletResponse resp, StringBuilder sb) throws IOException {
        sb.append("<table class='noborder'>\n");
        sb.append("<tr>\n");
        sb.append("<td class='noborder'>\n");
        this.doAccumuloTable(sb);
        sb.append("</td>\n");
        sb.append("<td class='noborder'>\n");
        this.doZooKeeperTable(sb);
        sb.append("</td>\n");
        sb.append("</tr></table>\n");
        sb.append("<br />\n");
        sb.append("<p><table class=\"noborder\">\n");
        sb.append("<tr><td>\n");
        DefaultServlet.plotData(sb, "Ingest (Entries/s)", Monitor.getIngestRateOverTime(), false);
        sb.append("</td><td>\n");
        DefaultServlet.plotData(sb, "Scan (Entries/s)", false, Arrays.asList("Read", "Returned"), Monitor.getScanRateOverTime(), Monitor.getQueryRateOverTime());
        sb.append("</td></tr>\n");
        sb.append("<tr><td>\n");
        DefaultServlet.plotData(sb, "Ingest (MB/s)", Monitor.getIngestByteRateOverTime(), false);
        sb.append("</td><td>\n");
        DefaultServlet.plotData(sb, "Scan (MB/s)", Monitor.getQueryByteRateOverTime(), false);
        sb.append("</td></tr>\n");
        sb.append("<tr><td>\n");
        DefaultServlet.plotData(sb, "Load Average", Monitor.getLoadOverTime(), false);
        sb.append("</td><td>\n");
        DefaultServlet.plotData(sb, "Seeks", Monitor.getLookupsOverTime(), false);
        sb.append("</td></tr>\n");
        sb.append("<tr><td>\n");
        DefaultServlet.plotData(sb, "Minor Compactions", Monitor.getMinorCompactionsOverTime(), false);
        sb.append("</td><td>\n");
        DefaultServlet.plotData(sb, "Major Compactions", Monitor.getMajorCompactionsOverTime(), false);
        sb.append("</td></tr>\n");
        sb.append("<tr><td>\n");
        DefaultServlet.plotData(sb, "Index Cache Hit Rate", Monitor.getIndexCacheHitRateOverTime(), true);
        sb.append("</td><td>\n");
        DefaultServlet.plotData(sb, "Data Cache Hit Rate", Monitor.getDataCacheHitRateOverTime(), true);
        sb.append("</td></tr>\n");
        sb.append("</table>\n");
    }

    private void doAccumuloTable(StringBuilder sb) throws IOException {
        MasterMonitorInfo info = Monitor.getMmi();
        sb.append("<table>\n");
        sb.append("<tr><th colspan='2'><a href='/master'>Accumulo Master</a></th></tr>\n");
        if (info == null) {
            sb.append("<tr><td colspan='2'><span class='error'>Master is Down</span></td></tr>\n");
        } else {
            try {
                boolean highlight = false;
                highlight = !highlight;
                DefaultServlet.tableRow(sb, highlight, "<a href='/tables'>Tables</a>", NumberType.commas(Monitor.getTotalTables()));
                highlight = !highlight;
                DefaultServlet.tableRow(sb, highlight, "<a href='/tservers'>Tablet&nbsp;Servers</a>", NumberType.commas(info.tServerInfo.size(), 1L, Long.MAX_VALUE));
                highlight = !highlight;
                DefaultServlet.tableRow(sb, highlight, "<a href='/tservers'>Dead&nbsp;Tablet&nbsp;Servers</a>", NumberType.commas(info.deadTabletServers.size(), 0L, 0L));
                highlight = !highlight;
                DefaultServlet.tableRow(sb, highlight, "Tablets", NumberType.commas(Monitor.getTotalTabletCount(), 1L, Long.MAX_VALUE));
                highlight = !highlight;
                DefaultServlet.tableRow(sb, highlight, "Entries", NumberType.commas(Monitor.getTotalEntries()));
                highlight = !highlight;
                DefaultServlet.tableRow(sb, highlight, "Lookups", NumberType.commas(Monitor.getTotalLookups()));
                highlight = !highlight;
                DefaultServlet.tableRow(sb, highlight, "Uptime", Duration.format((long)(System.currentTimeMillis() - Monitor.getStartTime())));
            }
            catch (Exception e) {
                log.debug((Object)e, (Throwable)e);
            }
        }
        sb.append("</table>\n");
    }

    private void doZooKeeperTable(StringBuilder sb) throws IOException {
        sb.append("<table>\n");
        sb.append("<tr><th colspan='3'>Zookeeper</th></tr>\n");
        sb.append("<tr><th>Server</th><th>Mode</th><th>Clients</th></tr>\n");
        boolean highlight = false;
        for (ZooKeeperStatus.ZooKeeperState k : ZooKeeperStatus.getZooKeeperStatus()) {
            if (k.clients >= 0) {
                highlight = !highlight;
                DefaultServlet.tableRow(sb, highlight, k.keeper, k.mode, k.clients);
                continue;
            }
            DefaultServlet.tableRow(sb, false, k.keeper, "<span class='error'>Down</span>", "");
        }
        sb.append("</table>\n");
    }

    public static void tableRow(StringBuilder sb, boolean highlight, Object ... cells) {
        sb.append(highlight ? "<tr class='highlight'>" : "<tr>");
        for (int i = 0; i < cells.length; ++i) {
            Object cell = cells[i];
            String cellValue = cell == null ? "" : String.valueOf(cell).trim();
            sb.append("<td class='").append(i < cells.length - 1 ? "left" : "right").append("'>").append(cellValue.isEmpty() ? "-" : cellValue).append("</td>");
        }
        sb.append("</tr>\n");
    }
}

