/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.monitor.util;

import java.util.ArrayList;
import java.util.Comparator;

public class TableRow {
    private int size;
    private ArrayList<Object> row;

    TableRow(int size) {
        this.size = size;
        this.row = new ArrayList(size);
    }

    public boolean add(Object obj) {
        if (this.row.size() == this.size) {
            throw new IllegalStateException("Row is full.");
        }
        return this.row.add(obj);
    }

    Object get(int index) {
        return this.row.get(index);
    }

    int size() {
        return this.row.size();
    }

    Object set(int i, Object value) {
        return this.row.set(i, value);
    }

    public static <T> Comparator<TableRow> getComparator(int index, Comparator<T> comp) {
        return new TableRowComparator<T>(index, comp);
    }

    private static class TableRowComparator<T>
    implements Comparator<TableRow> {
        private int index;
        private Comparator<T> comp;

        public TableRowComparator(int index, Comparator<T> comp) {
            this.index = index;
            this.comp = comp;
        }

        @Override
        public int compare(TableRow o1, TableRow o2) {
            return this.comp.compare(o1.get(this.index), o2.get(this.index));
        }
    }
}

