/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.monitor.util.celltypes;

import java.util.Map;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.client.impl.Tables;
import org.apache.accumulo.monitor.servlets.BasicServlet;
import org.apache.accumulo.monitor.util.celltypes.CellType;
import org.apache.accumulo.server.client.HdfsZooInstance;

public class TableLinkType
extends CellType<String> {
    private static final long serialVersionUID = 1L;
    private Map<String, String> tidToNameMap = Tables.getIdToNameMap((Instance)HdfsZooInstance.getInstance());

    @Override
    public String format(Object obj) {
        if (obj == null) {
            return "-";
        }
        String tableId = (String)obj;
        return String.format("<a href='/tables?t=%s'>%s</a>", BasicServlet.encode(tableId), this.displayName(tableId));
    }

    private String displayName(String tableId) {
        if (tableId == null) {
            return "-";
        }
        return Tables.getPrintableTableNameFromId(this.tidToNameMap, (String)tableId);
    }

    @Override
    public int compare(String o1, String o2) {
        return this.displayName(o1).compareTo(this.displayName(o2));
    }

    @Override
    public String alignment() {
        return "left";
    }
}

