/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.monitor;

import javax.servlet.http.HttpServlet;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.monitor.Monitor;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jetty.security.ConstraintMapping;
import org.eclipse.jetty.security.ConstraintSecurityHandler;
import org.eclipse.jetty.security.SecurityHandler;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.session.SessionHandler;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.util.security.Constraint;
import org.eclipse.jetty.util.ssl.SslContextFactory;

public class EmbeddedWebServer {
    private static String EMPTY = "";
    Server server = new Server();
    ServerConnector connector = null;
    ServletContextHandler handler;
    boolean usingSsl;

    public EmbeddedWebServer() {
        this("0.0.0.0", 0);
    }

    public EmbeddedWebServer(String host, int port) {
        AccumuloConfiguration conf = Monitor.getContext().getConfiguration();
        if (EMPTY.equals(conf.get(Property.MONITOR_SSL_KEYSTORE)) || EMPTY.equals(conf.get(Property.MONITOR_SSL_KEYSTOREPASS)) || EMPTY.equals(conf.get(Property.MONITOR_SSL_TRUSTSTORE)) || EMPTY.equals(conf.get(Property.MONITOR_SSL_TRUSTSTOREPASS))) {
            this.connector = new ServerConnector(this.server, new ConnectionFactory[]{new HttpConnectionFactory()});
            this.usingSsl = false;
        } else {
            String includeProtocols;
            SslContextFactory sslContextFactory = new SslContextFactory();
            sslContextFactory.setKeyStorePath(conf.get(Property.MONITOR_SSL_KEYSTORE));
            sslContextFactory.setKeyStorePassword(conf.get(Property.MONITOR_SSL_KEYSTOREPASS));
            sslContextFactory.setKeyStoreType(conf.get(Property.MONITOR_SSL_KEYSTORETYPE));
            sslContextFactory.setTrustStorePath(conf.get(Property.MONITOR_SSL_TRUSTSTORE));
            sslContextFactory.setTrustStorePassword(conf.get(Property.MONITOR_SSL_TRUSTSTOREPASS));
            sslContextFactory.setTrustStoreType(conf.get(Property.MONITOR_SSL_TRUSTSTORETYPE));
            String includedCiphers = conf.get(Property.MONITOR_SSL_INCLUDE_CIPHERS);
            if (!Property.MONITOR_SSL_INCLUDE_CIPHERS.getDefaultValue().equals(includedCiphers)) {
                sslContextFactory.setIncludeCipherSuites(StringUtils.split((String)includedCiphers, (char)','));
            }
            String excludedCiphers = conf.get(Property.MONITOR_SSL_EXCLUDE_CIPHERS);
            if (!Property.MONITOR_SSL_EXCLUDE_CIPHERS.getDefaultValue().equals(excludedCiphers)) {
                sslContextFactory.setExcludeCipherSuites(StringUtils.split((String)excludedCiphers, (char)','));
            }
            if (null != (includeProtocols = conf.get(Property.MONITOR_SSL_INCLUDE_PROTOCOLS)) && !includeProtocols.isEmpty()) {
                sslContextFactory.setIncludeProtocols(StringUtils.split((String)includeProtocols, (char)','));
            }
            this.connector = new ServerConnector(this.server, sslContextFactory);
            this.usingSsl = true;
        }
        this.connector.setHost(host);
        this.connector.setPort(port);
        this.handler = new ServletContextHandler((HandlerContainer)this.server, "/", new SessionHandler(), (SecurityHandler)new ConstraintSecurityHandler(), null, null);
        this.handler.getSessionHandler().getSessionManager().getSessionCookieConfig().setHttpOnly(true);
        this.disableTrace("/");
    }

    public void addServlet(Class<? extends HttpServlet> klass, String where) {
        this.handler.addServlet(klass, where);
    }

    private void disableTrace(String where) {
        Constraint constraint = new Constraint();
        constraint.setName("Disable TRACE");
        constraint.setAuthenticate(true);
        ConstraintMapping mapping = new ConstraintMapping();
        mapping.setConstraint(constraint);
        mapping.setMethod("TRACE");
        mapping.setPathSpec(where);
        ConstraintSecurityHandler security = (ConstraintSecurityHandler)this.handler.getSecurityHandler();
        security.addConstraintMapping(mapping);
    }

    public int getPort() {
        return this.connector.getLocalPort();
    }

    public void start() {
        try {
            this.server.addConnector((Connector)this.connector);
            this.server.setHandler((Handler)this.handler);
            this.server.start();
        }
        catch (Exception e) {
            this.stop();
            throw new RuntimeException(e);
        }
    }

    public void stop() {
        try {
            this.server.stop();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isUsingSsl() {
        return this.usingSsl;
    }

    public boolean isRunning() {
        return this.server.isRunning();
    }
}

