/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.monitor.util.celltypes;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.apache.accumulo.monitor.util.celltypes.CellType;

public class DateTimeType
extends CellType<Long> {
    private static final long serialVersionUID = 1L;
    private SimpleDateFormat simple;
    private int dateFormat;
    private int timeFormat;

    public DateTimeType(int dateFormat, int timeFormat) {
        this.dateFormat = dateFormat;
        this.timeFormat = timeFormat;
        this.simple = null;
    }

    public DateTimeType(SimpleDateFormat fmt) {
        this.simple = fmt;
    }

    @Override
    public String format(Object obj) {
        if (obj == null) {
            return "-";
        }
        Long millis = (Long)obj;
        if (millis == 0L) {
            return "-";
        }
        if (this.simple != null) {
            return this.simple.format(new Date(millis)).replace(" ", "&nbsp;");
        }
        return DateFormat.getDateTimeInstance(this.dateFormat, this.timeFormat, Locale.getDefault()).format(new Date(millis)).replace(" ", "&nbsp;");
    }

    @Override
    public int compare(Long o1, Long o2) {
        if (o1 == null && o2 == null) {
            return 0;
        }
        if (o1 == null) {
            return -1;
        }
        return o1.compareTo(o2);
    }

    @Override
    public String alignment() {
        return "right";
    }
}

