/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.monitor.servlets;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.client.impl.Tables;
import org.apache.accumulo.monitor.Monitor;
import org.apache.accumulo.monitor.servlets.BasicServlet;
import org.apache.accumulo.monitor.util.Table;
import org.apache.accumulo.monitor.util.TableRow;
import org.apache.accumulo.monitor.util.celltypes.CellType;
import org.apache.accumulo.monitor.util.celltypes.DateTimeType;
import org.apache.accumulo.monitor.util.celltypes.NumberType;
import org.apache.accumulo.monitor.util.celltypes.StringType;
import org.apache.accumulo.server.AccumuloServerContext;
import org.apache.accumulo.server.problems.ProblemReport;
import org.apache.accumulo.server.problems.ProblemReports;
import org.apache.accumulo.server.problems.ProblemType;

public class ProblemServlet
extends BasicServlet {
    private static final long serialVersionUID = 1L;

    @Override
    protected String getTitle(HttpServletRequest req) {
        return "Per-Table Problem Report";
    }

    @Override
    protected void pageBody(HttpServletRequest req, HttpServletResponse resp, StringBuilder sb) {
        Map tidToNameMap = Tables.getIdToNameMap((Instance)Monitor.getContext().getInstance());
        ProblemServlet.doProblemSummary(req, sb, tidToNameMap);
        ProblemServlet.doProblemDetails(req, sb, req.getParameter("table"), tidToNameMap);
    }

    /*
     * WARNING - void declaration
     */
    private static void doProblemSummary(HttpServletRequest req, StringBuilder sb, Map<String, String> tidToNameMap) {
        if (Monitor.getProblemSummary().isEmpty() && Monitor.getProblemException() == null) {
            return;
        }
        Table problemSummary = new Table("problemSummary", "Problem&nbsp;Summary", "error");
        problemSummary.addSortableColumn("Table", new TableProblemLinkType(tidToNameMap), null);
        for (ProblemType type : ProblemType.values()) {
            problemSummary.addSortableColumn(type.name(), new NumberType(), null);
        }
        problemSummary.addUnsortableColumn("Operations", new ClearTableProblemsLinkType(req, tidToNameMap), null);
        if (Monitor.getProblemException() != null) {
            void var5_7;
            StringBuilder cell = new StringBuilder();
            cell.append("<b>Failed to obtain problem reports</b> : " + Monitor.getProblemException().getMessage());
            Throwable throwable = Monitor.getProblemException().getCause();
            while (var5_7 != null) {
                if (var5_7.getMessage() != null) {
                    cell.append("<br />\n caused by : " + var5_7.getMessage());
                }
                Throwable throwable2 = var5_7.getCause();
            }
            problemSummary.setSubCaption(cell.toString());
        } else {
            for (Map.Entry entry : Monitor.getProblemSummary().entrySet()) {
                TableRow row = problemSummary.prepareRow();
                row.add(entry.getKey());
                for (ProblemType pt : ProblemType.values()) {
                    Integer pcount = (Integer)((Map)entry.getValue()).get(pt);
                    row.add(pcount == null ? Integer.valueOf(0) : pcount);
                }
                row.add(entry.getKey());
                problemSummary.addRow(row);
            }
        }
        problemSummary.generate(req, sb);
    }

    private static void doProblemDetails(HttpServletRequest req, StringBuilder sb, String tableId, Map<String, String> tidToNameMap) {
        Iterator iter;
        if (Monitor.getProblemException() != null) {
            return;
        }
        ArrayList problemReports = new ArrayList();
        Iterator iterator = iter = tableId == null ? ProblemReports.getInstance((AccumuloServerContext)Monitor.getContext()).iterator() : ProblemReports.getInstance((AccumuloServerContext)Monitor.getContext()).iterator(tableId);
        while (iter.hasNext()) {
            problemReports.add(iter.next());
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss zzz");
        Table problemTable = new Table("problemDetails", "Problem&nbsp;Details", "error");
        problemTable.setSubCaption("Problems identified with tables.");
        problemTable.addSortableColumn("Table", new TableProblemLinkType(tidToNameMap), null);
        problemTable.addSortableColumn("Problem&nbsp;Type");
        problemTable.addSortableColumn("Server");
        problemTable.addSortableColumn("Time", new DateTimeType(sdf), null);
        problemTable.addSortableColumn("Resource");
        problemTable.addSortableColumn("Exception");
        problemTable.addUnsortableColumn("Operations", new ClearProblemLinkType(req), null);
        for (ProblemReport pr : problemReports) {
            TableRow row = problemTable.prepareRow();
            row.add(pr.getTableName());
            row.add(pr.getProblemType().name());
            row.add(pr.getServer());
            row.add(pr.getTime());
            row.add(pr.getResource());
            row.add(pr.getException());
            row.add(pr);
            problemTable.addRow(row);
        }
        problemTable.generate(req, sb);
    }

    private static class ClearProblemLinkType
    extends CellType<ProblemReport> {
        private static final long serialVersionUID = 1L;
        private final String currentPage;

        public ClearProblemLinkType(HttpServletRequest req) {
            this.currentPage = BasicServlet.currentPage(req);
        }

        @Override
        public String alignment() {
            return "right";
        }

        @Override
        public String format(Object obj) {
            if (obj == null) {
                return "-";
            }
            ProblemReport p = (ProblemReport)obj;
            return String.format("<a href='/op?table=%s&action=clearProblem&redir=%s&resource=%s&ptype=%s'>clear this problem</a>", BasicServlet.encode(p.getTableName()), this.currentPage, BasicServlet.encode(p.getResource()), BasicServlet.encode(p.getProblemType().name()));
        }

        @Override
        public int compare(ProblemReport o1, ProblemReport o2) {
            return 0;
        }
    }

    private static class ClearTableProblemsLinkType
    extends StringType<String> {
        private static final long serialVersionUID = 1L;
        private final String currentPage;
        private Map<String, String> tidToNameMap;

        public ClearTableProblemsLinkType(HttpServletRequest req, Map<String, String> tidToNameMap) {
            this.tidToNameMap = tidToNameMap;
            this.currentPage = BasicServlet.currentPage(req);
        }

        @Override
        public String alignment() {
            return "right";
        }

        @Override
        public String format(Object obj) {
            if (obj == null) {
                return "-";
            }
            String table = String.valueOf(obj);
            return String.format("<a href='/op?table=%s&action=clearTableProblems&redir=%s'>clear ALL %s problems</a>", BasicServlet.encode(table), this.currentPage, Tables.getPrintableTableNameFromId(this.tidToNameMap, (String)table));
        }
    }

    private static class TableProblemLinkType
    extends StringType<String> {
        private static final long serialVersionUID = 1L;
        private Map<String, String> tidToNameMap;

        public TableProblemLinkType(Map<String, String> tidToNameMap) {
            this.tidToNameMap = tidToNameMap;
        }

        @Override
        public String format(Object obj) {
            if (obj == null) {
                return "-";
            }
            String table = String.valueOf(obj);
            return String.format("<a href='/problems?table=%s'>%s</a>", BasicServlet.encode(table), BasicServlet.encode(Tables.getPrintableTableNameFromId(this.tidToNameMap, (String)table)));
        }
    }
}

