/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.monitor.servlets.trace;

import java.security.PrivilegedAction;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.monitor.servlets.trace.Basic;
import org.apache.accumulo.monitor.servlets.trace.ShowTraceLinkType;
import org.apache.accumulo.monitor.util.Table;
import org.apache.accumulo.monitor.util.celltypes.DurationType;
import org.apache.accumulo.monitor.util.celltypes.StringType;
import org.apache.accumulo.tracer.TraceFormatter;
import org.apache.accumulo.tracer.thrift.RemoteSpan;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.UserGroupInformation;

public class ListType
extends Basic {
    private static final long serialVersionUID = 1L;

    String getType(HttpServletRequest req) {
        return ListType.getStringParameter(req, "type", "<Unknown>");
    }

    int getMinutes(HttpServletRequest req) {
        return ListType.getIntParameter(req, "minutes", 10);
    }

    @Override
    public void pageBody(HttpServletRequest req, HttpServletResponse resp, StringBuilder sb) throws Exception {
        final String type = this.getType(req);
        int minutes = this.getMinutes(req);
        long endTime = System.currentTimeMillis();
        long startTime = endTime - (long)(minutes * 60 * 1000);
        Map.Entry<Scanner, UserGroupInformation> entry = this.getScanner(sb);
        final Scanner scanner = entry.getKey();
        if (scanner == null) {
            return;
        }
        Range range = new Range(new Text("start:" + Long.toHexString(startTime)), new Text("start:" + Long.toHexString(endTime)));
        scanner.setRange(range);
        final Table trace = new Table("trace", "Traces for " + this.getType(req));
        trace.addSortableColumn("Start", new ShowTraceLinkType(), "Start Time");
        trace.addSortableColumn("ms", new DurationType(), "Span time");
        trace.addUnsortableColumn("Source", new StringType(), "Service and location");
        if (null != entry.getValue()) {
            entry.getValue().doAs((PrivilegedAction)new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    ListType.this.addRows(scanner, type, trace);
                    return null;
                }
            });
        } else {
            this.addRows(scanner, type, trace);
        }
        trace.generate(req, sb);
    }

    private void addRows(Scanner scanner, String type, Table trace) {
        for (Map.Entry entry : scanner) {
            RemoteSpan span = TraceFormatter.getRemoteSpan((Map.Entry)entry);
            if (!span.description.equals(type)) continue;
            trace.addRow(span, span.stop - span.start, span.svc + ":" + span.sender);
        }
    }

    @Override
    public String getTitle(HttpServletRequest req) {
        return "Traces for " + this.getType(req) + " for the last " + this.getMinutes(req) + " minutes";
    }
}

