/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.monitor.rest.trace;

import org.apache.accumulo.tracer.thrift.RemoteSpan;

public class RecentTracesInformation {
    public String type;
    public Long avg;
    public int total = 0;
    public long min = Long.MAX_VALUE;
    public long max = Long.MIN_VALUE;
    private long totalMS = 0L;
    public long[] histogram = new long[]{0L, 0L, 0L, 0L, 0L, 0L};

    public RecentTracesInformation() {
    }

    public RecentTracesInformation(String type) {
        this.type = type;
    }

    public void addSpan(RemoteSpan span) {
        int index;
        ++this.total;
        long ms = span.stop - span.start;
        this.totalMS += ms;
        this.min = Math.min(this.min, ms);
        this.max = Math.max(this.max, ms);
        for (index = 0; ms >= 10L && index < this.histogram.length; ms /= 10L, ++index) {
        }
        int n = index;
        this.histogram[n] = this.histogram[n] + 1L;
        this.avg = this.total != 0 ? Long.valueOf(this.totalMS / (long)this.total) : null;
    }
}

