/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.monitor.rest.trace;

import org.apache.accumulo.tracer.thrift.RemoteSpan;

public class TracesForTypeInformation {
    public String id;
    public String source;
    public Long start;
    public Long ms;

    public TracesForTypeInformation() {
    }

    public TracesForTypeInformation(RemoteSpan span) {
        this.id = this.getIDFromSpan(span);
        this.start = this.getDateFromSpan(span);
        this.ms = this.getSpanTime(span);
        this.source = this.getLocation(span);
    }

    protected String getIDFromSpan(RemoteSpan span) {
        if (span == null) {
            return null;
        }
        return String.format("%s", Long.toHexString(span.traceId));
    }

    protected Long getDateFromSpan(RemoteSpan span) {
        if (span == null) {
            return null;
        }
        return span.start;
    }

    protected Long getSpanTime(RemoteSpan span) {
        if (span == null) {
            return null;
        }
        return span.stop - span.start;
    }

    protected String getLocation(RemoteSpan span) {
        if (span == null) {
            return null;
        }
        return span.svc + ":" + span.sender;
    }
}

