/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.monitor.view;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.clientImpl.ClientContext;
import org.apache.accumulo.core.clientImpl.Tables;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.monitor.Monitor;
import org.apache.commons.lang3.StringUtils;
import org.glassfish.jersey.server.mvc.Template;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/")
@Produces(value={"text/html"})
public class WebViews {
    private static final Logger log = LoggerFactory.getLogger(WebViews.class);
    @Inject
    private Monitor monitor;

    private void addExternalResources(Map<String, Object> model) {
        AccumuloConfiguration conf = this.monitor.getContext().getConfiguration();
        String resourcesProperty = conf.get(Property.MONITOR_RESOURCES_EXTERNAL);
        if (StringUtils.isEmpty((CharSequence)resourcesProperty)) {
            return;
        }
        ArrayList<String> monitorResources = new ArrayList<String>();
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            for (String monitorResource : (String[])objectMapper.readValue(resourcesProperty, String[].class)) {
                monitorResources.add(monitorResource);
            }
        }
        catch (IOException e) {
            log.error("Error Monitor Resources config property {}: {}", (Object)Property.MONITOR_RESOURCES_EXTERNAL, (Object)e);
            return;
        }
        if (!monitorResources.isEmpty()) {
            model.put("externalResources", monitorResources);
        }
    }

    private Map<String, Object> getModel() {
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("version", "2.0.1");
        model.put("instance_name", this.monitor.getContext().getInstanceName());
        model.put("instance_id", this.monitor.getContext().getInstanceID());
        this.addExternalResources(model);
        return model;
    }

    @GET
    @Template(name="/default.ftl")
    public Map<String, Object> get() {
        Map<String, Object> model = this.getModel();
        model.put("title", "Accumulo Overview");
        model.put("template", "overview.ftl");
        model.put("js", "overview.js");
        return model;
    }

    @GET
    @Path(value="{parameter: master|monitor}")
    @Template(name="/default.ftl")
    public Map<String, Object> getMaster() {
        Map<String, Object> model = this.getModel();
        model.put("title", "Master Server");
        model.put("template", "master.ftl");
        model.put("js", "master.js");
        model.put("tablesTitle", "Table Status");
        model.put("tablesTemplate", "tables.ftl");
        return model;
    }

    @GET
    @Path(value="tservers")
    @Template(name="/default.ftl")
    public Map<String, Object> getTabletServers(@QueryParam(value="s") @Pattern(regexp="[a-zA-Z0-9.-]+:[0-9]{2,5}") @Pattern(regexp="[a-zA-Z0-9.-]+:[0-9]{2,5}") String server) {
        Map<String, Object> model = this.getModel();
        model.put("title", "Tablet Server Status");
        if (StringUtils.isNotBlank((CharSequence)server)) {
            model.put("template", "server.ftl");
            model.put("js", "server.js");
            model.put("server", server);
            return model;
        }
        model.put("template", "tservers.ftl");
        model.put("js", "tservers.js");
        return model;
    }

    @GET
    @Path(value="scans")
    @Template(name="/default.ftl")
    public Map<String, Object> getScans() {
        Map<String, Object> model = this.getModel();
        model.put("title", "Scans");
        model.put("template", "scans.ftl");
        model.put("js", "scans.js");
        return model;
    }

    @GET
    @Path(value="bulkImports")
    @Template(name="/default.ftl")
    public Map<String, Object> getBulkImports() {
        Map<String, Object> model = this.getModel();
        model.put("title", "Bulk Imports");
        model.put("template", "bulkImport.ftl");
        model.put("js", "bulkImport.js");
        return model;
    }

    @GET
    @Path(value="gc")
    @Template(name="/default.ftl")
    public Map<String, Object> getGC() {
        Map<String, Object> model = this.getModel();
        model.put("title", "Garbage Collector Status");
        model.put("template", "gc.ftl");
        model.put("js", "gc.js");
        return model;
    }

    @GET
    @Path(value="tables")
    @Template(name="/default.ftl")
    public Map<String, Object> getTables() {
        Map<String, Object> model = this.getModel();
        model.put("title", "Table Status");
        model.put("tablesTitle", "Table Status");
        model.put("template", "tables.ftl");
        return model;
    }

    @GET
    @Path(value="tables/{tableID}")
    @Template(name="/default.ftl")
    public Map<String, Object> getTables(@PathParam(value="tableID") @NotNull @Pattern(regexp="[!+]?\\w+") @NotNull @Pattern(regexp="[!+]?\\w+") String tableID) throws TableNotFoundException {
        String tableName = Tables.getTableName((ClientContext)this.monitor.getContext(), (TableId)TableId.of((String)tableID));
        Map<String, Object> model = this.getModel();
        model.put("title", "Table Status");
        model.put("template", "table.ftl");
        model.put("js", "table.js");
        model.put("tableID", tableID);
        model.put("table", tableName);
        return model;
    }

    @GET
    @Path(value="trace/summary")
    @Template(name="/default.ftl")
    public Map<String, Object> getTracesSummary(@QueryParam(value="minutes") @DefaultValue(value="10") @Min(value=0L) @Max(value=2592000L) @Min(value=0L) @Max(value=2592000L) int minutes) {
        Map<String, Object> model = this.getModel();
        model.put("title", "Traces for the last&nbsp;" + String.valueOf(minutes) + "&nbsp;minute(s)");
        model.put("template", "summary.ftl");
        model.put("js", "summary.js");
        model.put("minutes", String.valueOf(minutes));
        return model;
    }

    @GET
    @Path(value="trace/listType")
    @Template(name="/default.ftl")
    public Map<String, Object> getTracesForType(@QueryParam(value="type") @NotNull @Pattern(regexp="(?:)(.*)") @NotNull @Pattern(regexp="(?:)(.*)") String type, @QueryParam(value="minutes") @DefaultValue(value="10") @Min(value=0L) @Max(value=2592000L) @Min(value=0L) @Max(value=2592000L) int minutes) {
        Map<String, Object> model = this.getModel();
        model.put("title", "Traces for " + type + " for the last " + String.valueOf(minutes) + " minute(s)");
        model.put("template", "listType.ftl");
        model.put("js", "listType.js");
        model.put("type", type);
        model.put("minutes", String.valueOf(minutes));
        return model;
    }

    @GET
    @Path(value="trace/show")
    @Template(name="/default.ftl")
    public Map<String, Object> getTraceShow(@QueryParam(value="id") @NotNull @Pattern(regexp="\\w+") @NotNull @Pattern(regexp="\\w+") String id) {
        Map<String, Object> model = this.getModel();
        model.put("title", "Trace ID " + id);
        model.put("template", "show.ftl");
        model.put("js", "show.js");
        model.put("id", id);
        return model;
    }

    @GET
    @Path(value="log")
    @Template(name="/default.ftl")
    public Map<String, Object> getLogs() {
        Map<String, Object> model = this.getModel();
        model.put("title", "Recent Logs");
        model.put("template", "log.ftl");
        return model;
    }

    @GET
    @Path(value="problems")
    @Template(name="/default.ftl")
    public Map<String, Object> getProblems(@QueryParam(value="table") @Pattern(regexp="\\w*") @Pattern(regexp="\\w*") String table) {
        Map<String, Object> model = this.getModel();
        model.put("title", "Per-Table Problem Report");
        model.put("template", "problems.ftl");
        model.put("js", "problems.js");
        if (StringUtils.isNotBlank((CharSequence)table)) {
            model.put("table", table);
        }
        return model;
    }

    @GET
    @Path(value="replication")
    @Template(name="/default.ftl")
    public Map<String, Object> getReplication() {
        Map<String, Object> model = this.getModel();
        model.put("title", "Replication Overview");
        model.put("template", "replication.ftl");
        model.put("js", "replication.js");
        return model;
    }
}

