/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.monitor.rest.compactions;

import jakarta.inject.Inject;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import java.util.Map;
import org.apache.accumulo.core.manager.thrift.ManagerMonitorInfo;
import org.apache.accumulo.core.master.thrift.TabletServerStatus;
import org.apache.accumulo.core.util.HostAndPort;
import org.apache.accumulo.monitor.Monitor;
import org.apache.accumulo.monitor.rest.compactions.CompactionInfo;
import org.apache.accumulo.monitor.rest.compactions.Compactions;

@Path(value="/compactions")
@Produces(value={"application/json", "application/xml"})
public class CompactionsResource {
    @Inject
    private Monitor monitor;

    @GET
    public Compactions getActiveCompactions() {
        Compactions compactions = new Compactions();
        ManagerMonitorInfo mmi = this.monitor.getMmi();
        if (mmi == null) {
            return compactions;
        }
        Map<HostAndPort, Monitor.CompactionStats> entry = this.monitor.getCompactions();
        for (TabletServerStatus tserverInfo : mmi.getTServerInfo()) {
            Monitor.CompactionStats stats = entry.get(HostAndPort.fromString((String)tserverInfo.name));
            if (stats == null) continue;
            compactions.addCompaction(new CompactionInfo(tserverInfo, stats));
        }
        return compactions;
    }
}

