/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.monitor.util.logging;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.accumulo.monitor.rest.logs.SanitizedLogEvent;
import org.apache.accumulo.monitor.rest.logs.SingleLogEvent;

public class RecentLogs {
    private static final int MAX_LOGS = 50;
    private final LinkedHashMap<String, DedupedEvent> events = new LinkedHashMap<String, DedupedEvent>(51, 0.75f, true){
        private static final long serialVersionUID = 1L;

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, DedupedEvent> eldest) {
            return this.size() > 50;
        }
    };

    public synchronized void addEvent(SingleLogEvent event) {
        String key = event.application + ":" + event.logger + ":" + event.level + ":" + event.message;
        int count = this.events.containsKey(key) ? ((DedupedEvent)this.events.remove((Object)key)).count + 1 : 1;
        this.events.put(key, new DedupedEvent(event, count));
    }

    public synchronized void clearEvents() {
        this.events.clear();
    }

    public synchronized int numEvents() {
        return this.events.size();
    }

    public synchronized boolean eventsIncludeErrors() {
        return this.events.values().stream().anyMatch(x -> x.event.level.equalsIgnoreCase("ERROR") || x.event.level.equalsIgnoreCase("FATAL"));
    }

    public synchronized List<SanitizedLogEvent> getSanitizedEvents() {
        return this.events.values().stream().map(ev -> new SanitizedLogEvent(ev.event, ev.count)).collect(Collectors.toList());
    }

    private static class DedupedEvent {
        private final SingleLogEvent event;
        private final int count;

        private DedupedEvent(SingleLogEvent event, int count) {
            this.event = event;
            this.count = count;
        }
    }
}

