/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.log;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.util.Pair;
import org.apache.accumulo.core.zookeeper.ZooUtil;
import org.apache.accumulo.fate.zookeeper.ZooUtil;
import org.apache.accumulo.server.master.state.TServerInstance;
import org.apache.accumulo.server.zookeeper.ZooReaderWriter;
import org.apache.hadoop.fs.Path;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WalStateManager {
    private static final Logger log = LoggerFactory.getLogger(WalStateManager.class);
    public static final String ZWALS = "/wals";
    private final Instance instance;
    private final ZooReaderWriter zoo;
    private volatile boolean checkedExistance = false;

    public WalStateManager(Instance instance, ZooReaderWriter zoo) {
        this.instance = instance;
        this.zoo = zoo;
    }

    private String root() throws WalMarkerException {
        String root = ZooUtil.getRoot((Instance)this.instance) + ZWALS;
        try {
            if (!this.checkedExistance && !this.zoo.exists(root)) {
                this.zoo.putPersistentData(root, new byte[0], ZooUtil.NodeExistsPolicy.SKIP);
            }
            this.checkedExistance = true;
        }
        catch (InterruptedException | KeeperException e) {
            throw new WalMarkerException((Exception)e);
        }
        return root;
    }

    public void initWalMarker(TServerInstance tsi) throws WalMarkerException {
        byte[] data = new byte[]{};
        try {
            this.zoo.putPersistentData(this.root() + "/" + tsi.toString(), data, ZooUtil.NodeExistsPolicy.FAIL);
        }
        catch (InterruptedException | KeeperException e) {
            throw new WalMarkerException((Exception)e);
        }
    }

    public void addNewWalMarker(TServerInstance tsi, Path path) throws WalMarkerException {
        this.updateState(tsi, path, WalState.OPEN);
    }

    private void updateState(TServerInstance tsi, Path path, WalState state) throws WalMarkerException {
        byte[] data = (state.toString() + "," + path.toString()).getBytes(StandardCharsets.UTF_8);
        try {
            ZooUtil.NodeExistsPolicy policy = ZooUtil.NodeExistsPolicy.OVERWRITE;
            if (state == WalState.OPEN) {
                policy = ZooUtil.NodeExistsPolicy.FAIL;
            }
            log.debug("Setting {} to {}", (Object)path.getName(), (Object)state);
            this.zoo.putPersistentData(this.root() + "/" + tsi.toString() + "/" + path.getName(), data, policy);
        }
        catch (InterruptedException | KeeperException e) {
            throw new WalMarkerException((Exception)e);
        }
    }

    public void walUnreferenced(TServerInstance tsi, Path path) throws WalMarkerException {
        this.updateState(tsi, path, WalState.UNREFERENCED);
    }

    private static Pair<WalState, Path> parse(byte[] data) {
        String[] parts = new String(data, StandardCharsets.UTF_8).split(",");
        return new Pair((Object)WalState.valueOf(parts[0]), (Object)new Path(parts[1]));
    }

    public List<Path> getWalsInUse(TServerInstance tsi) throws WalMarkerException {
        ArrayList<Path> result = new ArrayList<Path>();
        try {
            String zpath = this.root() + "/" + tsi.toString();
            this.zoo.sync(zpath);
            for (String child : this.zoo.getChildren(zpath)) {
                Pair<WalState, Path> parts;
                byte[] zdata = null;
                try {
                    zdata = this.zoo.getData(zpath + "/" + child, null);
                }
                catch (KeeperException.NoNodeException e) {
                    log.debug("WAL state removed {} {} during getWalsInUse.  Likely a race condition between master and GC.", (Object)tsi, (Object)child);
                }
                if (zdata == null || (parts = WalStateManager.parse(zdata)).getFirst() == WalState.UNREFERENCED) continue;
                result.add((Path)parts.getSecond());
            }
        }
        catch (KeeperException.NoNodeException e) {
            log.debug("{} has no wal entry in zookeeper, assuming no logs", (Object)tsi);
        }
        catch (InterruptedException | KeeperException e) {
            throw new WalMarkerException((Exception)e);
        }
        return result;
    }

    public Map<TServerInstance, List<UUID>> getAllMarkers() throws WalMarkerException {
        HashMap<TServerInstance, List<UUID>> result = new HashMap<TServerInstance, List<UUID>>();
        try {
            String path = this.root();
            for (String child : this.zoo.getChildren(path)) {
                TServerInstance inst = new TServerInstance(child);
                ArrayList<UUID> logs = (ArrayList<UUID>)result.get(inst);
                if (logs == null) {
                    logs = new ArrayList<UUID>();
                    result.put(inst, logs);
                }
                for (String idString : this.zoo.getChildren(path + "/" + child)) {
                    logs.add(UUID.fromString(idString));
                }
            }
        }
        catch (InterruptedException | KeeperException e) {
            throw new WalMarkerException((Exception)e);
        }
        return result;
    }

    public Pair<WalState, Path> state(TServerInstance instance, UUID uuid) throws WalMarkerException {
        try {
            String path = this.root() + "/" + instance.toString() + "/" + uuid.toString();
            return WalStateManager.parse(this.zoo.getData(path, null));
        }
        catch (InterruptedException | KeeperException e) {
            throw new WalMarkerException((Exception)e);
        }
    }

    public Map<Path, WalState> getAllState() throws WalMarkerException {
        HashMap<Path, WalState> result = new HashMap<Path, WalState>();
        for (Map.Entry<TServerInstance, List<UUID>> entry : this.getAllMarkers().entrySet()) {
            for (UUID id : entry.getValue()) {
                Pair<WalState, Path> state = this.state(entry.getKey(), id);
                result.put((Path)state.getSecond(), (WalState)((Object)state.getFirst()));
            }
        }
        return result;
    }

    public void removeWalMarker(TServerInstance instance, UUID uuid) throws WalMarkerException {
        try {
            log.debug("Removing {}", (Object)uuid);
            String path = this.root() + "/" + instance.toString() + "/" + uuid.toString();
            this.zoo.delete(path, -1);
        }
        catch (InterruptedException | KeeperException e) {
            throw new WalMarkerException((Exception)e);
        }
    }

    public void forget(TServerInstance instance) throws WalMarkerException {
        String path = this.root() + "/" + instance.toString();
        try {
            this.zoo.recursiveDelete(path, ZooUtil.NodeMissingPolicy.FAIL);
        }
        catch (InterruptedException | KeeperException e) {
            throw new WalMarkerException((Exception)e);
        }
    }

    public void closeWal(TServerInstance instance, Path path) throws WalMarkerException {
        this.updateState(instance, path, WalState.CLOSED);
    }

    public static enum WalState {
        OPEN,
        CLOSED,
        UNREFERENCED;

    }

    public class WalMarkerException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public WalMarkerException(Exception ex) {
            super(ex);
        }
    }
}

