/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.conf;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.accumulo.core.Constants;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.ConfigurationObserver;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.zookeeper.ZooUtil;
import org.apache.accumulo.fate.zookeeper.ZooCache;
import org.apache.accumulo.server.client.HdfsZooInstance;
import org.apache.accumulo.server.conf.NamespaceConfWatcher;
import org.apache.log4j.Logger;
import org.apache.zookeeper.Watcher;

public class NamespaceConfiguration
extends AccumuloConfiguration {
    private static final Logger log = Logger.getLogger(NamespaceConfiguration.class);
    private final AccumuloConfiguration parent;
    private static volatile ZooCache propCache = null;
    private static final Object lock = new Object();
    protected String namespaceId = null;
    protected Instance inst = null;
    private Set<ConfigurationObserver> observers;

    public NamespaceConfiguration(String namespaceId, AccumuloConfiguration parent) {
        this(namespaceId, HdfsZooInstance.getInstance(), parent);
    }

    public NamespaceConfiguration(String namespaceId, Instance inst, AccumuloConfiguration parent) {
        this.inst = inst;
        this.parent = parent;
        this.namespaceId = namespaceId;
        this.observers = Collections.synchronizedSet(new HashSet());
    }

    public String get(Property property) {
        String key = property.getKey();
        String value = this.get(this.getPropCache(), key);
        if (value == null || !property.getType().isValidFormat(value)) {
            if (value != null) {
                log.error((Object)("Using default value for " + key + " due to improperly formatted " + property.getType() + ": " + value));
            }
            if (!this.namespaceId.equals("+accumulo") || !this.isIteratorOrConstraint(property.getKey())) {
                value = this.parent.get(property);
            }
        }
        return value;
    }

    private String get(ZooCache zc, String key) {
        String zPath = ZooUtil.getRoot((String)this.inst.getInstanceID()) + "/namespaces" + "/" + this.getNamespaceId() + "/conf" + "/" + key;
        byte[] v = zc.get(zPath);
        String value = null;
        if (v != null) {
            value = new String(v, Constants.UTF8);
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializePropCache() {
        Object object = lock;
        synchronized (object) {
            if (propCache == null) {
                propCache = new ZooCache(this.inst.getZooKeepers(), this.inst.getZooKeepersSessionTimeOut(), (Watcher)new NamespaceConfWatcher(this.inst));
            }
        }
    }

    private ZooCache getPropCache() {
        if (null == propCache) {
            this.initializePropCache();
        }
        return propCache;
    }

    public void getProperties(Map<String, String> props, AccumuloConfiguration.PropertyFilter filter) {
        AccumuloConfiguration.PropertyFilter parentFilter = filter;
        if (this.getNamespaceId().equals("+accumulo")) {
            parentFilter = new SystemNamespaceFilter(filter);
        }
        this.parent.getProperties(props, parentFilter);
        ZooCache zc = this.getPropCache();
        List children = zc.getChildren(ZooUtil.getRoot((String)this.inst.getInstanceID()) + "/namespaces" + "/" + this.getNamespaceId() + "/conf");
        if (children != null) {
            for (String child : children) {
                String value;
                if (child == null || !filter.accept(child) || (value = this.get(zc, child)) == null) continue;
                props.put(child, value);
            }
        }
    }

    protected String getNamespaceId() {
        return this.namespaceId;
    }

    public void addObserver(ConfigurationObserver co) {
        if (this.namespaceId == null) {
            String err = "Attempt to add observer for non-namespace configuration";
            log.error((Object)err);
            throw new RuntimeException(err);
        }
        this.iterator();
        this.observers.add(co);
    }

    public void removeObserver(ConfigurationObserver configObserver) {
        if (this.namespaceId == null) {
            String err = "Attempt to remove observer for non-namespace configuration";
            log.error((Object)err);
            throw new RuntimeException(err);
        }
        this.observers.remove(configObserver);
    }

    public void expireAllObservers() {
        Collection<ConfigurationObserver> copy = Collections.unmodifiableCollection(this.observers);
        for (ConfigurationObserver co : copy) {
            co.sessionExpired();
        }
    }

    public void propertyChanged(String key) {
        Collection<ConfigurationObserver> copy = Collections.unmodifiableCollection(this.observers);
        for (ConfigurationObserver co : copy) {
            co.propertyChanged(key);
        }
    }

    public void propertiesChanged(String key) {
        Collection<ConfigurationObserver> copy = Collections.unmodifiableCollection(this.observers);
        for (ConfigurationObserver co : copy) {
            co.propertiesChanged();
        }
    }

    protected boolean isIteratorOrConstraint(String key) {
        return key.startsWith(Property.TABLE_ITERATOR_PREFIX.getKey()) || key.startsWith(Property.TABLE_CONSTRAINT_PREFIX.getKey());
    }

    public void invalidateCache() {
        if (null != propCache) {
            propCache.clear();
        }
    }

    private class SystemNamespaceFilter
    implements AccumuloConfiguration.PropertyFilter {
        private AccumuloConfiguration.PropertyFilter userFilter;

        SystemNamespaceFilter(AccumuloConfiguration.PropertyFilter userFilter) {
            this.userFilter = userFilter;
        }

        public boolean accept(String key) {
            if (NamespaceConfiguration.this.isIteratorOrConstraint(key)) {
                return false;
            }
            return this.userFilter.accept(key);
        }
    }
}

