/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.conf;

import java.security.SecurityPermission;
import java.util.HashMap;
import java.util.Map;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.client.impl.Tables;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.ConfigSanityCheck;
import org.apache.accumulo.core.conf.DefaultConfiguration;
import org.apache.accumulo.core.conf.SiteConfiguration;
import org.apache.accumulo.core.data.KeyExtent;
import org.apache.accumulo.server.conf.NamespaceConfiguration;
import org.apache.accumulo.server.conf.TableConfiguration;
import org.apache.accumulo.server.conf.TableParentConfiguration;
import org.apache.accumulo.server.conf.ZooConfiguration;

public class ServerConfiguration {
    private static final Map<String, TableConfiguration> tableInstances = new HashMap<String, TableConfiguration>(1);
    private static final Map<String, NamespaceConfiguration> namespaceInstances = new HashMap<String, NamespaceConfiguration>(1);
    private static final Map<String, NamespaceConfiguration> tableParentInstances = new HashMap<String, NamespaceConfiguration>(1);
    private static SecurityPermission CONFIGURATION_PERMISSION = new SecurityPermission("configurationPermission");
    private final Instance instance;

    public static synchronized SiteConfiguration getSiteConfiguration() {
        ServerConfiguration.checkPermissions();
        return SiteConfiguration.getInstance((AccumuloConfiguration)ServerConfiguration.getDefaultConfiguration());
    }

    private static void checkPermissions() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(CONFIGURATION_PERMISSION);
        }
    }

    private static synchronized ZooConfiguration getZooConfiguration(Instance instance) {
        ServerConfiguration.checkPermissions();
        return ZooConfiguration.getInstance(instance, (AccumuloConfiguration)ServerConfiguration.getSiteConfiguration());
    }

    public static synchronized DefaultConfiguration getDefaultConfiguration() {
        ServerConfiguration.checkPermissions();
        return DefaultConfiguration.getInstance();
    }

    public static synchronized AccumuloConfiguration getSystemConfiguration(Instance instance) {
        return ServerConfiguration.getZooConfiguration(instance);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NamespaceConfiguration getNamespaceConfigurationForTable(Instance instance, String tableId) {
        ServerConfiguration.checkPermissions();
        Map<String, NamespaceConfiguration> map = tableParentInstances;
        synchronized (map) {
            NamespaceConfiguration conf = tableParentInstances.get(tableId);
            if (conf == null) {
                conf = new TableParentConfiguration(tableId, ServerConfiguration.getSystemConfiguration(instance));
                ConfigSanityCheck.validate((AccumuloConfiguration)conf);
                tableParentInstances.put(tableId, conf);
            }
            return conf;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NamespaceConfiguration getNamespaceConfiguration(Instance instance, String namespaceId) {
        ServerConfiguration.checkPermissions();
        Map<String, NamespaceConfiguration> map = namespaceInstances;
        synchronized (map) {
            NamespaceConfiguration conf = namespaceInstances.get(namespaceId);
            if (conf == null) {
                conf = new NamespaceConfiguration(namespaceId, ServerConfiguration.getSystemConfiguration(instance));
                ConfigSanityCheck.validate((AccumuloConfiguration)conf);
                namespaceInstances.put(namespaceId, conf);
            }
            return conf;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TableConfiguration getTableConfiguration(Instance instance, String tableId) {
        ServerConfiguration.checkPermissions();
        Map<String, TableConfiguration> map = tableInstances;
        synchronized (map) {
            TableConfiguration conf = tableInstances.get(tableId);
            if (conf == null && Tables.exists((Instance)instance, (String)tableId)) {
                conf = new TableConfiguration(instance.getInstanceID(), tableId, ServerConfiguration.getNamespaceConfigurationForTable(instance, tableId));
                ConfigSanityCheck.validate((AccumuloConfiguration)conf);
                tableInstances.put(tableId, conf);
            }
            return conf;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void removeTableIdInstance(String tableId) {
        Map<String, TableConfiguration> map = tableInstances;
        synchronized (map) {
            tableInstances.remove(tableId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void removeNamespaceIdInstance(String namespaceId) {
        Map<String, NamespaceConfiguration> map = namespaceInstances;
        synchronized (map) {
            namespaceInstances.remove(namespaceId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void expireAllTableObservers() {
        Map<String, TableConfiguration> map = tableInstances;
        synchronized (map) {
            for (Map.Entry<String, TableConfiguration> entry : tableInstances.entrySet()) {
                entry.getValue().expireAllObservers();
            }
        }
    }

    public ServerConfiguration(Instance instance) {
        this.instance = instance;
    }

    public TableConfiguration getTableConfiguration(String tableId) {
        return ServerConfiguration.getTableConfiguration(this.instance, tableId);
    }

    public TableConfiguration getTableConfiguration(KeyExtent extent) {
        return this.getTableConfiguration(extent.getTableId().toString());
    }

    public NamespaceConfiguration getNamespaceConfiguration(String namespaceId) {
        return ServerConfiguration.getNamespaceConfiguration(this.instance, namespaceId);
    }

    public synchronized AccumuloConfiguration getConfiguration() {
        return ServerConfiguration.getZooConfiguration(this.instance);
    }

    public Instance getInstance() {
        return this.instance;
    }
}

