/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.conf;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.accumulo.core.Constants;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.ConfigurationObserver;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.zookeeper.ZooUtil;
import org.apache.accumulo.fate.zookeeper.ZooCache;
import org.apache.accumulo.server.client.HdfsZooInstance;
import org.apache.accumulo.server.conf.NamespaceConfiguration;
import org.apache.accumulo.server.conf.ServerConfiguration;
import org.apache.accumulo.server.conf.TableConfWatcher;
import org.apache.log4j.Logger;
import org.apache.zookeeper.Watcher;

public class TableConfiguration
extends AccumuloConfiguration {
    private static final Logger log = Logger.getLogger(TableConfiguration.class);
    private static volatile ZooCache tablePropCache = null;
    private static final Object initLock = new Object();
    private final String instanceId;
    private final Instance instance;
    private final NamespaceConfiguration parent;
    private String table = null;
    private Set<ConfigurationObserver> observers;

    public TableConfiguration(String instanceId, String table, NamespaceConfiguration parent) {
        this(instanceId, HdfsZooInstance.getInstance(), table, parent);
    }

    public TableConfiguration(String instanceId, Instance instance, String table, NamespaceConfiguration parent) {
        this.instanceId = instanceId;
        this.instance = instance;
        this.table = table;
        this.parent = parent;
        this.observers = Collections.synchronizedSet(new HashSet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeZooCache() {
        Object object = initLock;
        synchronized (object) {
            if (null == tablePropCache) {
                tablePropCache = new ZooCache(this.instance.getZooKeepers(), this.instance.getZooKeepersSessionTimeOut(), (Watcher)new TableConfWatcher(this.instance));
            }
        }
    }

    private ZooCache getTablePropCache() {
        if (null == tablePropCache) {
            this.initializeZooCache();
        }
        return tablePropCache;
    }

    public void addObserver(ConfigurationObserver co) {
        if (this.table == null) {
            String err = "Attempt to add observer for non-table configuration";
            log.error((Object)err);
            throw new RuntimeException(err);
        }
        this.iterator();
        this.observers.add(co);
    }

    public void removeObserver(ConfigurationObserver configObserver) {
        if (this.table == null) {
            String err = "Attempt to remove observer for non-table configuration";
            log.error((Object)err);
            throw new RuntimeException(err);
        }
        this.observers.remove(configObserver);
    }

    public void expireAllObservers() {
        Collection<ConfigurationObserver> copy = Collections.unmodifiableCollection(this.observers);
        for (ConfigurationObserver co : copy) {
            co.sessionExpired();
        }
    }

    public void propertyChanged(String key) {
        Collection<ConfigurationObserver> copy = Collections.unmodifiableCollection(this.observers);
        for (ConfigurationObserver co : copy) {
            co.propertyChanged(key);
        }
    }

    public void propertiesChanged(String key) {
        Collection<ConfigurationObserver> copy = Collections.unmodifiableCollection(this.observers);
        for (ConfigurationObserver co : copy) {
            co.propertiesChanged();
        }
    }

    public String get(Property property) {
        String key = property.getKey();
        String value = this.get(this.getTablePropCache(), key);
        if (value == null || !property.getType().isValidFormat(value)) {
            if (value != null) {
                log.error((Object)("Using default value for " + key + " due to improperly formatted " + property.getType() + ": " + value));
            }
            value = this.parent.get(property);
        }
        return value;
    }

    private String get(ZooCache zc, String key) {
        String zPath = ZooUtil.getRoot((String)this.instanceId) + "/tables" + "/" + this.table + "/conf" + "/" + key;
        byte[] v = zc.get(zPath);
        String value = null;
        if (v != null) {
            value = new String(v, Constants.UTF8);
        }
        return value;
    }

    public void getProperties(Map<String, String> props, AccumuloConfiguration.PropertyFilter filter) {
        this.parent.getProperties(props, filter);
        ZooCache zc = this.getTablePropCache();
        List children = zc.getChildren(ZooUtil.getRoot((String)this.instanceId) + "/tables" + "/" + this.table + "/conf");
        if (children != null) {
            for (String child : children) {
                String value;
                if (child == null || !filter.accept(child) || (value = this.get(zc, child)) == null) continue;
                props.put(child, value);
            }
        }
    }

    public String getTableId() {
        return this.table;
    }

    public NamespaceConfiguration getNamespaceConfiguration() {
        return ServerConfiguration.getNamespaceConfiguration(this.parent.inst, this.parent.namespaceId);
    }

    public NamespaceConfiguration getParentConfiguration() {
        return this.parent;
    }

    public void invalidateCache() {
        if (null != tablePropCache) {
            tablePropCache.clear();
        }
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }
}

