/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.conf;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.accumulo.core.Constants;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.zookeeper.ZooUtil;
import org.apache.accumulo.fate.zookeeper.ZooCache;
import org.apache.accumulo.server.Accumulo;
import org.apache.accumulo.server.client.HdfsZooInstance;
import org.apache.accumulo.server.fs.VolumeManager;
import org.apache.accumulo.server.fs.VolumeManagerImpl;
import org.apache.hadoop.fs.Path;
import org.apache.log4j.Logger;

public class ZooConfiguration
extends AccumuloConfiguration {
    private static final Logger log = Logger.getLogger(ZooConfiguration.class);
    private final AccumuloConfiguration parent;
    private static ZooConfiguration instance = null;
    private static String instanceId = null;
    private static ZooCache propCache = null;
    private final Map<String, String> fixedProps = Collections.synchronizedMap(new HashMap());

    private ZooConfiguration(AccumuloConfiguration parent) {
        this.parent = parent;
    }

    public static synchronized ZooConfiguration getInstance(Instance inst, AccumuloConfiguration parent) {
        if (instance == null) {
            propCache = new ZooCache(inst.getZooKeepers(), inst.getZooKeepersSessionTimeOut());
            instance = new ZooConfiguration(parent);
            instanceId = inst.getInstanceID();
        }
        return instance;
    }

    public static synchronized ZooConfiguration getInstance(AccumuloConfiguration parent) {
        if (instance == null) {
            String deprecatedInstanceIdFromHdfs;
            VolumeManager fs;
            propCache = new ZooCache(parent.get(Property.INSTANCE_ZK_HOST), (int)parent.getTimeInMillis(Property.INSTANCE_ZK_TIMEOUT));
            instance = new ZooConfiguration(parent);
            try {
                fs = VolumeManagerImpl.get();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            Path instanceIdPath = Accumulo.getAccumuloInstanceIdPath(fs);
            instanceId = deprecatedInstanceIdFromHdfs = ZooUtil.getInstanceIDFromHdfs((Path)instanceIdPath, (AccumuloConfiguration)parent);
        }
        return instance;
    }

    public void invalidateCache() {
        if (propCache != null) {
            propCache.clear();
        }
    }

    private String _get(Property property) {
        String key = property.getKey();
        String value = null;
        if (Property.isValidZooPropertyKey((String)key)) {
            try {
                value = this.get(key);
            }
            catch (HdfsZooInstance.AccumuloNotInitializedException e) {
                log.warn((Object)("failed to lookup property in zookeeper: " + key), (Throwable)e);
            }
        }
        if (value == null || !property.getType().isValidFormat(value)) {
            if (value != null) {
                log.error((Object)("Using parent value for " + key + " due to improperly formatted " + property.getType() + ": " + value));
            }
            value = this.parent.get(property);
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String get(Property property) {
        if (Property.isFixedZooPropertyKey((Property)property)) {
            if (this.fixedProps.containsKey(property.getKey())) {
                return this.fixedProps.get(property.getKey());
            }
            Map<String, String> map = this.fixedProps;
            synchronized (map) {
                String val = this._get(property);
                this.fixedProps.put(property.getKey(), val);
                return val;
            }
        }
        return this._get(property);
    }

    private String get(String key) {
        String zPath = ZooUtil.getRoot((String)instanceId) + "/config" + "/" + key;
        byte[] v = propCache.get(zPath);
        String value = null;
        if (v != null) {
            value = new String(v, Constants.UTF8);
        }
        return value;
    }

    public void getProperties(Map<String, String> props, AccumuloConfiguration.PropertyFilter filter) {
        this.parent.getProperties(props, filter);
        List children = propCache.getChildren(ZooUtil.getRoot((String)instanceId) + "/config");
        if (children != null) {
            for (String child : children) {
                String value;
                if (child == null || !filter.accept(child) || (value = this.get(child)) == null) continue;
                props.put(child, value);
            }
        }
    }
}

