/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.data;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.accumulo.core.data.ColumnUpdate;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.thrift.TMutation;
import org.apache.accumulo.server.data.ServerColumnUpdate;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.WritableUtils;

public class ServerMutation
extends Mutation {
    private long systemTime = 0L;

    public ServerMutation(TMutation tmutation) {
        super(tmutation);
    }

    public ServerMutation(Text key) {
        super(key);
    }

    public ServerMutation() {
    }

    protected void droppingOldTimestamp(long ts) {
        this.systemTime = ts;
    }

    public void readFields(DataInput in) throws IOException {
        super.readFields(in);
        if (this.getSerializedFormat() == Mutation.SERIALIZED_FORMAT.VERSION2) {
            this.systemTime = WritableUtils.readVLong((DataInput)in);
        }
    }

    public void write(DataOutput out) throws IOException {
        super.write(out);
        WritableUtils.writeVLong((DataOutput)out, (long)this.systemTime);
    }

    public void setSystemTimestamp(long v) {
        this.systemTime = v;
    }

    public long getSystemTimestamp() {
        return this.systemTime;
    }

    protected ColumnUpdate newColumnUpdate(byte[] cf, byte[] cq, byte[] cv, boolean hasts, long ts, boolean deleted, byte[] val) {
        return new ServerColumnUpdate(cf, cq, cv, hasts, ts, deleted, val, this);
    }

    public long estimatedMemoryUsed() {
        return super.estimatedMemoryUsed() + 8L;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || o.getClass() != ServerMutation.class) {
            return false;
        }
        ServerMutation sm = (ServerMutation)((Object)o);
        if (sm.systemTime != this.systemTime) {
            return false;
        }
        return super.equals(o);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (int)(this.systemTime & 0xFFFFFFFFFFFFFFFFL);
        return result;
    }
}

