/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.fs;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public class ViewFSUtils {
    public static final String VIEWFS_CLASSNAME = "org.apache.hadoop.fs.viewfs.ViewFileSystem";

    public static boolean isViewFSSupported() {
        try {
            Class.forName(VIEWFS_CLASSNAME);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static boolean isViewFS(Path source, Configuration conf) throws IOException {
        return ViewFSUtils.isViewFS(source.getFileSystem(conf));
    }

    public static boolean isViewFS(FileSystem fs) {
        return fs.getClass().getName().equals(VIEWFS_CLASSNAME);
    }

    public static Path resolvePath(FileSystem fs, Path path) throws IOException {
        try {
            Method method = fs.getClass().getMethod("resolvePath", Path.class);
            return (Path)method.invoke((Object)fs, path);
        }
        catch (IllegalArgumentException e) {
            throw new IOException(e);
        }
        catch (IllegalAccessException e) {
            throw new IOException(e);
        }
        catch (InvocationTargetException e) {
            throw new IOException(e);
        }
        catch (SecurityException e) {
            throw new IOException(e);
        }
        catch (NoSuchMethodException e) {
            throw new IOException(e);
        }
    }

    public static Path matchingFileSystem(Path source, String[] options, Configuration conf) throws IOException {
        if (!ViewFSUtils.isViewFS(source, conf)) {
            throw new IllegalArgumentException("source " + source + " is not view fs");
        }
        String sourceUriPath = source.toUri().getPath();
        Path match = null;
        int matchPrefixLen = 0;
        for (String option : options) {
            Path optionPath = new Path(option);
            if (!ViewFSUtils.isViewFS(optionPath, conf)) continue;
            String optionUriPath = optionPath.toUri().getPath();
            int commonPrefixLen = 0;
            for (int i = 0; i < Math.min(sourceUriPath.length(), optionUriPath.length()) && sourceUriPath.charAt(i) == optionUriPath.charAt(i); ++i) {
                if (sourceUriPath.charAt(i) != '/') continue;
                ++commonPrefixLen;
            }
            if (commonPrefixLen > matchPrefixLen) {
                matchPrefixLen = commonPrefixLen;
                match = optionPath;
                continue;
            }
            if (match == null || commonPrefixLen != matchPrefixLen || optionPath.depth() >= match.depth()) continue;
            match = optionPath;
        }
        return match;
    }
}

