/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.init;

import com.beust.jcommander.Parameter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import jline.console.ConsoleReader;
import org.apache.accumulo.core.Constants;
import org.apache.accumulo.core.cli.Help;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.impl.thrift.ThriftSecurityException;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.conf.SiteConfiguration;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.KeyExtent;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.file.FileOperations;
import org.apache.accumulo.core.file.FileSKVWriter;
import org.apache.accumulo.core.iterators.user.VersioningIterator;
import org.apache.accumulo.core.master.state.tables.TableState;
import org.apache.accumulo.core.master.thrift.MasterGoalState;
import org.apache.accumulo.core.metadata.schema.MetadataSchema;
import org.apache.accumulo.core.security.SecurityUtil;
import org.apache.accumulo.core.util.CachedConfiguration;
import org.apache.accumulo.core.volume.VolumeConfiguration;
import org.apache.accumulo.core.zookeeper.ZooUtil;
import org.apache.accumulo.fate.zookeeper.IZooReaderWriter;
import org.apache.accumulo.fate.zookeeper.ZooUtil;
import org.apache.accumulo.server.Accumulo;
import org.apache.accumulo.server.ServerConstants;
import org.apache.accumulo.server.client.HdfsZooInstance;
import org.apache.accumulo.server.conf.ServerConfiguration;
import org.apache.accumulo.server.constraints.MetadataConstraints;
import org.apache.accumulo.server.fs.VolumeManager;
import org.apache.accumulo.server.fs.VolumeManagerImpl;
import org.apache.accumulo.server.iterators.MetadataBulkLoadFilter;
import org.apache.accumulo.server.security.AuditedSecurityOperation;
import org.apache.accumulo.server.security.SystemCredentials;
import org.apache.accumulo.server.tables.TableManager;
import org.apache.accumulo.server.util.ChangeSecret;
import org.apache.accumulo.server.util.TablePropUtil;
import org.apache.accumulo.server.zookeeper.ZooReaderWriter;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.log4j.Logger;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;

public class Initialize {
    private static final Logger log = Logger.getLogger(Initialize.class);
    private static final String DEFAULT_ROOT_USER = "root";
    public static final String TABLE_TABLETS_TABLET_DIR = "/table_info";
    private static ConsoleReader reader = null;
    private static IZooReaderWriter zoo = ZooReaderWriter.getInstance();
    private static HashMap<String, String> initialMetadataConf = new HashMap();

    private static ConsoleReader getConsoleReader() throws IOException {
        if (reader == null) {
            reader = new ConsoleReader();
        }
        return reader;
    }

    static void setZooReaderWriter(IZooReaderWriter izoo) {
        zoo = izoo;
    }

    static IZooReaderWriter getZooReaderWriter() {
        return zoo;
    }

    static boolean checkInit(Configuration conf, VolumeManager fs, SiteConfiguration sconf) throws IOException {
        String fsUri = sconf.get(Property.INSTANCE_DFS_URI);
        if (fsUri.equals("")) {
            fsUri = FileSystem.getDefaultUri((Configuration)conf).toString();
        }
        log.info((Object)("Hadoop Filesystem is " + fsUri));
        log.info((Object)("Accumulo data dirs are " + Arrays.asList(VolumeConfiguration.getVolumeUris((AccumuloConfiguration)ServerConfiguration.getSiteConfiguration()))));
        log.info((Object)("Zookeeper server is " + sconf.get(Property.INSTANCE_ZK_HOST)));
        log.info((Object)"Checking if Zookeeper is available. If this hangs, then you need to make sure zookeeper is running");
        if (!Initialize.zookeeperAvailable()) {
            log.fatal((Object)"Zookeeper needs to be up and running in order to init. Exiting ...");
            return false;
        }
        if (sconf.get(Property.INSTANCE_SECRET).equals(Property.INSTANCE_SECRET.getDefaultValue())) {
            ConsoleReader c = Initialize.getConsoleReader();
            c.beep();
            c.println();
            c.println();
            c.println((CharSequence)"Warning!!! Your instance secret is still set to the default, this is not secure. We highly recommend you change it.");
            c.println();
            c.println();
            c.println((CharSequence)"You can change the instance secret in accumulo by using:");
            c.println((CharSequence)("   bin/accumulo " + ChangeSecret.class.getName() + " oldPassword newPassword."));
            c.println((CharSequence)"You will also need to edit your secret in your configuration file by adding the property instance.secret to your conf/accumulo-site.xml. Without this accumulo will not operate correctly");
        }
        try {
            if (Initialize.isInitialized(fs)) {
                Initialize.printInitializeFailureMessages(sconf);
                return false;
            }
        }
        catch (IOException e) {
            throw new IOException("Failed to check if filesystem already initialized", e);
        }
        return true;
    }

    static void printInitializeFailureMessages(SiteConfiguration sconf) {
        String instanceDfsDir = sconf.get(Property.INSTANCE_DFS_DIR);
        log.fatal((Object)("It appears the directories " + Arrays.asList(VolumeConfiguration.getVolumeUris((AccumuloConfiguration)ServerConfiguration.getSiteConfiguration())) + " were previously initialized."));
        String instanceVolumes = sconf.get(Property.INSTANCE_VOLUMES);
        String instanceDfsUri = sconf.get(Property.INSTANCE_DFS_URI);
        if (!instanceVolumes.isEmpty()) {
            log.fatal((Object)("Change the property " + Property.INSTANCE_VOLUMES + " to use different filesystems,"));
        } else if (!instanceDfsDir.isEmpty()) {
            log.fatal((Object)("Change the property " + Property.INSTANCE_DFS_URI + " to use a different filesystem,"));
        } else {
            log.fatal((Object)("You are using the default URI for the filesystem. Set the property " + Property.INSTANCE_VOLUMES + " to use a different filesystem,"));
        }
        log.fatal((Object)("or change the property " + Property.INSTANCE_DFS_DIR + " to use a different directory."));
        log.fatal((Object)("The current value of " + Property.INSTANCE_DFS_URI + " is |" + instanceDfsUri + "|"));
        log.fatal((Object)("The current value of " + Property.INSTANCE_DFS_DIR + " is |" + instanceDfsDir + "|"));
        log.fatal((Object)("The current value of " + Property.INSTANCE_VOLUMES + " is |" + instanceVolumes + "|"));
    }

    public static boolean doInit(Opts opts, Configuration conf, VolumeManager fs) throws IOException {
        String instanceNamePath;
        if (!Initialize.checkInit(conf, fs, ServerConfiguration.getSiteConfiguration())) {
            return false;
        }
        try {
            instanceNamePath = Initialize.getInstanceNamePath(opts);
        }
        catch (Exception e) {
            log.fatal((Object)"Failed to talk to zookeeper", (Throwable)e);
            return false;
        }
        opts.rootpass = Initialize.getRootPassword(opts);
        return Initialize.initialize(opts, instanceNamePath, fs);
    }

    public static boolean initialize(Opts opts, String instanceNamePath, VolumeManager fs) {
        UUID uuid = UUID.randomUUID();
        String[] configuredTableDirs = VolumeConfiguration.prefix((String[])VolumeConfiguration.getVolumeUris((AccumuloConfiguration)ServerConfiguration.getSiteConfiguration()), (String)"tables");
        Path rootTablet = new Path(fs.choose(configuredTableDirs) + "/" + "+r" + "/root_tablet");
        try {
            Initialize.initZooKeeper(opts, uuid.toString(), instanceNamePath, rootTablet);
        }
        catch (Exception e) {
            log.fatal((Object)"Failed to initialize zookeeper", (Throwable)e);
            return false;
        }
        try {
            Initialize.initFileSystem(opts, fs, uuid, rootTablet);
        }
        catch (Exception e) {
            log.fatal((Object)"Failed to initialize filesystem", (Throwable)e);
            if (ServerConfiguration.getSiteConfiguration().get(Property.INSTANCE_VOLUMES).trim().equals("")) {
                Configuration fsConf = CachedConfiguration.getInstance();
                String defaultFsUri = "file:///";
                String fsDefaultName = fsConf.get("fs.default.name", "file:///");
                String fsDefaultFS = fsConf.get("fs.defaultFS", "file:///");
                if ("file:///".equals(fsDefaultName) && "file:///".equals(fsDefaultFS)) {
                    log.fatal((Object)"Default filesystem value ('fs.defaultFS' or 'fs.default.name') was found in the Hadoop configuration");
                    log.fatal((Object)"Please ensure that the Hadoop core-site.xml is on the classpath using 'general.classpaths' in accumulo-site.xml");
                }
            }
            return false;
        }
        try {
            Initialize.initSecurity(opts, uuid.toString());
        }
        catch (Exception e) {
            log.fatal((Object)"Failed to initialize security", (Throwable)e);
            return false;
        }
        return true;
    }

    private static boolean zookeeperAvailable() {
        try {
            return zoo.exists("/");
        }
        catch (KeeperException e) {
            return false;
        }
        catch (InterruptedException e) {
            return false;
        }
    }

    private static Path[] paths(String[] paths) {
        Path[] result = new Path[paths.length];
        for (int i = 0; i < paths.length; ++i) {
            result[i] = new Path(paths[i]);
        }
        return result;
    }

    private static void initDirs(VolumeManager fs, UUID uuid, String[] baseDirs, boolean print) throws IOException {
        for (String baseDir : baseDirs) {
            fs.mkdirs(new Path(new Path(baseDir, "version"), "6"));
            Path iidLocation = new Path(baseDir, "instance_id");
            fs.mkdirs(iidLocation);
            fs.createNewFile(new Path(iidLocation, uuid.toString()));
            if (!print) continue;
            log.info((Object)("Initialized volume " + baseDir));
        }
    }

    private static void initFileSystem(Opts opts, VolumeManager fs, UUID uuid, Path rootTablet) throws IOException {
        FileStatus fstat;
        String defaultMetadataTabletDir;
        String tableMetadataTabletDir;
        block12: {
            Initialize.initDirs(fs, uuid, VolumeConfiguration.getVolumeUris((AccumuloConfiguration)ServerConfiguration.getSiteConfiguration()), false);
            Path[] metadataTableDirs = Initialize.paths(ServerConstants.getMetadataTableDirs());
            tableMetadataTabletDir = fs.choose(VolumeConfiguration.prefix((String[])ServerConstants.getMetadataTableDirs(), (String)TABLE_TABLETS_TABLET_DIR));
            defaultMetadataTabletDir = fs.choose(VolumeConfiguration.prefix((String[])ServerConstants.getMetadataTableDirs(), (String)"/default_tablet"));
            Initialize.initMetadataConfig();
            for (Path mtd : metadataTableDirs) {
                try {
                    fstat = fs.getFileStatus(mtd);
                    if (fstat.isDir()) continue;
                    log.fatal((Object)("location " + mtd.toString() + " exists but is not a directory"));
                    return;
                }
                catch (FileNotFoundException fnfe) {
                    if (fs.mkdirs(mtd)) continue;
                    log.fatal((Object)("unable to create directory " + mtd.toString()));
                    return;
                }
            }
            try {
                fstat = fs.getFileStatus(rootTablet);
                if (!fstat.isDir()) {
                    log.fatal((Object)("location " + rootTablet.toString() + " exists but is not a directory"));
                    return;
                }
            }
            catch (FileNotFoundException fnfe) {
                if (fs.mkdirs(rootTablet)) break block12;
                log.fatal((Object)("unable to create directory " + rootTablet.toString()));
                return;
            }
        }
        String initRootTabFile = rootTablet + "/00000_00000." + FileOperations.getNewFileExtension((AccumuloConfiguration)AccumuloConfiguration.getDefaultConfiguration());
        FileSystem ns = fs.getVolumeByPath(new Path(initRootTabFile)).getFileSystem();
        FileSKVWriter mfw = FileOperations.getInstance().openWriter(initRootTabFile, ns, ns.getConf(), (AccumuloConfiguration)AccumuloConfiguration.getDefaultConfiguration());
        mfw.startDefaultLocalityGroup();
        Text tableExtent = new Text(KeyExtent.getMetadataEntry((Text)new Text("!0"), (Text)MetadataSchema.TabletsSection.getRange().getEndKey().getRow()));
        Key tableDirKey = new Key(tableExtent, MetadataSchema.TabletsSection.ServerColumnFamily.DIRECTORY_COLUMN.getColumnFamily(), MetadataSchema.TabletsSection.ServerColumnFamily.DIRECTORY_COLUMN.getColumnQualifier(), 0L);
        mfw.append(tableDirKey, new Value(tableMetadataTabletDir.getBytes(Constants.UTF8)));
        Key tableTimeKey = new Key(tableExtent, MetadataSchema.TabletsSection.ServerColumnFamily.TIME_COLUMN.getColumnFamily(), MetadataSchema.TabletsSection.ServerColumnFamily.TIME_COLUMN.getColumnQualifier(), 0L);
        mfw.append(tableTimeKey, new Value("L0".getBytes(Constants.UTF8)));
        Key tablePrevRowKey = new Key(tableExtent, MetadataSchema.TabletsSection.TabletColumnFamily.PREV_ROW_COLUMN.getColumnFamily(), MetadataSchema.TabletsSection.TabletColumnFamily.PREV_ROW_COLUMN.getColumnQualifier(), 0L);
        mfw.append(tablePrevRowKey, KeyExtent.encodePrevEndRow(null));
        Text defaultExtent = new Text(KeyExtent.getMetadataEntry((Text)new Text("!0"), null));
        Key defaultDirKey = new Key(defaultExtent, MetadataSchema.TabletsSection.ServerColumnFamily.DIRECTORY_COLUMN.getColumnFamily(), MetadataSchema.TabletsSection.ServerColumnFamily.DIRECTORY_COLUMN.getColumnQualifier(), 0L);
        mfw.append(defaultDirKey, new Value(defaultMetadataTabletDir.getBytes(Constants.UTF8)));
        Key defaultTimeKey = new Key(defaultExtent, MetadataSchema.TabletsSection.ServerColumnFamily.TIME_COLUMN.getColumnFamily(), MetadataSchema.TabletsSection.ServerColumnFamily.TIME_COLUMN.getColumnQualifier(), 0L);
        mfw.append(defaultTimeKey, new Value("L0".getBytes(Constants.UTF8)));
        Key defaultPrevRowKey = new Key(defaultExtent, MetadataSchema.TabletsSection.TabletColumnFamily.PREV_ROW_COLUMN.getColumnFamily(), MetadataSchema.TabletsSection.TabletColumnFamily.PREV_ROW_COLUMN.getColumnQualifier(), 0L);
        mfw.append(defaultPrevRowKey, KeyExtent.encodePrevEndRow((Text)MetadataSchema.TabletsSection.getRange().getEndKey().getRow()));
        mfw.close();
        for (String s : Arrays.asList(tableMetadataTabletDir, defaultMetadataTabletDir)) {
            Path dir = new Path(s);
            try {
                fstat = fs.getFileStatus(dir);
                if (fstat.isDir()) continue;
                log.fatal((Object)("location " + dir.toString() + " exists but is not a directory"));
                return;
            }
            catch (FileNotFoundException fnfe) {
                block13: {
                    try {
                        fstat = fs.getFileStatus(dir);
                        if (!fstat.isDir()) {
                            log.fatal((Object)("location " + dir.toString() + " exists but is not a directory"));
                            return;
                        }
                    }
                    catch (FileNotFoundException fnfe2) {
                        if (fs.mkdirs(dir)) break block13;
                        log.fatal((Object)("unable to create directory " + dir.toString()));
                        return;
                    }
                }
                if (fs.mkdirs(dir)) continue;
                log.fatal((Object)("unable to create directory " + dir.toString()));
                return;
            }
        }
    }

    private static void initZooKeeper(Opts opts, String uuid, String instanceNamePath, Path rootTablet) throws KeeperException, InterruptedException {
        ZooUtil.putPersistentData((ZooKeeper)zoo.getZooKeeper(), (String)"/accumulo", (byte[])new byte[0], (int)-1, (ZooUtil.NodeExistsPolicy)ZooUtil.NodeExistsPolicy.SKIP, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE);
        ZooUtil.putPersistentData((ZooKeeper)zoo.getZooKeeper(), (String)"/accumulo/instances", (byte[])new byte[0], (int)-1, (ZooUtil.NodeExistsPolicy)ZooUtil.NodeExistsPolicy.SKIP, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE);
        if (opts.clearInstanceName) {
            zoo.recursiveDelete(instanceNamePath, ZooUtil.NodeMissingPolicy.SKIP);
        }
        zoo.putPersistentData(instanceNamePath, uuid.getBytes(Constants.UTF8), ZooUtil.NodeExistsPolicy.FAIL);
        byte[] EMPTY_BYTE_ARRAY = new byte[]{};
        byte[] ZERO_CHAR_ARRAY = new byte[]{48};
        String zkInstanceRoot = "/accumulo/" + uuid;
        zoo.putPersistentData(zkInstanceRoot, EMPTY_BYTE_ARRAY, ZooUtil.NodeExistsPolicy.FAIL);
        zoo.putPersistentData(zkInstanceRoot + "/tables", Constants.ZTABLES_INITIAL_ID, ZooUtil.NodeExistsPolicy.FAIL);
        zoo.putPersistentData(zkInstanceRoot + "/namespaces", new byte[0], ZooUtil.NodeExistsPolicy.FAIL);
        TableManager.prepareNewNamespaceState(uuid, "+default", "", ZooUtil.NodeExistsPolicy.FAIL);
        TableManager.prepareNewNamespaceState(uuid, "+accumulo", "accumulo", ZooUtil.NodeExistsPolicy.FAIL);
        TableManager.prepareNewTableState(uuid, "+r", "+accumulo", "accumulo.root", TableState.ONLINE, ZooUtil.NodeExistsPolicy.FAIL);
        TableManager.prepareNewTableState(uuid, "!0", "+accumulo", "accumulo.metadata", TableState.ONLINE, ZooUtil.NodeExistsPolicy.FAIL);
        zoo.putPersistentData(zkInstanceRoot + "/tservers", EMPTY_BYTE_ARRAY, ZooUtil.NodeExistsPolicy.FAIL);
        zoo.putPersistentData(zkInstanceRoot + "/problems", EMPTY_BYTE_ARRAY, ZooUtil.NodeExistsPolicy.FAIL);
        zoo.putPersistentData(zkInstanceRoot + "/root_tablet", EMPTY_BYTE_ARRAY, ZooUtil.NodeExistsPolicy.FAIL);
        zoo.putPersistentData(zkInstanceRoot + "/root_tablet/walogs", EMPTY_BYTE_ARRAY, ZooUtil.NodeExistsPolicy.FAIL);
        zoo.putPersistentData(zkInstanceRoot + "/root_tablet/dir", rootTablet.toString().getBytes(), ZooUtil.NodeExistsPolicy.FAIL);
        zoo.putPersistentData(zkInstanceRoot + "/tracers", EMPTY_BYTE_ARRAY, ZooUtil.NodeExistsPolicy.FAIL);
        zoo.putPersistentData(zkInstanceRoot + "/masters", EMPTY_BYTE_ARRAY, ZooUtil.NodeExistsPolicy.FAIL);
        zoo.putPersistentData(zkInstanceRoot + "/masters/lock", EMPTY_BYTE_ARRAY, ZooUtil.NodeExistsPolicy.FAIL);
        zoo.putPersistentData(zkInstanceRoot + "/masters/goal_state", MasterGoalState.NORMAL.toString().getBytes(Constants.UTF8), ZooUtil.NodeExistsPolicy.FAIL);
        zoo.putPersistentData(zkInstanceRoot + "/gc", EMPTY_BYTE_ARRAY, ZooUtil.NodeExistsPolicy.FAIL);
        zoo.putPersistentData(zkInstanceRoot + "/gc/lock", EMPTY_BYTE_ARRAY, ZooUtil.NodeExistsPolicy.FAIL);
        zoo.putPersistentData(zkInstanceRoot + "/config", EMPTY_BYTE_ARRAY, ZooUtil.NodeExistsPolicy.FAIL);
        zoo.putPersistentData(zkInstanceRoot + "/table_locks", EMPTY_BYTE_ARRAY, ZooUtil.NodeExistsPolicy.FAIL);
        zoo.putPersistentData(zkInstanceRoot + "/hdfs_reservations", EMPTY_BYTE_ARRAY, ZooUtil.NodeExistsPolicy.FAIL);
        zoo.putPersistentData(zkInstanceRoot + "/next_file", ZERO_CHAR_ARRAY, ZooUtil.NodeExistsPolicy.FAIL);
        zoo.putPersistentData(zkInstanceRoot + "/recovery", ZERO_CHAR_ARRAY, ZooUtil.NodeExistsPolicy.FAIL);
        zoo.putPersistentData(zkInstanceRoot + "/monitor", EMPTY_BYTE_ARRAY, ZooUtil.NodeExistsPolicy.FAIL);
        zoo.putPersistentData(zkInstanceRoot + "/monitor/lock", EMPTY_BYTE_ARRAY, ZooUtil.NodeExistsPolicy.FAIL);
    }

    private static String getInstanceNamePath(Opts opts) throws IOException, KeeperException, InterruptedException {
        String instanceNamePath = null;
        boolean exists = true;
        do {
            String instanceName;
            if ((instanceName = opts.cliInstanceName == null ? Initialize.getConsoleReader().readLine("Instance name : ") : opts.cliInstanceName) == null) {
                System.exit(0);
            }
            if ((instanceName = instanceName.trim()).length() == 0) continue;
            instanceNamePath = "/accumulo/instances/" + instanceName;
            if (opts.clearInstanceName) {
                exists = false;
                break;
            }
            exists = zoo.exists(instanceNamePath);
            if (!exists) continue;
            String decision = Initialize.getConsoleReader().readLine("Instance name \"" + instanceName + "\" exists. Delete existing entry from zookeeper? [Y/N] : ");
            if (decision == null) {
                System.exit(0);
            }
            if (decision.length() != 1 || decision.toLowerCase(Locale.ENGLISH).charAt(0) != 'y') continue;
            opts.clearInstanceName = true;
            exists = false;
        } while (exists);
        return instanceNamePath;
    }

    private static byte[] getRootPassword(Opts opts) throws IOException {
        String confirmpass;
        String rootpass;
        if (opts.cliPassword != null) {
            return opts.cliPassword.getBytes(Constants.UTF8);
        }
        do {
            if ((rootpass = Initialize.getConsoleReader().readLine("Enter initial password for root (this may not be applicable for your security setup): ", Character.valueOf('*'))) == null) {
                System.exit(0);
            }
            if ((confirmpass = Initialize.getConsoleReader().readLine("Confirm initial password for root: ", Character.valueOf('*'))) == null) {
                System.exit(0);
            }
            if (rootpass.equals(confirmpass)) continue;
            log.error((Object)"Passwords do not match");
        } while (!rootpass.equals(confirmpass));
        return rootpass.getBytes(Constants.UTF8);
    }

    private static void initSecurity(Opts opts, String iid) throws AccumuloSecurityException, ThriftSecurityException {
        AuditedSecurityOperation.getInstance(iid, true).initializeSecurity(SystemCredentials.get().toThrift(HdfsZooInstance.getInstance()), DEFAULT_ROOT_USER, opts.rootpass);
    }

    public static void initMetadataConfig(String tableId) throws IOException {
        try {
            Configuration conf = CachedConfiguration.getInstance();
            int max = conf.getInt("dfs.replication.max", 512);
            int min = Math.max(conf.getInt("dfs.replication.min", 1), conf.getInt("dfs.namenode.replication.min", 1));
            if (max < 5) {
                Initialize.setMetadataReplication(max, "max");
            }
            if (min > 5) {
                Initialize.setMetadataReplication(min, "min");
            }
            for (Map.Entry<String, String> entry : initialMetadataConf.entrySet()) {
                if (!TablePropUtil.setTableProperty("+r", entry.getKey(), entry.getValue())) {
                    throw new IOException("Cannot create per-table property " + entry.getKey());
                }
                if (TablePropUtil.setTableProperty("!0", entry.getKey(), entry.getValue())) continue;
                throw new IOException("Cannot create per-table property " + entry.getKey());
            }
        }
        catch (Exception e) {
            log.fatal((Object)"error talking to zookeeper", (Throwable)e);
            throw new IOException(e);
        }
    }

    protected static void initMetadataConfig() throws IOException {
        Initialize.initMetadataConfig("+r");
        Initialize.initMetadataConfig("!0");
    }

    private static void setMetadataReplication(int replication, String reason) throws IOException {
        String rep = Initialize.getConsoleReader().readLine("Your HDFS replication " + reason + " is not compatible with our default " + "accumulo.metadata" + " replication of 5. What do you want to set your " + "accumulo.metadata" + " replication to? (" + replication + ") ");
        if (rep == null || rep.length() == 0) {
            rep = Integer.toString(replication);
        } else {
            Integer.parseInt(rep);
        }
        initialMetadataConf.put(Property.TABLE_FILE_REPLICATION.getKey(), rep);
    }

    public static boolean isInitialized(VolumeManager fs) throws IOException {
        for (String baseDir : VolumeConfiguration.getVolumeUris((AccumuloConfiguration)ServerConfiguration.getSiteConfiguration())) {
            if (!fs.exists(new Path(baseDir, "instance_id")) && !fs.exists(new Path(baseDir, "version"))) continue;
            return true;
        }
        return false;
    }

    private static void addVolumes(VolumeManager fs) throws IOException {
        HashSet<String> initializedDirs = new HashSet<String>();
        initializedDirs.addAll(Arrays.asList(ServerConstants.checkBaseUris(VolumeConfiguration.getVolumeUris((AccumuloConfiguration)ServerConfiguration.getSiteConfiguration()), true)));
        HashSet<String> uinitializedDirs = new HashSet<String>();
        uinitializedDirs.addAll(Arrays.asList(VolumeConfiguration.getVolumeUris((AccumuloConfiguration)ServerConfiguration.getSiteConfiguration())));
        uinitializedDirs.removeAll(initializedDirs);
        Path aBasePath = new Path((String)initializedDirs.iterator().next());
        Path iidPath = new Path(aBasePath, "instance_id");
        Path versionPath = new Path(aBasePath, "version");
        UUID uuid = UUID.fromString(ZooUtil.getInstanceIDFromHdfs((Path)iidPath, (AccumuloConfiguration)ServerConfiguration.getSiteConfiguration()));
        if (6 != Accumulo.getAccumuloPersistentVersion(versionPath.getFileSystem(CachedConfiguration.getInstance()), versionPath)) {
            throw new IOException("Accumulo 1.6.0 cannot initialize data version " + Accumulo.getAccumuloPersistentVersion(fs));
        }
        Initialize.initDirs(fs, uuid, uinitializedDirs.toArray(new String[uinitializedDirs.size()]), true);
    }

    public static void main(String[] args) {
        Opts opts = new Opts();
        opts.parseArgs(Initialize.class.getName(), args, new Object[0]);
        try {
            SiteConfiguration acuConf = ServerConfiguration.getSiteConfiguration();
            SecurityUtil.serverLogin((AccumuloConfiguration)acuConf);
            Configuration conf = CachedConfiguration.getInstance();
            VolumeManager fs = VolumeManagerImpl.get((AccumuloConfiguration)acuConf);
            if (opts.resetSecurity) {
                if (Initialize.isInitialized(fs)) {
                    opts.rootpass = Initialize.getRootPassword(opts);
                    Initialize.initSecurity(opts, HdfsZooInstance.getInstance().getInstanceID());
                } else {
                    log.fatal((Object)"Attempted to reset security on accumulo before it was initialized");
                }
            }
            if (opts.addVolumes) {
                Initialize.addVolumes(fs);
            }
            if (!(opts.resetSecurity || opts.addVolumes || Initialize.doInit(opts, conf, fs))) {
                System.exit(-1);
            }
        }
        catch (Exception e) {
            log.fatal((Object)e, (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    static {
        initialMetadataConf.put(Property.TABLE_FILE_COMPRESSED_BLOCK_SIZE.getKey(), "32K");
        initialMetadataConf.put(Property.TABLE_FILE_REPLICATION.getKey(), "5");
        initialMetadataConf.put(Property.TABLE_WALOG_ENABLED.getKey(), "true");
        initialMetadataConf.put(Property.TABLE_MAJC_RATIO.getKey(), "1");
        initialMetadataConf.put(Property.TABLE_SPLIT_THRESHOLD.getKey(), "64M");
        initialMetadataConf.put(Property.TABLE_CONSTRAINT_PREFIX.getKey() + "1", MetadataConstraints.class.getName());
        initialMetadataConf.put(Property.TABLE_ITERATOR_PREFIX.getKey() + "scan.vers", "10," + VersioningIterator.class.getName());
        initialMetadataConf.put(Property.TABLE_ITERATOR_PREFIX.getKey() + "scan.vers.opt.maxVersions", "1");
        initialMetadataConf.put(Property.TABLE_ITERATOR_PREFIX.getKey() + "minc.vers", "10," + VersioningIterator.class.getName());
        initialMetadataConf.put(Property.TABLE_ITERATOR_PREFIX.getKey() + "minc.vers.opt.maxVersions", "1");
        initialMetadataConf.put(Property.TABLE_ITERATOR_PREFIX.getKey() + "majc.vers", "10," + VersioningIterator.class.getName());
        initialMetadataConf.put(Property.TABLE_ITERATOR_PREFIX.getKey() + "majc.vers.opt.maxVersions", "1");
        initialMetadataConf.put(Property.TABLE_ITERATOR_PREFIX.getKey() + "majc.bulkLoadFilter", "20," + MetadataBulkLoadFilter.class.getName());
        initialMetadataConf.put(Property.TABLE_FAILURES_IGNORE.getKey(), "false");
        initialMetadataConf.put(Property.TABLE_LOCALITY_GROUP_PREFIX.getKey() + "tablet", String.format("%s,%s", MetadataSchema.TabletsSection.TabletColumnFamily.NAME, MetadataSchema.TabletsSection.CurrentLocationColumnFamily.NAME));
        initialMetadataConf.put(Property.TABLE_LOCALITY_GROUP_PREFIX.getKey() + "server", String.format("%s,%s,%s,%s", MetadataSchema.TabletsSection.DataFileColumnFamily.NAME, MetadataSchema.TabletsSection.LogColumnFamily.NAME, MetadataSchema.TabletsSection.ServerColumnFamily.NAME, MetadataSchema.TabletsSection.FutureLocationColumnFamily.NAME));
        initialMetadataConf.put(Property.TABLE_LOCALITY_GROUPS.getKey(), "tablet,server");
        initialMetadataConf.put(Property.TABLE_DEFAULT_SCANTIME_VISIBILITY.getKey(), "");
        initialMetadataConf.put(Property.TABLE_INDEXCACHE_ENABLED.getKey(), "true");
        initialMetadataConf.put(Property.TABLE_BLOCKCACHE_ENABLED.getKey(), "true");
    }

    static class Opts
    extends Help {
        @Parameter(names={"--add-volumes"}, description="Initialize any uninitialized volumes listed in instance.volumes")
        boolean addVolumes = false;
        @Parameter(names={"--reset-security"}, description="just update the security information")
        boolean resetSecurity = false;
        @Parameter(names={"--clear-instance-name"}, description="delete any existing instance name without prompting")
        boolean clearInstanceName = false;
        @Parameter(names={"--instance-name"}, description="the instance name, if not provided, will prompt")
        String cliInstanceName;
        @Parameter(names={"--password"}, description="set the password on the command line")
        String cliPassword;
        byte[] rootpass = null;

        Opts() {
        }
    }
}

