/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.iterators;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.Filter;
import org.apache.accumulo.core.iterators.IteratorEnvironment;
import org.apache.accumulo.core.iterators.IteratorUtil;
import org.apache.accumulo.core.iterators.SortedKeyValueIterator;
import org.apache.accumulo.core.metadata.schema.MetadataSchema;
import org.apache.accumulo.fate.zookeeper.TransactionWatcher;
import org.apache.accumulo.server.zookeeper.TransactionWatcher;
import org.apache.log4j.Logger;

public class MetadataBulkLoadFilter
extends Filter {
    private static Logger log = Logger.getLogger(MetadataBulkLoadFilter.class);
    Map<Long, Status> bulkTxStatusCache;
    TransactionWatcher.Arbitrator arbitrator;

    public boolean accept(Key k, Value v) {
        if (!k.isDeleted() && k.compareColumnFamily(MetadataSchema.TabletsSection.BulkFileColumnFamily.NAME) == 0) {
            long txid = Long.valueOf(v.toString());
            Status status = this.bulkTxStatusCache.get(txid);
            if (status == null) {
                try {
                    status = this.arbitrator.transactionComplete("bulkTx", txid) ? Status.INACTIVE : Status.ACTIVE;
                }
                catch (Exception e) {
                    status = Status.ACTIVE;
                    log.error((Object)e, (Throwable)e);
                }
                this.bulkTxStatusCache.put(txid, status);
            }
            return status == Status.ACTIVE;
        }
        return true;
    }

    public void init(SortedKeyValueIterator<Key, Value> source, Map<String, String> options, IteratorEnvironment env) throws IOException {
        super.init(source, options, env);
        if (env.getIteratorScope() == IteratorUtil.IteratorScope.scan) {
            throw new IOException("This iterator not intended for use at scan time");
        }
        this.bulkTxStatusCache = new HashMap<Long, Status>();
        this.arbitrator = this.getArbitrator();
    }

    protected TransactionWatcher.Arbitrator getArbitrator() {
        return new TransactionWatcher.ZooArbitrator();
    }

    static enum Status {
        ACTIVE,
        INACTIVE;

    }
}

