/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.master.balancer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import org.apache.accumulo.core.data.KeyExtent;
import org.apache.accumulo.core.master.thrift.TableInfo;
import org.apache.accumulo.core.master.thrift.TabletServerStatus;
import org.apache.accumulo.core.tabletserver.thrift.TabletStats;
import org.apache.accumulo.server.master.balancer.TabletBalancer;
import org.apache.accumulo.server.master.state.TServerInstance;
import org.apache.accumulo.server.master.state.TabletMigration;
import org.apache.log4j.Logger;

public class DefaultLoadBalancer
extends TabletBalancer {
    private static final Logger log = Logger.getLogger(DefaultLoadBalancer.class);
    Iterator<TServerInstance> assignments;
    String tableToBalance = null;

    public DefaultLoadBalancer() {
    }

    public DefaultLoadBalancer(String table) {
        this.tableToBalance = table;
    }

    List<TServerInstance> randomize(Set<TServerInstance> locations) {
        ArrayList<TServerInstance> result = new ArrayList<TServerInstance>(locations);
        Collections.shuffle(result);
        return result;
    }

    public TServerInstance getAssignment(SortedMap<TServerInstance, TabletServerStatus> locations, KeyExtent extent, TServerInstance last) {
        TServerInstance result;
        if (locations.size() == 0) {
            return null;
        }
        if (last != null) {
            TServerInstance current;
            String fakeSessionID = " ";
            TServerInstance simple = new TServerInstance(last.getLocation(), fakeSessionID);
            Iterator<TServerInstance> find = locations.tailMap(simple).keySet().iterator();
            if (find.hasNext() && (current = find.next()).host().equals(last.host())) {
                return current;
            }
        }
        if (this.assignments == null || !this.assignments.hasNext()) {
            this.assignments = this.randomize(locations.keySet()).iterator();
        }
        if (!locations.containsKey(result = this.assignments.next())) {
            this.assignments = null;
            return this.randomize(locations.keySet()).iterator().next();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getMigrations(Map<TServerInstance, TabletServerStatus> current, List<TabletMigration> result) {
        boolean moreBalancingNeeded = false;
        try {
            if (current.size() < 2) {
                boolean bl = false;
                return bl;
            }
            int total = 0;
            ArrayList<ServerCounts> totals = new ArrayList<ServerCounts>();
            for (Map.Entry<TServerInstance, TabletServerStatus> entry : current.entrySet()) {
                int serverTotal = 0;
                if (entry.getValue() != null && entry.getValue().tableMap != null) {
                    for (Map.Entry e : entry.getValue().tableMap.entrySet()) {
                        if (this.tableToBalance != null && !this.tableToBalance.equals(e.getKey())) continue;
                        serverTotal += ((TableInfo)e.getValue()).onlineTablets;
                    }
                }
                totals.add(new ServerCounts(serverTotal, entry.getKey(), entry.getValue()));
                total += serverTotal;
            }
            Collections.sort(totals);
            Collections.reverse(totals);
            int even = total / totals.size();
            int numServersOverEven = total % totals.size();
            int end = totals.size() - 1;
            int movedAlready = 0;
            for (int tooManyIndex = 0; tooManyIndex < totals.size(); ++tooManyIndex) {
                ServerCounts tooMany = (ServerCounts)totals.get(tooManyIndex);
                int goal = even;
                if (tooManyIndex < numServersOverEven) {
                    ++goal;
                }
                int needToUnload = tooMany.count - goal;
                ServerCounts tooLittle = (ServerCounts)totals.get(end);
                int needToLoad = goal - tooLittle.count - movedAlready;
                if (needToUnload < 1 && needToLoad < 1) {
                    break;
                }
                if (needToUnload >= needToLoad) {
                    result.addAll(this.move(tooMany, tooLittle, needToLoad));
                    --end;
                    movedAlready = 0;
                } else {
                    result.addAll(this.move(tooMany, tooLittle, needToUnload));
                    movedAlready += needToUnload;
                }
                if (needToUnload <= needToLoad) continue;
                moreBalancingNeeded = true;
            }
        }
        finally {
            log.debug((Object)("balance ended with " + result.size() + " migrations"));
        }
        return moreBalancingNeeded;
    }

    List<TabletMigration> move(ServerCounts tooMuch, ServerCounts tooLittle, int count) {
        ArrayList<TabletMigration> result = new ArrayList<TabletMigration>();
        if (count == 0) {
            return result;
        }
        HashMap<String, HashMap<KeyExtent, TabletStats>> onlineTablets = new HashMap<String, HashMap<KeyExtent, TabletStats>>();
        Map<String, Integer> tooMuchMap = DefaultLoadBalancer.tabletCountsPerTable(tooMuch.status);
        Map<String, Integer> tooLittleMap = DefaultLoadBalancer.tabletCountsPerTable(tooLittle.status);
        for (int i = 0; i < count; ++i) {
            String table;
            if (this.tableToBalance == null) {
                int biggestDifference = 0;
                String biggestDifferenceTable = null;
                for (Map.Entry<String, Integer> tableEntry : tooMuchMap.entrySet()) {
                    int diff;
                    String tableID = tableEntry.getKey();
                    if (tooLittleMap.get(tableID) == null) {
                        tooLittleMap.put(tableID, 0);
                    }
                    if ((diff = tableEntry.getValue() - tooLittleMap.get(tableID)) <= biggestDifference) continue;
                    biggestDifference = diff;
                    biggestDifferenceTable = tableID;
                }
                table = biggestDifference < 2 ? DefaultLoadBalancer.busiest(tooMuch.status.tableMap) : biggestDifferenceTable;
            } else {
                table = this.tableToBalance;
            }
            HashMap<KeyExtent, TabletStats> onlineTabletsForTable = (HashMap<KeyExtent, TabletStats>)onlineTablets.get(table);
            try {
                if (onlineTabletsForTable == null) {
                    onlineTabletsForTable = new HashMap<KeyExtent, TabletStats>();
                    for (TabletStats stat : this.getOnlineTabletsForTable(tooMuch.server, table)) {
                        onlineTabletsForTable.put(new KeyExtent(stat.extent), stat);
                    }
                    onlineTablets.put(table, onlineTabletsForTable);
                }
            }
            catch (Exception ex) {
                log.error((Object)"Unable to select a tablet to move", (Throwable)ex);
                return result;
            }
            KeyExtent extent = DefaultLoadBalancer.selectTablet(tooMuch.server, onlineTabletsForTable);
            onlineTabletsForTable.remove(extent);
            if (extent == null) {
                return result;
            }
            tooMuchMap.put(table, tooMuchMap.get(table) - 1);
            Integer tooLittleCount = tooLittleMap.get(table);
            if (tooLittleCount == null) {
                tooLittleCount = 0;
            }
            tooLittleMap.put(table, tooLittleCount + 1);
            result.add(new TabletMigration(extent, tooMuch.server, tooLittle.server));
        }
        return result;
    }

    static Map<String, Integer> tabletCountsPerTable(TabletServerStatus status) {
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        if (status != null && status.tableMap != null) {
            Map tableMap = status.tableMap;
            for (Map.Entry entry : tableMap.entrySet()) {
                result.put((String)entry.getKey(), ((TableInfo)entry.getValue()).onlineTablets);
            }
        }
        return result;
    }

    static KeyExtent selectTablet(TServerInstance tserver, Map<KeyExtent, TabletStats> extents) {
        if (extents.size() == 0) {
            return null;
        }
        KeyExtent mostRecentlySplit = null;
        long splitTime = 0L;
        for (Map.Entry<KeyExtent, TabletStats> entry : extents.entrySet()) {
            if (entry.getValue().splitCreationTime < splitTime) continue;
            splitTime = entry.getValue().splitCreationTime;
            mostRecentlySplit = entry.getKey();
        }
        return mostRecentlySplit;
    }

    private static String busiest(Map<String, TableInfo> tables) {
        String result = null;
        double busiest = Double.NEGATIVE_INFINITY;
        for (Map.Entry<String, TableInfo> entry : tables.entrySet()) {
            TableInfo info = entry.getValue();
            double busy = info.ingestRate + info.queryRate;
            if (!(busy > busiest)) continue;
            busiest = busy;
            result = entry.getKey();
        }
        return result;
    }

    @Override
    public void getAssignments(SortedMap<TServerInstance, TabletServerStatus> current, Map<KeyExtent, TServerInstance> unassigned, Map<KeyExtent, TServerInstance> assignments) {
        for (Map.Entry<KeyExtent, TServerInstance> entry : unassigned.entrySet()) {
            assignments.put(entry.getKey(), this.getAssignment(current, entry.getKey(), entry.getValue()));
        }
    }

    @Override
    public long balance(SortedMap<TServerInstance, TabletServerStatus> current, Set<KeyExtent> migrations, List<TabletMigration> migrationsOut) {
        if (current.size() > 0 && migrations.size() == 0 && this.getMigrations(current, migrationsOut)) {
            return 1000L;
        }
        return 5000L;
    }

    static class TableDiff {
        int diff;
        String table;

        public TableDiff(int diff, String table) {
            this.diff = diff;
            this.table = table;
        }
    }

    static class ServerCounts
    implements Comparable<ServerCounts> {
        public final TServerInstance server;
        public final int count;
        public final TabletServerStatus status;

        ServerCounts(int count, TServerInstance server, TabletServerStatus status) {
            this.count = count;
            this.server = server;
            this.status = status;
        }

        @Override
        public int compareTo(ServerCounts obj) {
            int result = this.count - obj.count;
            if (result == 0) {
                return this.server.compareTo(obj.server);
            }
            return result;
        }
    }
}

