/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.master.balancer;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.admin.TableOperations;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.KeyExtent;
import org.apache.accumulo.core.master.state.tables.TableState;
import org.apache.accumulo.core.master.thrift.TabletServerStatus;
import org.apache.accumulo.server.master.balancer.DefaultLoadBalancer;
import org.apache.accumulo.server.master.balancer.TabletBalancer;
import org.apache.accumulo.server.master.state.TServerInstance;
import org.apache.accumulo.server.master.state.TabletMigration;
import org.apache.accumulo.server.security.SystemCredentials;
import org.apache.accumulo.server.tables.TableManager;
import org.apache.accumulo.start.classloader.vfs.AccumuloVFSClassLoader;
import org.apache.log4j.Logger;

public class TableLoadBalancer
extends TabletBalancer {
    private static final Logger log = Logger.getLogger(TableLoadBalancer.class);
    Map<String, TabletBalancer> perTableBalancers = new HashMap<String, TabletBalancer>();
    private TableOperations tops = null;

    private TabletBalancer constructNewBalancerForTable(String clazzName, String table) throws Exception {
        Class clazz = AccumuloVFSClassLoader.loadClass((String)clazzName, TabletBalancer.class);
        Constructor constructor = clazz.getConstructor(String.class);
        return (TabletBalancer)constructor.newInstance(table);
    }

    protected String getLoadBalancerClassNameForTable(String table) {
        TableState tableState = TableManager.getInstance().getTableState(table);
        if (tableState == null) {
            return null;
        }
        if (tableState.equals((Object)TableState.ONLINE)) {
            return this.configuration.getTableConfiguration(table).get(Property.TABLE_LOAD_BALANCER);
        }
        return null;
    }

    protected TabletBalancer getBalancerForTable(String table) {
        TabletBalancer balancer = this.perTableBalancers.get(table);
        String clazzName = this.getLoadBalancerClassNameForTable(table);
        if (clazzName == null) {
            clazzName = DefaultLoadBalancer.class.getName();
        }
        if (balancer != null && !clazzName.equals(balancer.getClass().getName())) {
            try {
                TabletBalancer newBalancer = this.constructNewBalancerForTable(clazzName, table);
                if (newBalancer != null) {
                    balancer = newBalancer;
                    this.perTableBalancers.put(table, balancer);
                    balancer.init(this.configuration);
                }
            }
            catch (Exception e) {
                log.warn((Object)("Failed to load table balancer class " + clazzName + " for table " + table), (Throwable)e);
            }
        }
        if (balancer == null) {
            try {
                balancer = this.constructNewBalancerForTable(clazzName, table);
                log.info((Object)("Loaded class " + clazzName + " for table " + table));
            }
            catch (Exception e) {
                log.warn((Object)("Failed to load table balancer class " + clazzName + " for table " + table), (Throwable)e);
            }
            if (balancer == null) {
                log.info((Object)("Using balancer " + DefaultLoadBalancer.class.getName() + " for table " + table));
                balancer = new DefaultLoadBalancer(table);
            }
            this.perTableBalancers.put(table, balancer);
            balancer.init(this.configuration);
        }
        return balancer;
    }

    @Override
    public void getAssignments(SortedMap<TServerInstance, TabletServerStatus> current, Map<KeyExtent, TServerInstance> unassigned, Map<KeyExtent, TServerInstance> assignments) {
        HashMap<String, HashMap<KeyExtent, TServerInstance>> groupedUnassigned = new HashMap<String, HashMap<KeyExtent, TServerInstance>>();
        for (Map.Entry<KeyExtent, TServerInstance> entry : unassigned.entrySet()) {
            HashMap<KeyExtent, TServerInstance> tableUnassigned = (HashMap<KeyExtent, TServerInstance>)groupedUnassigned.get(entry.getKey().getTableId().toString());
            if (tableUnassigned == null) {
                tableUnassigned = new HashMap<KeyExtent, TServerInstance>();
                groupedUnassigned.put(entry.getKey().getTableId().toString(), tableUnassigned);
            }
            tableUnassigned.put(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<Object, TServerInstance> entry : groupedUnassigned.entrySet()) {
            HashMap<KeyExtent, TServerInstance> newAssignments = new HashMap<KeyExtent, TServerInstance>();
            this.getBalancerForTable((String)entry.getKey()).getAssignments(current, (Map)((Object)entry.getValue()), newAssignments);
            assignments.putAll(newAssignments);
        }
    }

    protected TableOperations getTableOperations() {
        if (this.tops == null) {
            try {
                this.tops = this.configuration.getInstance().getConnector(SystemCredentials.get().getPrincipal(), SystemCredentials.get().getToken()).tableOperations();
            }
            catch (AccumuloException e) {
                log.error((Object)"Unable to access table operations from within table balancer", (Throwable)e);
            }
            catch (AccumuloSecurityException e) {
                log.error((Object)"Unable to access table operations from within table balancer", (Throwable)e);
            }
        }
        return this.tops;
    }

    @Override
    public long balance(SortedMap<TServerInstance, TabletServerStatus> current, Set<KeyExtent> migrations, List<TabletMigration> migrationsOut) {
        long minBalanceTime = 5000L;
        TableOperations t = this.getTableOperations();
        if (t == null) {
            return minBalanceTime;
        }
        for (String s : t.tableIdMap().values()) {
            ArrayList<TabletMigration> newMigrations = new ArrayList<TabletMigration>();
            long tableBalanceTime = this.getBalancerForTable(s).balance(current, migrations, newMigrations);
            if (tableBalanceTime < minBalanceTime) {
                minBalanceTime = tableBalanceTime;
            }
            migrationsOut.addAll(newMigrations);
        }
        return minBalanceTime;
    }
}

