/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.master.state;

import java.util.ArrayList;
import java.util.List;
import org.apache.accumulo.core.Constants;
import org.apache.accumulo.core.master.thrift.DeadServer;
import org.apache.accumulo.fate.zookeeper.ZooUtil;
import org.apache.accumulo.server.zookeeper.ZooReaderWriter;
import org.apache.log4j.Logger;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.data.Stat;

public class DeadServerList {
    private static final Logger log = Logger.getLogger(DeadServerList.class);
    private final String path;

    public DeadServerList(String path) {
        this.path = path;
        ZooReaderWriter zoo = ZooReaderWriter.getInstance();
        try {
            zoo.mkdirs(path);
        }
        catch (Exception ex) {
            log.error((Object)("Unable to make parent directories of " + path), (Throwable)ex);
        }
    }

    public List<DeadServer> getList() {
        ArrayList<DeadServer> result;
        block5: {
            result = new ArrayList<DeadServer>();
            ZooReaderWriter zoo = ZooReaderWriter.getInstance();
            try {
                List children = zoo.getChildren(this.path);
                if (children == null) break block5;
                for (String child : children) {
                    byte[] data;
                    Stat stat = new Stat();
                    try {
                        data = zoo.getData(this.path + "/" + child, stat);
                    }
                    catch (KeeperException.NoNodeException nne) {
                        continue;
                    }
                    DeadServer server = new DeadServer(child, stat.getMtime(), new String(data, Constants.UTF8));
                    result.add(server);
                }
            }
            catch (Exception ex) {
                log.error((Object)ex, (Throwable)ex);
            }
        }
        return result;
    }

    public void delete(String server) {
        ZooReaderWriter zoo = ZooReaderWriter.getInstance();
        try {
            zoo.recursiveDelete(this.path + "/" + server, ZooUtil.NodeMissingPolicy.SKIP);
        }
        catch (Exception ex) {
            log.error((Object)ex, (Throwable)ex);
        }
    }

    public void post(String server, String cause) {
        ZooReaderWriter zoo = ZooReaderWriter.getInstance();
        try {
            zoo.putPersistentData(this.path + "/" + server, cause.getBytes(Constants.UTF8), ZooUtil.NodeExistsPolicy.SKIP);
        }
        catch (Exception ex) {
            log.error((Object)ex, (Throwable)ex);
        }
    }
}

