/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.master.state;

import java.util.Collection;
import java.util.concurrent.TimeUnit;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.BatchWriterConfig;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.client.MutationsRejectedException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.metadata.schema.MetadataSchema;
import org.apache.accumulo.core.security.Credentials;
import org.apache.accumulo.server.client.HdfsZooInstance;
import org.apache.accumulo.server.master.state.Assignment;
import org.apache.accumulo.server.master.state.ClosableIterator;
import org.apache.accumulo.server.master.state.CurrentState;
import org.apache.accumulo.server.master.state.DistributedStoreException;
import org.apache.accumulo.server.master.state.MetaDataTableScanner;
import org.apache.accumulo.server.master.state.TabletLocationState;
import org.apache.accumulo.server.master.state.TabletStateStore;
import org.apache.accumulo.server.security.SystemCredentials;
import org.apache.hadoop.io.Text;

public class MetaDataStateStore
extends TabletStateStore {
    private static final int THREADS = 4;
    private static final int LATENCY = 1000;
    private static final int MAX_MEMORY = 0xC800000;
    protected final Instance instance;
    protected final CurrentState state;
    protected final Credentials credentials;
    private final String targetTableName;

    protected MetaDataStateStore(Instance instance, Credentials credentials, CurrentState state, String targetTableName) {
        this.instance = instance;
        this.state = state;
        this.credentials = credentials;
        this.targetTableName = targetTableName;
    }

    public MetaDataStateStore(Instance instance, Credentials credentials, CurrentState state) {
        this(instance, credentials, state, "accumulo.metadata");
    }

    protected MetaDataStateStore(String tableName) {
        this(HdfsZooInstance.getInstance(), SystemCredentials.get(), null, tableName);
    }

    public MetaDataStateStore() {
        this("accumulo.metadata");
    }

    @Override
    public ClosableIterator<TabletLocationState> iterator() {
        return new MetaDataTableScanner(this.instance, this.credentials, MetadataSchema.TabletsSection.getRange(), this.state);
    }

    @Override
    public void setLocations(Collection<Assignment> assignments) throws DistributedStoreException {
        BatchWriter writer = this.createBatchWriter();
        try {
            for (Assignment assignment : assignments) {
                Mutation m = new Mutation(assignment.tablet.getMetadataEntry());
                Text cq = assignment.server.asColumnQualifier();
                m.put(MetadataSchema.TabletsSection.CurrentLocationColumnFamily.NAME, cq, assignment.server.asMutationValue());
                m.putDelete(MetadataSchema.TabletsSection.FutureLocationColumnFamily.NAME, cq);
                writer.addMutation(m);
            }
        }
        catch (Exception ex) {
            throw new DistributedStoreException(ex);
        }
        finally {
            try {
                writer.close();
            }
            catch (MutationsRejectedException e) {
                throw new DistributedStoreException((Exception)((Object)e));
            }
        }
    }

    BatchWriter createBatchWriter() {
        try {
            return this.instance.getConnector(this.credentials.getPrincipal(), this.credentials.getToken()).createBatchWriter(this.targetTableName, new BatchWriterConfig().setMaxMemory(0xC800000L).setMaxLatency(1000L, TimeUnit.MILLISECONDS).setMaxWriteThreads(4));
        }
        catch (TableNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void setFutureLocations(Collection<Assignment> assignments) throws DistributedStoreException {
        BatchWriter writer = this.createBatchWriter();
        try {
            for (Assignment assignment : assignments) {
                Mutation m = new Mutation(assignment.tablet.getMetadataEntry());
                m.put(MetadataSchema.TabletsSection.FutureLocationColumnFamily.NAME, assignment.server.asColumnQualifier(), assignment.server.asMutationValue());
                writer.addMutation(m);
            }
        }
        catch (Exception ex) {
            throw new DistributedStoreException(ex);
        }
        finally {
            try {
                writer.close();
            }
            catch (MutationsRejectedException e) {
                throw new DistributedStoreException((Exception)((Object)e));
            }
        }
    }

    @Override
    public void unassign(Collection<TabletLocationState> tablets) throws DistributedStoreException {
        BatchWriter writer = this.createBatchWriter();
        try {
            for (TabletLocationState tls : tablets) {
                Mutation m = new Mutation(tls.extent.getMetadataEntry());
                if (tls.current != null) {
                    m.putDelete(MetadataSchema.TabletsSection.CurrentLocationColumnFamily.NAME, tls.current.asColumnQualifier());
                }
                if (tls.future != null) {
                    m.putDelete(MetadataSchema.TabletsSection.FutureLocationColumnFamily.NAME, tls.future.asColumnQualifier());
                }
                writer.addMutation(m);
            }
        }
        catch (Exception ex) {
            throw new DistributedStoreException(ex);
        }
        finally {
            try {
                writer.close();
            }
            catch (MutationsRejectedException e) {
                throw new DistributedStoreException((Exception)((Object)e));
            }
        }
    }

    @Override
    public String name() {
        return "Normal Tablets";
    }
}

