/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.master.state;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import org.apache.accumulo.core.client.BatchScanner;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.client.ScannerBase;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.KeyExtent;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.user.WholeRowIterator;
import org.apache.accumulo.core.metadata.schema.MetadataSchema;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.security.Credentials;
import org.apache.accumulo.server.master.state.ClosableIterator;
import org.apache.accumulo.server.master.state.CurrentState;
import org.apache.accumulo.server.master.state.TServerInstance;
import org.apache.accumulo.server.master.state.TabletLocationState;
import org.apache.accumulo.server.master.state.TabletStateChangeIterator;
import org.apache.hadoop.io.BinaryComparable;
import org.apache.hadoop.io.Text;
import org.apache.log4j.Logger;

public class MetaDataTableScanner
implements ClosableIterator<TabletLocationState> {
    private static final Logger log = Logger.getLogger(MetaDataTableScanner.class);
    BatchScanner mdScanner = null;
    Iterator<Map.Entry<Key, Value>> iter = null;

    public MetaDataTableScanner(Instance instance, Credentials credentials, Range range, CurrentState state) {
        this(instance, credentials, range, state, "accumulo.metadata");
    }

    MetaDataTableScanner(Instance instance, Credentials credentials, Range range, CurrentState state, String tableName) {
        try {
            Connector connector = instance.getConnector(credentials.getPrincipal(), credentials.getToken());
            this.mdScanner = connector.createBatchScanner(tableName, Authorizations.EMPTY, 8);
            MetaDataTableScanner.configureScanner((ScannerBase)this.mdScanner, state);
            this.mdScanner.setRanges(Collections.singletonList(range));
            this.iter = this.mdScanner.iterator();
        }
        catch (Exception ex) {
            if (this.mdScanner != null) {
                this.mdScanner.close();
            }
            this.iter = null;
            this.mdScanner = null;
            throw new RuntimeException(ex);
        }
    }

    public static void configureScanner(ScannerBase scanner, CurrentState state) {
        MetadataSchema.TabletsSection.TabletColumnFamily.PREV_ROW_COLUMN.fetch(scanner);
        scanner.fetchColumnFamily(MetadataSchema.TabletsSection.CurrentLocationColumnFamily.NAME);
        scanner.fetchColumnFamily(MetadataSchema.TabletsSection.FutureLocationColumnFamily.NAME);
        scanner.fetchColumnFamily(MetadataSchema.TabletsSection.LastLocationColumnFamily.NAME);
        scanner.fetchColumnFamily(MetadataSchema.TabletsSection.LogColumnFamily.NAME);
        scanner.fetchColumnFamily(MetadataSchema.TabletsSection.ChoppedColumnFamily.NAME);
        scanner.addScanIterator(new IteratorSetting(1000, "wholeRows", WholeRowIterator.class));
        IteratorSetting tabletChange = new IteratorSetting(1001, "tabletChange", TabletStateChangeIterator.class);
        if (state != null) {
            TabletStateChangeIterator.setCurrentServers(tabletChange, state.onlineTabletServers());
            TabletStateChangeIterator.setOnlineTables(tabletChange, state.onlineTables());
            TabletStateChangeIterator.setMerges(tabletChange, state.merges());
        }
        scanner.addScanIterator(tabletChange);
    }

    public MetaDataTableScanner(Instance instance, Credentials credentials, Range range) {
        this(instance, credentials, range, "accumulo.metadata");
    }

    public MetaDataTableScanner(Instance instance, Credentials credentials, Range range, String tableName) {
        this(instance, credentials, range, null, tableName);
    }

    @Override
    public void close() {
        if (this.iter != null) {
            this.mdScanner.close();
            this.iter = null;
        }
    }

    protected void finalize() {
        this.close();
    }

    @Override
    public boolean hasNext() {
        if (this.iter == null) {
            return false;
        }
        boolean result = this.iter.hasNext();
        if (!result) {
            this.close();
        }
        return result;
    }

    @Override
    public TabletLocationState next() {
        return this.fetch();
    }

    public static TabletLocationState createTabletLocationState(Key k, Value v) throws IOException, TabletLocationState.BadLocationStateException {
        SortedMap decodedRow = WholeRowIterator.decodeRow((Key)k, (Value)v);
        KeyExtent extent = null;
        TServerInstance future = null;
        TServerInstance current = null;
        TServerInstance last = null;
        long lastTimestamp = 0L;
        ArrayList<Collection<String>> walogs = new ArrayList<Collection<String>>();
        boolean chopped = false;
        for (Map.Entry entry : decodedRow.entrySet()) {
            TServerInstance location;
            Key key = (Key)entry.getKey();
            Text row = key.getRow();
            Text cf = key.getColumnFamily();
            Text cq = key.getColumnQualifier();
            if (cf.compareTo((BinaryComparable)MetadataSchema.TabletsSection.FutureLocationColumnFamily.NAME) == 0) {
                location = new TServerInstance((Value)entry.getValue(), cq);
                if (future != null) {
                    throw new TabletLocationState.BadLocationStateException("found two assignments for the same extent " + key.getRow() + ": " + future + " and " + location, ((Key)entry.getKey()).getRow());
                }
                future = location;
                continue;
            }
            if (cf.compareTo((BinaryComparable)MetadataSchema.TabletsSection.CurrentLocationColumnFamily.NAME) == 0) {
                location = new TServerInstance((Value)entry.getValue(), cq);
                if (current != null) {
                    throw new TabletLocationState.BadLocationStateException("found two locations for the same extent " + key.getRow() + ": " + current + " and " + location, ((Key)entry.getKey()).getRow());
                }
                current = location;
                continue;
            }
            if (cf.compareTo((BinaryComparable)MetadataSchema.TabletsSection.LogColumnFamily.NAME) == 0) {
                String[] split = ((Value)entry.getValue()).toString().split("\\|")[0].split(";");
                walogs.add(Arrays.asList(split));
                continue;
            }
            if (cf.compareTo((BinaryComparable)MetadataSchema.TabletsSection.LastLocationColumnFamily.NAME) == 0) {
                if (lastTimestamp >= ((Key)entry.getKey()).getTimestamp()) continue;
                last = new TServerInstance((Value)entry.getValue(), cq);
                continue;
            }
            if (cf.compareTo((BinaryComparable)MetadataSchema.TabletsSection.ChoppedColumnFamily.NAME) == 0) {
                chopped = true;
                continue;
            }
            if (!MetadataSchema.TabletsSection.TabletColumnFamily.PREV_ROW_COLUMN.equals(cf, cq)) continue;
            extent = new KeyExtent(row, (Value)entry.getValue());
        }
        if (extent == null) {
            log.warn((Object)("No prev-row for key extent: " + decodedRow));
            return null;
        }
        return new TabletLocationState(extent, future, current, last, walogs, chopped);
    }

    private TabletLocationState fetch() {
        try {
            Map.Entry<Key, Value> e = this.iter.next();
            return MetaDataTableScanner.createTabletLocationState(e.getKey(), e.getValue());
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        catch (TabletLocationState.BadLocationStateException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public void remove() {
        throw new RuntimeException("Unimplemented");
    }
}

