/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.master.state;

import java.io.IOException;
import java.util.List;
import org.apache.accumulo.core.Constants;
import org.apache.accumulo.core.zookeeper.ZooUtil;
import org.apache.accumulo.fate.zookeeper.ZooUtil;
import org.apache.accumulo.server.client.HdfsZooInstance;
import org.apache.accumulo.server.master.state.DistributedStore;
import org.apache.accumulo.server.master.state.DistributedStoreException;
import org.apache.accumulo.server.zookeeper.ZooCache;
import org.apache.accumulo.server.zookeeper.ZooReaderWriter;
import org.apache.log4j.Logger;

public class ZooStore
implements DistributedStore {
    private static final Logger log = Logger.getLogger(ZooStore.class);
    String basePath;
    ZooCache cache = new ZooCache();

    public ZooStore(String basePath) throws IOException {
        if (basePath.endsWith("/")) {
            basePath = basePath.substring(0, basePath.length() - 1);
        }
        this.basePath = basePath;
    }

    public ZooStore() throws IOException {
        this(ZooUtil.getRoot((String)HdfsZooInstance.getInstance().getInstanceID()));
    }

    @Override
    public byte[] get(String path) throws DistributedStoreException {
        try {
            return this.cache.get(this.relative(path));
        }
        catch (Exception ex) {
            throw new DistributedStoreException(ex);
        }
    }

    private String relative(String path) {
        return this.basePath + path;
    }

    @Override
    public List<String> getChildren(String path) throws DistributedStoreException {
        try {
            return this.cache.getChildren(this.relative(path));
        }
        catch (Exception ex) {
            throw new DistributedStoreException(ex);
        }
    }

    @Override
    public void put(String path, byte[] bs) throws DistributedStoreException {
        try {
            path = this.relative(path);
            ZooReaderWriter.getInstance().putPersistentData(path, bs, ZooUtil.NodeExistsPolicy.OVERWRITE);
            this.cache.clear();
            log.debug((Object)("Wrote " + new String(bs, Constants.UTF8) + " to " + path));
        }
        catch (Exception ex) {
            throw new DistributedStoreException(ex);
        }
    }

    @Override
    public void remove(String path) throws DistributedStoreException {
        try {
            log.debug((Object)("Removing " + path));
            path = this.relative(path);
            ZooReaderWriter zoo = ZooReaderWriter.getInstance();
            if (zoo.exists(path)) {
                zoo.recursiveDelete(path, ZooUtil.NodeMissingPolicy.SKIP);
            }
            this.cache.clear();
        }
        catch (Exception ex) {
            throw new DistributedStoreException(ex);
        }
    }
}

