/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.master.state;

import com.google.common.net.HostAndPort;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.apache.accumulo.core.Constants;
import org.apache.accumulo.core.metadata.RootTable;
import org.apache.accumulo.core.tabletserver.log.LogEntry;
import org.apache.accumulo.server.master.state.Assignment;
import org.apache.accumulo.server.master.state.ClosableIterator;
import org.apache.accumulo.server.master.state.DistributedStore;
import org.apache.accumulo.server.master.state.DistributedStoreException;
import org.apache.accumulo.server.master.state.TServerInstance;
import org.apache.accumulo.server.master.state.TabletLocationState;
import org.apache.accumulo.server.master.state.TabletStateStore;
import org.apache.accumulo.server.master.state.ZooStore;
import org.apache.commons.lang.NotImplementedException;
import org.apache.log4j.Logger;

public class ZooTabletStateStore
extends TabletStateStore {
    private static final Logger log = Logger.getLogger(ZooTabletStateStore.class);
    private final DistributedStore store;

    public ZooTabletStateStore(DistributedStore store) {
        this.store = store;
    }

    public ZooTabletStateStore() throws DistributedStoreException {
        try {
            this.store = new ZooStore();
        }
        catch (IOException ex) {
            throw new DistributedStoreException(ex);
        }
    }

    @Override
    public ClosableIterator<TabletLocationState> iterator() {
        return new ClosableIterator<TabletLocationState>(){
            boolean finished = false;

            @Override
            public boolean hasNext() {
                return !this.finished;
            }

            @Override
            public TabletLocationState next() {
                this.finished = true;
                try {
                    byte[] future = ZooTabletStateStore.this.store.get("/root_tablet/future_location");
                    byte[] current = ZooTabletStateStore.this.store.get("/root_tablet/location");
                    byte[] last = ZooTabletStateStore.this.store.get("/root_tablet/lastlocation");
                    TServerInstance currentSession = null;
                    TServerInstance futureSession = null;
                    TServerInstance lastSession = null;
                    if (future != null) {
                        futureSession = ZooTabletStateStore.this.parse(future);
                    }
                    if (last != null) {
                        lastSession = ZooTabletStateStore.this.parse(last);
                    }
                    if (current != null) {
                        currentSession = ZooTabletStateStore.this.parse(current);
                        futureSession = null;
                    }
                    ArrayList<Collection<String>> logs = new ArrayList<Collection<String>>();
                    for (String entry : ZooTabletStateStore.this.store.getChildren("/root_tablet/walogs")) {
                        byte[] logInfo = ZooTabletStateStore.this.store.get("/root_tablet/walogs/" + entry);
                        if (logInfo == null) continue;
                        LogEntry logEntry = new LogEntry();
                        logEntry.fromBytes(logInfo);
                        logs.add(logEntry.logSet);
                        log.debug((Object)("root tablet logSet " + logEntry.logSet));
                    }
                    TabletLocationState result = new TabletLocationState(RootTable.EXTENT, futureSession, currentSession, lastSession, logs, false);
                    log.debug((Object)("Returning root tablet state: " + result));
                    return result;
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
            }

            @Override
            public void remove() {
                throw new NotImplementedException();
            }

            @Override
            public void close() {
            }
        };
    }

    protected TServerInstance parse(byte[] current) {
        String str = new String(current, Constants.UTF8);
        String[] parts = str.split("[|]", 2);
        HostAndPort address = HostAndPort.fromString((String)parts[0]);
        if (parts.length > 1 && parts[1] != null && parts[1].length() > 0) {
            return new TServerInstance(address, parts[1]);
        }
        return null;
    }

    @Override
    public void setFutureLocations(Collection<Assignment> assignments) throws DistributedStoreException {
        if (assignments.size() != 1) {
            throw new IllegalArgumentException("There is only one root tablet");
        }
        Assignment assignment = assignments.iterator().next();
        if (assignment.tablet.compareTo(RootTable.EXTENT) != 0) {
            throw new IllegalArgumentException("You can only store the root tablet location");
        }
        String value = assignment.server.getLocation() + "|" + assignment.server.getSession();
        Iterator currentIter = this.iterator();
        TabletLocationState current = (TabletLocationState)currentIter.next();
        if (current.current != null) {
            throw new DistributedStoreException("Trying to set the root tablet location: it is already set to " + current.current);
        }
        this.store.put("/root_tablet/future_location", value.getBytes(Constants.UTF8));
    }

    @Override
    public void setLocations(Collection<Assignment> assignments) throws DistributedStoreException {
        if (assignments.size() != 1) {
            throw new IllegalArgumentException("There is only one root tablet");
        }
        Assignment assignment = assignments.iterator().next();
        if (assignment.tablet.compareTo(RootTable.EXTENT) != 0) {
            throw new IllegalArgumentException("You can only store the root tablet location");
        }
        String value = assignment.server.getLocation() + "|" + assignment.server.getSession();
        Iterator currentIter = this.iterator();
        TabletLocationState current = (TabletLocationState)currentIter.next();
        if (current.current != null) {
            throw new DistributedStoreException("Trying to set the root tablet location: it is already set to " + current.current);
        }
        if (!current.future.equals(assignment.server)) {
            throw new DistributedStoreException("Root tablet is already assigned to " + current.future);
        }
        this.store.put("/root_tablet/location", value.getBytes(Constants.UTF8));
        this.store.put("/root_tablet/lastlocation", value.getBytes(Constants.UTF8));
        this.store.remove("/root_tablet/future_location");
        log.debug((Object)"Put down root tablet location");
    }

    @Override
    public void unassign(Collection<TabletLocationState> tablets) throws DistributedStoreException {
        if (tablets.size() != 1) {
            throw new IllegalArgumentException("There is only one root tablet");
        }
        TabletLocationState tls = tablets.iterator().next();
        if (tls.extent.compareTo(RootTable.EXTENT) != 0) {
            throw new IllegalArgumentException("You can only store the root tablet location");
        }
        this.store.remove("/root_tablet/location");
        this.store.remove("/root_tablet/future_location");
        log.debug((Object)"unassign root tablet location");
    }

    @Override
    public String name() {
        return "Root Table";
    }
}

