/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.security;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.impl.Tables;
import org.apache.accumulo.core.client.impl.Translator;
import org.apache.accumulo.core.client.impl.thrift.ThriftSecurityException;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.thrift.IterInfo;
import org.apache.accumulo.core.data.thrift.TColumn;
import org.apache.accumulo.core.data.thrift.TKeyExtent;
import org.apache.accumulo.core.data.thrift.TRange;
import org.apache.accumulo.core.master.thrift.FateOperation;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.security.Credentials;
import org.apache.accumulo.core.security.SystemPermission;
import org.apache.accumulo.core.security.TablePermission;
import org.apache.accumulo.core.security.thrift.TCredentials;
import org.apache.accumulo.core.util.ByteBufferUtil;
import org.apache.accumulo.server.client.HdfsZooInstance;
import org.apache.accumulo.server.security.SecurityOperation;
import org.apache.accumulo.server.security.SystemCredentials;
import org.apache.accumulo.server.security.handler.Authenticator;
import org.apache.accumulo.server.security.handler.Authorizor;
import org.apache.accumulo.server.security.handler.PermissionHandler;
import org.apache.hadoop.io.Text;
import org.apache.log4j.Logger;

public class AuditedSecurityOperation
extends SecurityOperation {
    public static final String AUDITLOG = "Audit";
    public static final Logger audit = Logger.getLogger((String)"Audit");
    public static final String CAN_SCAN_AUDIT_TEMPLATE = "action: scan; targetTable: %s; authorizations: %s; range: %s; columns: %s; iterators: %s; iteratorOptions: %s;";
    private static final int MAX_ELEMENTS_TO_LOG = 10;
    public static final String CAN_SCAN_BATCH_AUDIT_TEMPLATE = "action: scan; targetTable: %s; authorizations: %s; range: %s; columns: %s; iterators: %s; iteratorOptions: %s;";
    public static final String CHANGE_AUTHORIZATIONS_AUDIT_TEMPLATE = "action: changeAuthorizations; targetUser: %s; authorizations: %s";
    public static final String CHANGE_PASSWORD_AUDIT_TEMPLATE = "action: changePassword; targetUser: %s;";
    public static final String CREATE_USER_AUDIT_TEMPLATE = "action: createUser; targetUser: %s; Authorizations: %s;";
    public static final String CAN_CREATE_TABLE_AUDIT_TEMPLATE = "action: createTable; targetTable: %s;";
    public static final String CAN_DELETE_TABLE_AUDIT_TEMPLATE = "action: deleteTable; targetTable: %s;";
    public static final String CAN_RENAME_TABLE_AUDIT_TEMPLATE = "action: renameTable; targetTable: %s; newTableName: %s;";
    public static final String CAN_CLONE_TABLE_AUDIT_TEMPLATE = "action: cloneTable; targetTable: %s; newTableName: %s";
    public static final String CAN_DELETE_RANGE_AUDIT_TEMPLATE = "action: deleteData; targetTable: %s; startRange: %s; endRange: %s;";
    public static final String CAN_BULK_IMPORT_AUDIT_TEMPLATE = "action: bulkImport; targetTable: %s; dataDir: %s; failDir: %s;";
    public static final String CAN_IMPORT_AUDIT_TEMPLATE = "action: import; targetTable: %s; dataDir: %s;";
    public static final String CAN_EXPORT_AUDIT_TEMPLATE = "action: export; targetTable: %s; dataDir: %s;";
    public static final String DROP_USER_AUDIT_TEMPLATE = "action: dropUser; targetUser: %s;";
    public static final String GRANT_SYSTEM_PERMISSION_AUDIT_TEMPLATE = "action: grantSystemPermission; permission: %s; targetUser: %s;";
    public static final String GRANT_TABLE_PERMISSION_AUDIT_TEMPLATE = "action: grantTablePermission; permission: %s; targetTable: %s; targetUser: %s;";
    public static final String REVOKE_SYSTEM_PERMISSION_AUDIT_TEMPLATE = "action: revokeSystemPermission; permission: %s; targetUser: %s;";
    public static final String REVOKE_TABLE_PERMISSION_AUDIT_TEMPLATE = "action: revokeTablePermission; permission: %s; targetTable: %s; targetUser: %s;";
    public static final String CAN_ONLINE_OFFLINE_TABLE_AUDIT_TEMPLATE = "action: %s; targetTable: %s;";

    public AuditedSecurityOperation(Authorizor author, Authenticator authent, PermissionHandler pm, String instanceId) {
        super(author, authent, pm, instanceId);
    }

    public static synchronized SecurityOperation getInstance() {
        String instanceId = HdfsZooInstance.getInstance().getInstanceID();
        return AuditedSecurityOperation.getInstance(instanceId, false);
    }

    public static synchronized SecurityOperation getInstance(String instanceId, boolean initialize) {
        if (instance == null) {
            instance = new AuditedSecurityOperation(AuditedSecurityOperation.getAuthorizor(instanceId, initialize), AuditedSecurityOperation.getAuthenticator(instanceId, initialize), AuditedSecurityOperation.getPermHandler(instanceId, initialize), instanceId);
        }
        return instance;
    }

    private static String getTableName(String tableId) {
        try {
            return Tables.getTableName((Instance)HdfsZooInstance.getInstance(), (String)tableId);
        }
        catch (TableNotFoundException e) {
            return "Unknown Table with ID " + tableId;
        }
    }

    public static StringBuilder getAuthString(List<ByteBuffer> authorizations) {
        StringBuilder auths = new StringBuilder();
        for (ByteBuffer bb : authorizations) {
            auths.append(ByteBufferUtil.toString((ByteBuffer)bb)).append(",");
        }
        return auths;
    }

    private static boolean shouldAudit(TCredentials credentials, String tableId) {
        return !tableId.equals("!0") && AuditedSecurityOperation.shouldAudit(credentials);
    }

    private static boolean shouldAudit(TCredentials credentials) {
        return !SystemCredentials.get().getToken().getClass().getName().equals(credentials.getTokenClassName());
    }

    private void audit(TCredentials credentials, ThriftSecurityException ex, String template, Object ... args) {
        audit.warn((Object)("operation: failed; user: " + credentials.getPrincipal() + "; " + String.format(template, args) + "; exception: " + ex.toString()));
    }

    private void audit(TCredentials credentials, String template, Object ... args) {
        if (AuditedSecurityOperation.shouldAudit(credentials)) {
            audit.info((Object)("operation: success; user: " + credentials.getPrincipal() + ": " + String.format(template, args)));
        }
    }

    private void audit(TCredentials credentials, boolean permitted, String template, Object ... args) {
        if (AuditedSecurityOperation.shouldAudit(credentials)) {
            String prefix = permitted ? "permitted" : "denied";
            audit.info((Object)("operation: " + prefix + "; user: " + credentials.getPrincipal() + "; " + String.format(template, args)));
        }
    }

    private static List<String> truncate(Collection<?> list) {
        ArrayList<String> result = new ArrayList<String>();
        int i = 0;
        for (Object obj : list) {
            if (i++ > 10) {
                result.add(" and " + (list.size() - 10) + " more ");
                break;
            }
            result.add(obj.toString());
        }
        return result;
    }

    @Override
    public boolean canScan(TCredentials credentials, String tableId, String namespaceId, TRange range, List<TColumn> columns, List<IterInfo> ssiList, Map<String, Map<String, String>> ssio, List<ByteBuffer> authorizations) throws ThriftSecurityException {
        if (AuditedSecurityOperation.shouldAudit(credentials, tableId)) {
            Range convertedRange = new Range(range);
            List<String> convertedColumns = AuditedSecurityOperation.truncate(Translator.translate(columns, (Translator)new Translator.TColumnTranslator()));
            String tableName = AuditedSecurityOperation.getTableName(tableId);
            try {
                boolean canScan = super.canScan(credentials, tableId, namespaceId);
                this.audit(credentials, canScan, "action: scan; targetTable: %s; authorizations: %s; range: %s; columns: %s; iterators: %s; iteratorOptions: %s;", tableName, AuditedSecurityOperation.getAuthString(authorizations), convertedRange, convertedColumns, ssiList, ssio);
                return canScan;
            }
            catch (ThriftSecurityException ex) {
                this.audit(credentials, ex, "action: scan; targetTable: %s; authorizations: %s; range: %s; columns: %s; iterators: %s; iteratorOptions: %s;", AuditedSecurityOperation.getAuthString(authorizations), tableId, convertedRange, convertedColumns, ssiList, ssio);
                throw ex;
            }
        }
        return super.canScan(credentials, tableId, namespaceId);
    }

    @Override
    public boolean canScan(TCredentials credentials, String tableId, String namespaceId, Map<TKeyExtent, List<TRange>> tbatch, List<TColumn> tcolumns, List<IterInfo> ssiList, Map<String, Map<String, String>> ssio, List<ByteBuffer> authorizations) throws ThriftSecurityException {
        if (AuditedSecurityOperation.shouldAudit(credentials, tableId)) {
            Map convertedBatch = Translator.translate(tbatch, (Translator)new Translator.TKeyExtentTranslator(), (Translator)new Translator.ListTranslator((Translator)new Translator.TRangeTranslator()));
            HashMap truncated = new HashMap();
            for (Map.Entry entry : convertedBatch.entrySet()) {
                truncated.put(entry.getKey(), AuditedSecurityOperation.truncate((Collection)entry.getValue()));
            }
            List convertedColumns = Translator.translate(tcolumns, (Translator)new Translator.TColumnTranslator());
            String tableName = AuditedSecurityOperation.getTableName(tableId);
            try {
                boolean canScan = super.canScan(credentials, tableId, namespaceId);
                this.audit(credentials, canScan, "action: scan; targetTable: %s; authorizations: %s; range: %s; columns: %s; iterators: %s; iteratorOptions: %s;", tableName, AuditedSecurityOperation.getAuthString(authorizations), truncated, convertedColumns, ssiList, ssio);
                return canScan;
            }
            catch (ThriftSecurityException ex) {
                this.audit(credentials, ex, "action: scan; targetTable: %s; authorizations: %s; range: %s; columns: %s; iterators: %s; iteratorOptions: %s;", AuditedSecurityOperation.getAuthString(authorizations), tableId, truncated, convertedColumns, ssiList, ssio);
                throw ex;
            }
        }
        return super.canScan(credentials, tableId, namespaceId);
    }

    @Override
    public void changeAuthorizations(TCredentials credentials, String user, Authorizations authorizations) throws ThriftSecurityException {
        try {
            super.changeAuthorizations(credentials, user, authorizations);
            this.audit(credentials, CHANGE_AUTHORIZATIONS_AUDIT_TEMPLATE, user, authorizations);
        }
        catch (ThriftSecurityException ex) {
            this.audit(credentials, ex, CHANGE_AUTHORIZATIONS_AUDIT_TEMPLATE, user, authorizations);
            throw ex;
        }
    }

    @Override
    public void changePassword(TCredentials credentials, Credentials newInfo) throws ThriftSecurityException {
        try {
            super.changePassword(credentials, newInfo);
            this.audit(credentials, CHANGE_PASSWORD_AUDIT_TEMPLATE, newInfo.getPrincipal());
        }
        catch (ThriftSecurityException ex) {
            this.audit(credentials, ex, CHANGE_PASSWORD_AUDIT_TEMPLATE, newInfo.getPrincipal());
            throw ex;
        }
    }

    @Override
    public void createUser(TCredentials credentials, Credentials newUser, Authorizations authorizations) throws ThriftSecurityException {
        try {
            super.createUser(credentials, newUser, authorizations);
            this.audit(credentials, CREATE_USER_AUDIT_TEMPLATE, newUser.getPrincipal(), authorizations);
        }
        catch (ThriftSecurityException ex) {
            this.audit(credentials, ex, CREATE_USER_AUDIT_TEMPLATE, newUser.getPrincipal(), authorizations);
            throw ex;
        }
    }

    @Override
    public boolean canCreateTable(TCredentials c, String tableName, String namespaceId) throws ThriftSecurityException {
        try {
            boolean result = super.canCreateTable(c, tableName, namespaceId);
            this.audit(c, result, CAN_CREATE_TABLE_AUDIT_TEMPLATE, tableName);
            return result;
        }
        catch (ThriftSecurityException ex) {
            this.audit(c, ex, CAN_CREATE_TABLE_AUDIT_TEMPLATE, tableName);
            throw ex;
        }
    }

    @Override
    public boolean canDeleteTable(TCredentials c, String tableId, String namespaceId) throws ThriftSecurityException {
        String tableName = AuditedSecurityOperation.getTableName(tableId);
        try {
            boolean result = super.canDeleteTable(c, tableId, namespaceId);
            this.audit(c, result, CAN_DELETE_TABLE_AUDIT_TEMPLATE, tableName, tableId);
            return result;
        }
        catch (ThriftSecurityException ex) {
            this.audit(c, ex, CAN_DELETE_TABLE_AUDIT_TEMPLATE, tableName, tableId);
            throw ex;
        }
    }

    @Override
    public boolean canRenameTable(TCredentials c, String tableId, String oldTableName, String newTableName, String namespaceId) throws ThriftSecurityException {
        try {
            boolean result = super.canRenameTable(c, tableId, oldTableName, newTableName, namespaceId);
            this.audit(c, result, CAN_RENAME_TABLE_AUDIT_TEMPLATE, oldTableName, newTableName);
            return result;
        }
        catch (ThriftSecurityException ex) {
            this.audit(c, ex, CAN_RENAME_TABLE_AUDIT_TEMPLATE, oldTableName, newTableName);
            throw ex;
        }
    }

    @Override
    public boolean canCloneTable(TCredentials c, String tableId, String tableName, String destinationNamespaceId, String sourceNamespaceId) throws ThriftSecurityException {
        String oldTableName = AuditedSecurityOperation.getTableName(tableId);
        try {
            boolean result = super.canCloneTable(c, tableId, tableName, destinationNamespaceId, sourceNamespaceId);
            this.audit(c, result, CAN_CLONE_TABLE_AUDIT_TEMPLATE, oldTableName, tableName);
            return result;
        }
        catch (ThriftSecurityException ex) {
            this.audit(c, ex, CAN_CLONE_TABLE_AUDIT_TEMPLATE, oldTableName, tableName);
            throw ex;
        }
    }

    @Override
    public boolean canDeleteRange(TCredentials c, String tableId, String tableName, Text startRow, Text endRow, String namespaceId) throws ThriftSecurityException {
        try {
            boolean result = super.canDeleteRange(c, tableId, tableName, startRow, endRow, namespaceId);
            this.audit(c, result, CAN_DELETE_RANGE_AUDIT_TEMPLATE, tableName, startRow.toString(), endRow.toString());
            return result;
        }
        catch (ThriftSecurityException ex) {
            this.audit(c, ex, CAN_DELETE_RANGE_AUDIT_TEMPLATE, tableName, startRow.toString(), endRow.toString());
            throw ex;
        }
    }

    @Override
    public boolean canBulkImport(TCredentials c, String tableId, String tableName, String dir, String failDir, String namespaceId) throws ThriftSecurityException {
        try {
            boolean result = super.canBulkImport(c, tableId, namespaceId);
            this.audit(c, result, CAN_BULK_IMPORT_AUDIT_TEMPLATE, tableName, dir, failDir);
            return result;
        }
        catch (ThriftSecurityException ex) {
            this.audit(c, ex, CAN_BULK_IMPORT_AUDIT_TEMPLATE, tableName, dir, failDir);
            throw ex;
        }
    }

    @Override
    public boolean canImport(TCredentials credentials, String tableName, String importDir, String namespaceId) throws ThriftSecurityException {
        try {
            boolean result = super.canImport(credentials, tableName, importDir, namespaceId);
            this.audit(credentials, result, CAN_IMPORT_AUDIT_TEMPLATE, tableName, importDir);
            return result;
        }
        catch (ThriftSecurityException ex) {
            this.audit(credentials, ex, CAN_IMPORT_AUDIT_TEMPLATE, tableName, importDir);
            throw ex;
        }
    }

    @Override
    public boolean canExport(TCredentials credentials, String tableId, String tableName, String exportDir, String namespaceId) throws ThriftSecurityException {
        try {
            boolean result = super.canExport(credentials, tableId, tableName, exportDir, namespaceId);
            this.audit(credentials, result, CAN_EXPORT_AUDIT_TEMPLATE, tableName, exportDir);
            return result;
        }
        catch (ThriftSecurityException ex) {
            this.audit(credentials, ex, CAN_EXPORT_AUDIT_TEMPLATE, tableName, exportDir);
            throw ex;
        }
    }

    @Override
    public void dropUser(TCredentials credentials, String user) throws ThriftSecurityException {
        try {
            super.dropUser(credentials, user);
            this.audit(credentials, DROP_USER_AUDIT_TEMPLATE, user);
        }
        catch (ThriftSecurityException ex) {
            this.audit(credentials, ex, DROP_USER_AUDIT_TEMPLATE, user);
            throw ex;
        }
    }

    @Override
    public void grantSystemPermission(TCredentials credentials, String user, SystemPermission permission) throws ThriftSecurityException {
        try {
            super.grantSystemPermission(credentials, user, permission);
            this.audit(credentials, GRANT_SYSTEM_PERMISSION_AUDIT_TEMPLATE, permission, user);
        }
        catch (ThriftSecurityException ex) {
            this.audit(credentials, ex, GRANT_SYSTEM_PERMISSION_AUDIT_TEMPLATE, permission, user);
            throw ex;
        }
    }

    @Override
    public void grantTablePermission(TCredentials credentials, String user, String tableId, TablePermission permission, String namespaceId) throws ThriftSecurityException {
        String tableName = AuditedSecurityOperation.getTableName(tableId);
        try {
            super.grantTablePermission(credentials, user, tableId, permission, namespaceId);
            this.audit(credentials, GRANT_TABLE_PERMISSION_AUDIT_TEMPLATE, permission, tableName, user);
        }
        catch (ThriftSecurityException ex) {
            this.audit(credentials, ex, GRANT_TABLE_PERMISSION_AUDIT_TEMPLATE, permission, tableName, user);
            throw ex;
        }
    }

    @Override
    public void revokeSystemPermission(TCredentials credentials, String user, SystemPermission permission) throws ThriftSecurityException {
        try {
            super.revokeSystemPermission(credentials, user, permission);
            this.audit(credentials, REVOKE_SYSTEM_PERMISSION_AUDIT_TEMPLATE, permission, user);
        }
        catch (ThriftSecurityException ex) {
            this.audit(credentials, ex, REVOKE_SYSTEM_PERMISSION_AUDIT_TEMPLATE, permission, user);
            throw ex;
        }
    }

    @Override
    public void revokeTablePermission(TCredentials credentials, String user, String tableId, TablePermission permission, String namespaceId) throws ThriftSecurityException {
        String tableName = AuditedSecurityOperation.getTableName(tableId);
        try {
            super.revokeTablePermission(credentials, user, tableId, permission, namespaceId);
            this.audit(credentials, REVOKE_TABLE_PERMISSION_AUDIT_TEMPLATE, permission, tableName, user);
        }
        catch (ThriftSecurityException ex) {
            this.audit(credentials, ex, REVOKE_TABLE_PERMISSION_AUDIT_TEMPLATE, permission, tableName, user);
            throw ex;
        }
    }

    @Override
    public boolean canOnlineOfflineTable(TCredentials credentials, String tableId, FateOperation op, String namespaceId) throws ThriftSecurityException {
        String tableName = AuditedSecurityOperation.getTableName(tableId);
        String operation = null;
        if (op == FateOperation.TABLE_ONLINE) {
            operation = "onlineTable";
        }
        if (op == FateOperation.TABLE_OFFLINE) {
            operation = "offlineTable";
        }
        try {
            boolean result = super.canOnlineOfflineTable(credentials, tableId, op, namespaceId);
            this.audit(credentials, result, CAN_ONLINE_OFFLINE_TABLE_AUDIT_TEMPLATE, operation, tableName, tableId);
            return result;
        }
        catch (ThriftSecurityException ex) {
            this.audit(credentials, ex, CAN_ONLINE_OFFLINE_TABLE_AUDIT_TEMPLATE, operation, tableName, tableId);
            throw ex;
        }
    }
}

